/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice;

import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelperUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ConfigServiceHelper {
    public static ConfigDataId getConfigDataId(AttributeList attrList) {
        Object val = null;
        try {
            val = ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Id");
        }
        catch (AttributeNotFoundException ex) {
            Manager.Ffdc.log(ex, ConfigServiceHelper.class, "com.ibm.websphere.management.configservice.ConfigServiceHelper.getConfigDataId", "39");
        }
        ConfigDataId id = (ConfigDataId)val;
        if (id == null) {
            id = ConfigDataId.createLocalId();
            ConfigServiceHelper.setAttributeValue(attrList, "_Websphere_Config_Data_Id", id);
        }
        return id;
    }

    public static Object getAttributeValue(AttributeList attrList, String name) throws AttributeNotFoundException {
        Object result = null;
        boolean found = false;
        for (Attribute attr : attrList) {
            if (!attr.getName().equals(name)) continue;
            result = attr.getValue();
            found = true;
            break;
        }
        if (!found) {
            throw new AttributeNotFoundException("attribute " + name + " not found");
        }
        return result;
    }

    public static void setAttributeValue(AttributeList attrList, String name, Object value) {
        ConfigServiceHelper.removeAttribute(attrList, name);
        attrList.add(new Attribute(name, value));
    }

    public static Object removeAttribute(AttributeList attrList, String name) {
        Object value = null;
        for (int i = 0; i < attrList.size(); ++i) {
            Attribute attr = (Attribute)attrList.get(i);
            if (!attr.getName().equals(name)) continue;
            value = attr.getValue();
            attrList.remove(i);
            break;
        }
        return value;
    }

    public static AttributeList lookup(AttributeList attrList, ConfigDataId id) {
        AttributeList result = null;
        ConfigDataId thisId = ConfigServiceHelper.getConfigDataId(attrList);
        if (thisId != null && thisId.equals(id)) {
            result = attrList;
        } else {
            for (Attribute attr : attrList) {
                Object val = attr.getValue();
                if (val == null) continue;
                if (val instanceof AttributeList) {
                    result = ConfigServiceHelper.lookup((AttributeList)val, id);
                    if (result == null) continue;
                    return result;
                }
                if (!(val instanceof ArrayList)) continue;
                for (Object element : (ArrayList)val) {
                    if (!(element instanceof AttributeList) || (result = ConfigServiceHelper.lookup((AttributeList)element, id)) == null) continue;
                    return result;
                }
            }
        }
        return result;
    }

    public static ObjectName createObjectName(AttributeList attrList) {
        ConfigDataId id = null;
        try {
            id = (ConfigDataId)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Id");
        }
        catch (AttributeNotFoundException ex) {
            Manager.Ffdc.log(ex, ConfigServiceHelper.class, "com.ibm.websphere.management.configservice.ConfigServiceHelper.createObjectName", "124");
        }
        String type = null;
        try {
            type = (String)ConfigServiceHelper.getAttributeValue(attrList, "_Websphere_Config_Data_Type");
        }
        catch (AttributeNotFoundException ex) {
            Manager.Ffdc.log(ex, ConfigServiceHelper.class, "com.ibm.websphere.management.configservice.ConfigServiceHelper.createObjectName", "130");
        }
        return ConfigServiceHelper.createObjectName(id, type);
    }

    public static ObjectName createObjectName(ConfigDataId id) {
        return ConfigServiceHelper.createObjectName(id, null);
    }

    public static ObjectName createObjectName(ConfigDataId id, String type) {
        return ConfigServiceHelper.createObjectName(id, type, null);
    }

    public static ObjectName createObjectName(ConfigDataId id, String type, String displayName) {
        ObjectName name = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (id != null) {
            table.put("_Websphere_Config_Data_Id", id.toString());
        }
        if (type != null) {
            table.put("_Websphere_Config_Data_Type", type);
        }
        if (displayName != null && !displayName.trim().equals("")) {
            table.put("_Websphere_Config_Data_Display_Name", displayName);
        }
        try {
            name = new ObjectName("Websphere", table);
        }
        catch (MalformedObjectNameException ex) {
            Manager.Ffdc.log(ex, ConfigServiceHelper.class, "com.ibm.websphere.management.configservice.ConfigServiceHelper.createObjectName", "171");
        }
        return name;
    }

    public static ConfigDataId getConfigDataId(ObjectName objName) {
        String id = objName.getKeyProperty("_Websphere_Config_Data_Id");
        return id == null ? null : new ConfigDataId(id);
    }

    public static String getConfigDataType(ObjectName objName) {
        return objName.getKeyProperty("_Websphere_Config_Data_Type");
    }

    public static String getDisplayName(ObjectName objName) {
        return objName.getKeyProperty("_Websphere_Config_Data_Display_Name");
    }

    public static boolean checkIfNameValid(String aName) {
        return ConfigServiceHelperUtils.checkIfNameValid(aName);
    }

    public static Properties getObjectLocation(ObjectName objName) {
        String id = ConfigServiceHelper.getConfigDataId(objName).getContextUri();
        Properties result = new Properties();
        StringTokenizer tokenizer = new StringTokenizer(id, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String key = null;
            if (token.equals("cells")) {
                key = "cell";
            } else if (token.equals("nodes")) {
                key = "node";
            } else if (token.equals("servers")) {
                key = "server";
            } else if (token.equals("clusters")) {
                key = "cluster";
            } else if (token.equals("applications")) {
                key = "application";
            } else if (token.equals("versions")) {
                key = "version";
            } else if (token.equals("servertypes")) {
                key = "servertype";
            }
            if (key == null || !tokenizer.hasMoreTokens()) continue;
            result.setProperty(key, tokenizer.nextToken());
        }
        return result;
    }

    public static ConfigDataId convertObjectNameToConfigDataId(ObjectName on) {
        StringBuffer buf = new StringBuffer("");
        String mbeanId = on.getKeyProperty("mbeanIdentifier");
        if (mbeanId != null) {
            int slash = mbeanId.lastIndexOf(47);
            if (slash >= 0 && mbeanId.substring(slash, mbeanId.length()).indexOf(".xml") >= 0) {
                buf.append(mbeanId.substring(0, slash));
                buf.append(":");
                buf.append(mbeanId.substring(slash + 1));
            } else {
                buf.append(mbeanId);
            }
        }
        return new ConfigDataId(buf.toString());
    }

    public static ObjectName createObjectName(Properties props) throws MalformedObjectNameException {
        return ConfigServiceHelper.createObjectName("Websphere", props);
    }

    public static ObjectName createObjectName(String domain, Properties props) throws MalformedObjectNameException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        Enumeration<?> propNames = props.propertyNames();
        while (propNames != null && propNames.hasMoreElements()) {
            String pName = (String)propNames.nextElement();
            String pValue = (String)props.get(pName);
            table.put(pName, pValue);
        }
        return new ObjectName(domain, table);
    }
}

