/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice;

import java.io.Serializable;

public class ConfigDataId
implements Serializable {
    private static final long serialVersionUID = 7618627032319811532L;
    private static long max_local_id = 0L;
    public static final char delimiter = '|';
    private static final char hrefDelimiter = '#';
    private String contextUri;
    private final String href;
    private boolean isLocal = false;

    public ConfigDataId(String contextUri, String href) {
        if (contextUri == null) {
            contextUri = " ";
        }
        this.contextUri = contextUri;
        this.href = href;
    }

    public ConfigDataId(String id) {
        int index = id.lastIndexOf(124);
        this.href = index == id.length() - 1 ? null : id.substring(index + 1);
        String part1 = index == -1 ? "" : id.substring(0, index);
        index = part1.lastIndexOf(124);
        this.contextUri = index == -1 ? part1 : part1.substring(index + 1);
        this.isLocal = index != -1 && part1.substring(0, index).equals("local");
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof ConfigDataId) {
            ConfigDataId that = (ConfigDataId)obj;
            result = this.isLocal == that.isLocal && this.equals(this.href, that.href) && this.equals(this.contextUri, that.contextUri);
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isResolved() {
        return this.isLocal() || this.href.indexOf(35) != -1;
    }

    public String getContextUri() {
        return this.contextUri;
    }

    public String getHref() {
        return this.href;
    }

    private boolean equals(String x, String y) {
        return x == y || x != null && x.equals(y);
    }

    public String toString() {
        return (this.isLocal ? "local|" : "") + this.contextUri + '|' + (this.href == null ? "" : this.href);
    }

    public static synchronized ConfigDataId createLocalId() {
        String local_id = "local_reference_id_" + max_local_id++;
        ConfigDataId localId = new ConfigDataId(null, local_id);
        localId.isLocal = true;
        return localId;
    }

    public static synchronized ConfigDataId createLocalId(String id) {
        ConfigDataId localId = new ConfigDataId(null, id);
        localId.isLocal = true;
        return localId;
    }
}

