/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandHistory;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataFactory;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commanddata.GenericObjectValue;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import java.util.Collection;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AbstractCommandStep
extends AbstractAdminCommand
implements CommandStep {
    private static TraceComponent tc = Tr.register(AbstractCommandStep.class, "AbstractCommandStep", "com.ibm.websphere.management.resources.cmdframework");
    protected AbstractTaskCommand taskCmd = null;
    private boolean initialized = false;

    public AbstractCommandStep(AbstractTaskCommand parent, CommandMetadata metadata) {
        super(metadata);
        this.taskCmd = parent;
    }

    public AbstractCommandStep(AbstractTaskCommand parent, CommandData commandData) throws CommandNotFoundException {
        super(commandData);
        this.taskCmd = parent;
    }

    public static CommandMetadata getCommandMetadata(String cmdName) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetadata", cmdName);
        }
        CommandStepMetadata stepMetadata = null;
        Set commandList = (Set)CommandMetadataMgr.getInstance().listCommands();
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "commandlist is " + commandList);
        }
        for (String commandName : commandList) {
            CommandMetadata cmdMetadata;
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "command name is " + commandName);
            }
            if ((cmdMetadata = CommandMetadataMgr.getInstance().getCommandMetadata(commandName)) instanceof TaskCommandMetadata) {
                for (CommandStepMetadata temp : ((TaskCommandMetadata)cmdMetadata).getSteps()) {
                    if (!temp.getName().equals(cmdName)) continue;
                    stepMetadata = temp;
                    break;
                }
            }
            if (stepMetadata == null) continue;
            break;
        }
        if (stepMetadata == null) {
            throw new CommandNotFoundException(cmdName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandMetadata", stepMetadata);
        }
        return stepMetadata;
    }

    public boolean isEnabled() {
        return this.getCommandStepData().isEnabled();
    }

    protected boolean isLocalMode() {
        return this.taskCmd.isLocalMode();
    }

    public final int hashcode() {
        return this.getName().hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CommandStep)) {
            return false;
        }
        return this.getName().equals(((CommandStep)obj).getName());
    }

    protected CommandData initCommandData() {
        CommandStepData result = CommandDataFactory.eINSTANCE.createCommandStepData();
        result.setEnabled(true);
        return result;
    }

    public final CommandStepData getCommandStepData() {
        return (CommandStepData)this.getCommandData();
    }

    public final void resetCommandData(CommandData stepData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetCommandData", stepData);
        }
        int stepIndex = -1;
        EList stepDataCollection = this.taskCmd.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stepDataCollection ", stepDataCollection);
        }
        CommandData currentStepData = this.getCommandData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "currentStepData ", currentStepData);
        }
        for (int i = 0; i < stepDataCollection.size(); ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stepDataCollection name " + i + " is", ((CommandData)stepDataCollection.get(i)).getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentStepData name is  ", currentStepData.getName());
            }
            if (!((CommandData)stepDataCollection.get(i)).getName().equals(currentStepData.getName())) continue;
            stepIndex = i;
            break;
        }
        if (stepIndex == -1) {
            stepDataCollection.add(stepData);
        } else {
            stepDataCollection.set(stepIndex, stepData);
        }
        super.resetCommandData(stepData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetCommandData");
        }
    }

    public final void execute(CommandHistory cmdHistory) {
        throw new UnsupportedOperationException();
    }

    public final void execute() {
        throw new UnsupportedOperationException();
    }

    public Collection listSetParams(int rowIndex) throws IndexOutOfBoundsException {
        return super.listSetParams(rowIndex);
    }

    public Object getParameter(String parameterName, int rowIndex) throws InvalidParameterNameException, IndexOutOfBoundsException {
        return super.getParameter(parameterName, rowIndex);
    }

    public void setParameter(String paramName, Object value, int rowIndex) throws InvalidParameterValueException, InvalidParameterNameException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{paramName, value, new Integer(rowIndex)});
        }
        super.setParameter(paramName, value, rowIndex);
        this.setListSetParamsTable(rowIndex, paramName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }

    public int getNumberOfRows() {
        return this.getCommandData().getCmdParams().size();
    }

    protected void initializeRow(AttributeList rowData, int rowIndex) throws InvalidParameterValueException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeAddRow", new Object[]{rowData, new Integer(rowIndex)});
        }
        this.addRow(rowData, rowIndex, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeAddRow");
        }
    }

    public void addRow(AttributeList rowData, int rowIndex) throws InvalidParameterValueException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRow", new Object[]{rowData, new Integer(rowIndex)});
        }
        this.addRow(rowData, rowIndex, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRow");
        }
    }

    private void addRow(AttributeList rowData, int rowIndex, boolean isProvider) throws InvalidParameterValueException, IndexOutOfBoundsException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addRow", new Object[]{rowData, new Integer(rowIndex), new Boolean(isProvider)});
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "table is " + this.isTable() + " adddeleteRow is " + this.addDeleteRowAllowed());
            }
            if (!this.isTable() || !isProvider && !this.addDeleteRowAllowed()) {
                throw new UnsupportedOperationException();
            }
            EObject paramData = null;
            EList params = this.getCommandData().getCmdParams();
            try {
                paramData = this.createParamEObject();
                for (Attribute attr : rowData) {
                    String parameterName = attr.getName();
                    if (this.isParamReadonly(parameterName) && !isProvider) {
                        throw new InvalidParameterValueException(this.getName(), parameterName, attr.getValue());
                    }
                    EStructuralFeature sf = paramData.eClass().getEStructuralFeature(parameterName);
                    if (sf instanceof EAttribute) {
                        paramData.eSet(sf, attr.getValue());
                    } else {
                        GenericObjectValue sfValue = (GenericObjectValue)paramData.eGet(sf);
                        if (sfValue == null) {
                            sfValue = CommandDataFactory.eINSTANCE.createGenericObjectValue();
                            paramData.eSet(sf, sfValue);
                        }
                        sfValue.setValue(attr.getValue());
                    }
                    if (isProvider) continue;
                    this.setListSetParamsTable(rowIndex, parameterName);
                }
                params.add(rowIndex, paramData);
            }
            catch (CommandNotFoundException ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.commandframework.provider.AbstractCommandStep", "260");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occured. " + ex);
                }
            }
            catch (InvalidParameterNameException ipne) {
                Manager.Ffdc.log(ipne, this, "com.ibm.websphere.management.commandframework.provider.AbstractCommandStep", "263");
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Exception occured. " + ipne);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRow");
        }
    }

    public void deleteRow(int rowIndex) throws UnsupportedOperationException {
        if (!this.isTable() || !this.addDeleteRowAllowed()) {
            throw new UnsupportedOperationException();
        }
        EList params = this.getCommandData().getCmdParams();
        params.remove(rowIndex);
    }

    protected final boolean isTable() {
        return ((CommandStepMetadata)this.getCommandMetadata()).isTable();
    }

    protected final EObject createParamEObject() throws CommandNotFoundException {
        CommandMetadata cmdMetadata = this.taskCmd.getCommandMetadata();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createParamEObject, cmd: " + this.taskCmd.getName() + ", cmd metadata: @" + Integer.toHexString(cmdMetadata.hashCode()), cmdMetadata);
        }
        return CommandMetadataMgr.getInstance().createParamDataEObject(this.taskCmd.getName(), this.getName(), cmdMetadata);
    }

    public void stepModified(String stepName) throws CommandException {
    }

    public void commandParamModified() {
    }

    public void validate() throws CommandValidationException {
        if (this.isEnabled()) {
            super.validate();
        }
    }

    protected void taskCommandExecuted(boolean success, boolean executed) {
    }

    protected void executeStep() {
    }

    protected void initializeStep() throws CommandException {
    }

    void initStep() throws CommandException {
        if (!this.initialized) {
            this.initializeStep();
            this.initialized = true;
        }
    }

    public boolean isRequired() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRequired");
        }
        boolean ret = false;
        CommandMetadata metadata = this.getCommandMetadata();
        EList paramsMetadata = metadata.getParameters();
        for (ParameterMetadata paramMetadata : paramsMetadata) {
            String paramName = paramMetadata.getName();
            Object paramVal = null;
            try {
                paramVal = this.getParameter(paramName);
            }
            catch (InvalidParameterNameException ex) {
                // empty catch block
            }
            if (!paramMetadata.isRequired() || paramVal != null) continue;
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRequired - " + ret);
        }
        return ret;
    }

    public Session getConfigSession() {
        return this.taskCmd.getConfigSession();
    }

    public boolean isRequired(int rowIndex) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRequired - " + rowIndex);
        }
        boolean ret = false;
        CommandMetadata metadata = this.getCommandMetadata();
        EList paramsMetadata = metadata.getParameters();
        for (ParameterMetadata paramMetadata : paramsMetadata) {
            String paramName = paramMetadata.getName();
            Object paramVal = null;
            try {
                paramVal = this.getParameter(paramName, rowIndex);
            }
            catch (InvalidParameterNameException ex) {
                // empty catch block
            }
            if (!paramMetadata.isRequired() || paramVal != null) continue;
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRequired - " + ret);
        }
        return ret;
    }

    public Object[] getChoices(String paramName, int rowIndex) {
        return this.getChoices(paramName);
    }

    private boolean addDeleteRowAllowed() {
        CommandStepMetadata metadata = (CommandStepMetadata)this.getCommandMetadata();
        return metadata.isEnableAddRows();
    }
}

