/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework;

import com.ibm.websphere.management.cmdframework.CommandException;

public class CommandNotFoundException
extends CommandException {
    private static final long serialVersionUID = -3249986785063934786L;
    private String taskCmdName = null;
    private String stepName = null;
    private String cmdName = null;

    public CommandNotFoundException(String cmdName) {
        super("Command or command group " + cmdName + " is not found");
        this.cmdName = cmdName;
    }

    public CommandNotFoundException(String taskCmdName, String stepName) {
        super("Task command" + taskCmdName + " step " + stepName + " is not found.");
        this.taskCmdName = taskCmdName;
        this.stepName = stepName;
    }

    public String getMessage() {
        if (this.cmdName != null) {
            return nls.getFormattedMessage("ADMF0005E", new Object[]{this.cmdName}, null);
        }
        if (this.taskCmdName != null) {
            return nls.getFormattedMessage("ADMF0006E", new Object[]{this.taskCmdName, this.stepName}, null);
        }
        return super.getMessage();
    }
}

