/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataPackage;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class CommandHistory {
    private static TraceComponent tc = Tr.register(CommandHistory.class, "CommandHistory", "com.ibm.websphere.management.cmdframework");
    private int size = 20;
    private Vector history;

    public CommandHistory() {
        this(20);
    }

    public CommandHistory(int initSize) {
        this.size = initSize;
        this.history = new Vector(this.size);
    }

    public void add(CommandData adminCmdData) {
        if (this.history.size() >= this.size) {
            this.history.remove(0);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "commanddata added is " + adminCmdData);
        }
        this.history.add(adminCmdData);
    }

    public void clear() {
        this.history.clear();
    }

    public Collection getHistory() {
        ArrayList<AbstractAdminCommand> historyArrayList = new ArrayList<AbstractAdminCommand>();
        for (int i = 0; i < this.history.size(); ++i) {
            try {
                CommandData historyCmdData = (CommandData)this.history.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "commanddata got is " + historyCmdData);
                }
                String commandName = historyCmdData.getName();
                AbstractAdminCommand historyCommand = CommandMetadataMgr.getInstance().getCommandProvider(commandName).loadCommand(historyCmdData);
                historyArrayList.add(historyCommand);
                continue;
            }
            catch (CommandNotFoundException cnfe) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Command not found " + ((CommandData)this.history.get(i)).getName());
                continue;
            }
            catch (CommandLoadException cle) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Command cannot be loaded " + ((CommandData)this.history.get(i)).getName());
            }
        }
        return historyArrayList;
    }

    public void save(OutputStream os) {
        block4: {
            ResourceSetImpl resSet = new ResourceSetImpl();
            XMIResourceImpl res = new XMIResourceImpl();
            res.setURI(URI.createURI("History.xmi"));
            EList resList = res.getContents();
            for (int i = 0; i < this.history.size(); ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "\nHistory to save is " + ((CommandData)this.history.get(i)).getName());
                }
                resList.add((CommandData)this.history.get(i));
            }
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("DECLARE_XML", Boolean.TRUE);
                res.save(os, options);
            }
            catch (IOException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.error(tc, e.getMessage());
            }
        }
    }

    public void load(InputStream is) {
        block4: {
            CommandDataPackage cmddataPackage = CommandDataPackage.eINSTANCE;
            try {
                ResourceSetImpl resSet = new ResourceSetImpl();
                XMIResourceImpl res = new XMIResourceImpl();
                res.setURI(URI.createURI("History.xmi"));
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("DECLARE_XML", Boolean.FALSE);
                res.load(is, options);
                EList resList = res.getContents();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "\nSize of stored history is " + resList.size() + "\n");
                }
                for (int i = 0; i < resList.size(); ++i) {
                    this.add((CommandData)resList.get(i));
                }
            }
            catch (IOException ioe) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.error(tc, ioe.getMessage());
            }
        }
    }
}

