/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.ws.management.application.J2EEAppDeployment;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Hashtable;

public class AppManagementBaseFactory {
    private static TraceComponent tc = Tr.register(AppManagementBaseFactory.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String implName = "com.ibm.ws.management.application.AppManagementImpl";
    private static final String j2eeImplName = "com.ibm.ws.management.application.J2EEAppDeploymentImpl";

    public static AppManagement createLocalAppManagementImpl() {
        String configRoot = System.getProperty("was.repository.root");
        return AppManagementBaseFactory._createAppManagementImpl(configRoot);
    }

    public static AppManagement createLocalAppManagementImpl(String wasRoot) {
        String configRoot = System.getProperty("was.repository.root");
        return AppManagementBaseFactory._createAppManagementImpl(configRoot);
    }

    private static AppManagement _createAppManagementImpl(String cRoot) {
        Hashtable<String, String> tbl = new Hashtable<String, String>();
        tbl.put("Temp extraction dir for multiserver", AppManagementBaseFactory.getTempExtractDir());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configroot: " + cRoot);
        }
        if (cRoot != null) {
            tbl.put("Config Root for variable map", cRoot);
        }
        try {
            Class<?> cls = Class.forName(implName);
            Constructor<?> c = cls.getConstructor(Hashtable.class);
            return (AppManagement)c.newInstance(tbl);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private static J2EEAppDeployment _createJ2EEAppDeploymentImpl(String cRoot) {
        Hashtable<String, String> tbl = new Hashtable<String, String>();
        tbl.put("Temp extraction dir for multiserver", AppManagementBaseFactory.getTempExtractDir());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "configroot: " + cRoot);
        }
        tbl.put("Config Root for variable map", cRoot);
        try {
            Class<?> cls = Class.forName(j2eeImplName);
            Constructor<?> c = cls.getConstructor(Hashtable.class);
            return (J2EEAppDeployment)c.newInstance(tbl);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static void initMBean(String configRoot, String cellName, String nodeName, String processName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initMBean");
        }
        AppManagement impl = AppManagementBaseFactory._createAppManagementImpl(configRoot);
        AdminServiceFactory.getMBeanFactory().activateMBean("AppManagement", (RuntimeCollaborator)((Object)impl), "AppManagement", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Activated AppManegementMBean");
        }
        J2EEAppDeployment j2eeImpl = AppManagementBaseFactory._createJ2EEAppDeploymentImpl(configRoot);
        AdminServiceFactory.getMBeanFactory().activateMBean("J2EEAppDeployment", (RuntimeCollaborator)((Object)j2eeImpl), "J2EEAppDeployment", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Activated J2EEAppDeploymentMBean");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process Type: " + AdminServiceFactory.getAdminService().getProcessType());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initMBean");
        }
    }

    public static String getTempExtractDir() {
        String tempRoot;
        block5: {
            tempRoot = null;
            try {
                Object strObj;
                Field field;
                Class<?> cls = Class.forName("com.ibm.ws.sm.workspace.impl.WorkSpaceConstant");
                if (cls != null && (field = cls.getDeclaredField("WORKSPACE_PATH_NAME")) != null && (strObj = field.get(null)) instanceof String) {
                    String str;
                    tempRoot = str = (String)strObj;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result using reflection", tempRoot);
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception recieved", e);
            }
        }
        if (tempRoot != null) {
            tempRoot = System.getProperty("user.install.root") == null ? System.getProperty("java.io.tmpdir") : tempRoot + File.separator + "wstemp";
        }
        return tempRoot + File.separator;
    }
}

