/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.management.AdminServiceFactoryInitializer;

public class AdminServiceFactory {
    private static TraceComponent tc = Tr.register(AdminServiceFactory.class, null, null);
    private static AdminService instance = null;
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");

    public static AdminService getAdminService() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminService");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(adminPermission);
        }
        String adminType = AdminServiceFactoryInitializer.getAdminType();
        String uuid = AdminContext.peek();
        if ("AdminAgent".equals(adminType) || uuid != null) {
            AdminService service = AdminServiceFactoryInitializer.createAdminService();
            if (service == null) {
                return null;
            }
            return AdminServiceFactoryInitializer.getProxy();
        }
        if (instance == null) {
            instance = AdminServiceFactoryInitializer.createAdminService();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminService", instance);
        }
        return instance;
    }

    public static MBeanFactory getMBeanFactory() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(adminPermission);
        }
        String profileKey = AdminContext.peek();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Profile key ", profileKey);
        }
        if (profileKey != null) {
            AdminService service;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMBeanFactory", profileKey);
            }
            if ((service = AdminServiceFactoryInitializer.createAdminService()) == null) {
                return null;
            }
            return service.getMBeanFactory();
        }
        if (instance == null) {
            return null;
        }
        return instance.getMBeanFactory();
    }
}

