/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging;

import java.util.Hashtable;

public class MessageConverter {
    public static short MESSAGE_ID_V5;
    public static short MESSAGE_ID_V6;
    public static short MESSAGE_ID_UNKNOWN;
    public static short CONVERSION_TYPE_WASV5_TO_WASV6;
    public static short CONVERSION_TYPE_WASV6_TO_WASV5;
    private static Hashtable svConversionTableV5_To_V6;
    private static Hashtable svConversionTableV6_To_V5;

    private MessageConverter() {
    }

    public static String convert(String in, short conversionType) {
        int len = in.length();
        if (len < 7) {
            return in;
        }
        if (conversionType == CONVERSION_TYPE_WASV5_TO_WASV6) {
            String inKey = in.substring(0, 4);
            String outKey = (String)svConversionTableV5_To_V6.get(inKey);
            if (outKey == null) {
                return in;
            }
            StringBuffer out = new StringBuffer(outKey);
            out.append(in.substring(4));
            return out.toString();
        }
        if (conversionType == CONVERSION_TYPE_WASV6_TO_WASV5) {
            String inKey = in.substring(0, 5);
            String outKey = (String)svConversionTableV6_To_V5.get(inKey);
            if (outKey == null) {
                return in;
            }
            StringBuffer out = new StringBuffer(outKey);
            out.append(in.substring(5));
            return out.toString();
        }
        return in;
    }

    public static short determineMsgType(String msgId) {
        char[] lm;
        if (msgId.length() >= 9) {
            lm = new char[9];
            msgId.getChars(0, 9, lm, 0);
            if (lm[8] >= '0' && lm[8] <= '9' && lm[7] >= '0' && lm[7] <= '9' && lm[6] >= '0' && lm[6] <= '9' && lm[5] >= '0' && lm[5] <= '9' && lm[4] >= 'A' && lm[4] <= 'Z' && lm[3] >= 'A' && lm[3] <= 'Z' && lm[2] >= 'A' && lm[2] <= 'Z' && lm[1] >= 'A' && lm[1] <= 'Z' && lm[0] >= 'A' && lm[0] <= 'Z') {
                return MESSAGE_ID_V6;
            }
        }
        if (msgId.length() >= 8) {
            lm = new char[8];
            msgId.getChars(0, 8, lm, 0);
            if (lm[7] >= '0' && lm[7] <= '9' && lm[6] >= '0' && lm[6] <= '9' && lm[5] >= '0' && lm[5] <= '9' && lm[4] >= '0' && lm[4] <= '9' && lm[3] >= 'A' && lm[3] <= 'Z' && lm[2] >= 'A' && lm[2] <= 'Z' && lm[1] >= 'A' && lm[1] <= 'Z' && lm[0] >= 'A' && lm[0] <= 'Z') {
                return MESSAGE_ID_V5;
            }
        }
        return MESSAGE_ID_UNKNOWN;
    }

    static {
        int i;
        MESSAGE_ID_V5 = 1;
        MESSAGE_ID_V6 = (short)2;
        MESSAGE_ID_UNKNOWN = (short)-1;
        CONVERSION_TYPE_WASV5_TO_WASV6 = 1;
        CONVERSION_TYPE_WASV6_TO_WASV5 = (short)2;
        String[][] mappings = new String[][]{{"AATL", "CWWAT"}, {"ACIN", "CWNIC"}, {"ACWA", "CWWWA"}, {"ADEN", "CWLDE"}, {"ADFS", "CWWFS"}, {"ADMA", "CWWMA"}, {"ADMC", "CWWMC"}, {"ADMD", "CWWMD"}, {"ADME", "CWWME"}, {"ADMF", "CWWMF"}, {"ADMG", "CWWMG"}, {"ADML", "CWWML"}, {"ADMN", "CWWMN"}, {"ADMR", "CWWMR"}, {"ADMS", "CWWMS"}, {"ADMT", "CWWMT"}, {"ADMU", "CWWMU"}, {"AGNT", "CWWAG"}, {"APPR", "CWWAP"}, {"ARFM", "CWRFM"}, {"ARFM", "CWRFM"}, {"ARFM", "CWRFM"}, {"ASDN", "CWSND"}, {"ASYN", "CWWAB"}, {"BCDS", "CWWCD"}, {"BNDE", "CWWAA"}, {"BOAL", "CWLAK"}, {"BOBG", "CWMBO"}, {"BOSU", "CWLAJ"}, {"BPBN", "CWWCB"}, {"BPEx", "CWWBX"}, {"BRLS", "CWLBR"}, {"BRLT", "CWLBT"}, {"BRLW", "CWLBW"}, {"CHFW", "CWWCF"}, {"CHFW", "CWWCF"}, {"CHKC", "CWPKC"}, {"CHKJ", "CWWCJ"}, {"CHKP", "CWPKH"}, {"CHKS", "CWWCS"}, {"CHKW", "CWWCW"}, {"CHKX", "CWXKH"}, {"CLFY", "CWLFY"}, {"CLNI", "CWWCL"}, {"CMDT", "CWLBM"}, {"CMSG", "CWWMS"}, {"CMPN", "CWWCP"}, {"CNTR", "CWWEC"}, {"CONM", "CWWCM"}, {"CORB", "CWWOR"}, {"CSCP", "CWSCP"}, {"CSTM", "CWSTM"}, {"CSTT", "CWSTT"}, {"CWMN", "CWMNA"}, {"CWMS", "CWMSR"}, {"DBMN", "CWWDM"}, {"DCPA", "CWWPA"}, {"DCPC", "CWWPC"}, {"DCSV", "CWRCS"}, {"DCWM", "CWMWC"}, {"DRSW", "CWWDR"}, {"DSRA", "CWWRA"}, {"DWCT", "CWWCT"}, {"DWLM", "CWLDM"}, {"DYNA", "CWWDY"}, {"EAAT", "CWTAA"}, {"ECNS", "CWSNC"}, {"EMSG", "CWWEM"}, {"ENTP", "CWWIE"}, {"ESLB", "CWWLB"}, {"ESOP", "CWSPE"}, {"FFDC", "CWRDC"}, {"FLWx", "CWWFC"}, {"GATE", "CWRCB"}, {"GBNF", "CWNFB"}, {"HAMI", "CWMAH"}, {"HMGR", "CWRHA"}, {"HTPC", "CWTPC"}, {"HTPT", "CWTPT"}, {"I18N", "CWWWI"}, {"ILMC", "CWLMC"}, {"INST", "CWWIN"}, {"INVU", "CWNVU"}, {"IOPC", "CWORB"}, {"IVTL", "CWWIV"}, {"IWBI", "CWWBI"}, {"J2CA", "CWWJC"}, {"JACC", "CWWJA"}, {"JORB", "CWWJO"}, {"JSAS", "CWWSA"}, {"JSCA", "CWSCA"}, {"JSPG", "CWWJS"}, {"JSSL", "CWWJE"}, {"JSSM", "CWLBH"}, {"LARD", "CWLRD"}, {"LMMS", "CWLAA"}, {"LMSC", "CWLAB"}, {"LTXT", "CWLTX"}, {"MDNT", "CWLAV"}, {"MDTN", "CWLAU"}, {"MONC", "CWLBY"}, {"MONE", "CWLBZ"}, {"MONI", "CWLBV"}, {"MONM", "CWLBU"}, {"MONP", "CWLBX"}, {"MONS", "CWLBS"}, {"MPST", "CWLAT"}, {"MPSV", "CWLAS"}, {"MSGS", "CWMSG"}, {"MIGR", "CWMGR"}, {"NANA", "CWLHS"}, {"NMSV", "CWNMS"}, {"OBPL", "CWOBP"}, {"OCSP", "CWOCS"}, {"ODCF", "CWODC"}, {"ORBX", "CWORX"}, {"PLCY", "CWLCY"}, {"PLGC", "CWPLC"}, {"PLGN", "CWPLG"}, {"PLPR", "CWLPR"}, {"PLYI", "CWLYI"}, {"PMGR", "CWCPM"}, {"PMON", "CWPMI"}, {"PMRM", "CWPRM"}, {"PMWC", "CWPMW"}, {"PROX", "CWPRX"}, {"PROC", "CWPRC"}, {"RASD", "CWRSD"}, {"RCOV", "CWRCV"}, {"RCVM", "CWRCM"}, {"RGUS", "CWRGS"}, {"SCHD", "CWSCH"}, {"SCNT", "CWSCT"}, {"SECG", "CWSCG"}, {"SECJ", "CWSCJ"}, {"SESN", "CWSEN"}, {"SFWT", "CWSFT"}, {"SIAP", "CWSIA"}, {"SIAS", "CWSID"}, {"SICJ", "CWSIJ"}, {"SICM", "CWSIQ"}, {"SICO", "CWSIC"}, {"SICR", "CWSIR"}, {"SICS", "CWSIB"}, {"SIEG", "CWSIG"}, {"SIEX", "CWSIE"}, {"SIFP", "CWSIF"}, {"SIME", "CWSIM"}, {"SIMP", "CWSIP"}, {"SIMS", "CWSIS"}, {"SIMX", "CWSIN"}, {"SIOD", "CWSIO"}, {"SIPC", "CWSPC"}, {"SISE", "CWSII"}, {"SITO", "CWSIT"}, {"SIUT", "CWSIU"}, {"SJMS", "CWSJM"}, {"SLFW", "CWLFW"}, {"SMTL", "CWSMT"}, {"SOAP", "CWSOP"}, {"SPRX", "CWSPX"}, {"SRMC", "CWSRM"}, {"SRVE", "CWSRV"}, {"SRVU", "CWSFU"}, {"SSIN", "CWLAL"}, {"SSLC", "CWSSL"}, {"SSNC", "CWLAM"}, {"SSNP", "CWLAN"}, {"SSNT", "CWLAO"}, {"STAT", "CWSTA"}, {"STFF", "CWSTF"}, {"STUP", "CWSTU"}, {"TASK", "CWTSK"}, {"TCPC", "CWTCP"}, {"TEST", "CWTST"}, {"TPVE", "CWTPV"}, {"TRAS", "CWTRA"}, {"TUNE", "CWTUN"}, {"UPDI", "CWUPI"}, {"UTLS", "CWUTL"}, {"WACS", "CWWAC"}, {"WACT", "CWWAV"}, {"WADR", "CWWAR"}, {"WAFL", "CWLAG"}, {"WALI", "CWLAH"}, {"WALS", "CWLAI"}, {"WASX", "CWWAX"}, {"WBAC", "CWMAC"}, {"WBAD", "CWMAD"}, {"WBAE", "CWMAE"}, {"WBAF", "CWMAF"}, {"WBAG", "CWMAG"}, {"WBAI", "CWMAI"}, {"WBAJ", "CWMAJ"}, {"WBAK", "CWMAK"}, {"WBAL", "CWMAL"}, {"WBAM", "CWMAM"}, {"WBAN", "CWMAN"}, {"WBID", "CWLBQ"}, {"WBIM", "CWLBP"}, {"WBIS", "CWLWS"}, {"WBOS", "CWLBN"}, {"WBSF", "CWLSF"}, {"WCDW", "CWWDW"}, {"WCFW", "CWLBO"}, {"WCLD", "CWWCL"}, {"WCMD", "CWSMC"}, {"WDBC", "CWLAC"}, {"WDWL", "CWWWL"}, {"WEMB", "CWWMB"}, {"WEWS", "CWWES"}, {"WHFW", "CWWHF"}, {"WHWA", "CWWHA"}, {"WHWC", "CWWHC"}, {"WICS", "CWWIC"}, {"WINT", "CWWNT"}, {"WJSJ", "CWLAX"}, {"WJST", "CWLAW"}, {"WKPF", "CWRKP"}, {"WKSP", "CWWKP"}, {"WKSQ", "CWWKQ"}, {"WLCB", "CWLCB"}, {"WLMF", "CWLMF"}, {"WLRB", "CWLRB"}, {"WLRE", "CWLRE"}, {"WLRS", "CWLRS"}, {"WLTC", "CWWLT"}, {"WMBP", "CWMBP"}, {"WMCO", "CWMCO"}, {"WMSG", "CWMSS"}, {"WOBA", "CWWOA"}, {"WOBJ", "CWOBJ"}, {"WORM", "CWORM"}, {"WPIV", "CWPIV"}, {"WPIZ", "CWPIZ"}, {"WPKI", "CWPKI"}, {"WPMO", "CWPMO"}, {"WPOL", "CWWPO"}, {"WPRS", "CWWPS"}, {"WPSS", "CWLAD"}, {"WPVR", "CWPVR"}, {"WQBA", "CWQBA"}, {"WQRY", "CWQRY"}, {"WRLS", "CWRLS"}, {"WRSS", "CWLAE"}, {"WRST", "CWLAF"}, {"WSBI", "CWSBI"}, {"WSCL", "CWWSC"}, {"WSCP", "CWWAD"}, {"WSDH", "CWSDH"}, {"WSEC", "CWWSI"}, {"WSGW", "CWWSG"}, {"WSIF", "CWWSF"}, {"WSIF", "CWWSF"}, {"WSIM", "CWWIM"}, {"WSJD", "CWSJD"}, {"WSJG", "CWSJG"}, {"WSJW", "CWSJW"}, {"WSMM", "CWWMM"}, {"WSMS", "CWWME"}, {"WSPL", "CWWPL"}, {"WSPN", "CWSPN"}, {"WSRB", "CWSRB"}, {"WSSC", "CWSSC"}, {"WSUP", "CWWSU"}, {"WSVM", "CWWVM"}, {"WSVR", "CWWSR"}, {"WSWS", "CWWWS"}, {"WTMS", "CWTMS"}, {"WTRN", "CWWTR"}, {"WTSK", "CWWTK"}, {"WUDC", "CWUDC"}, {"WUDU", "CWWDD"}, {"WUNG", "CWUNG"}, {"WUPD", "CWUPD"}, {"WUPM", "CWWPM"}, {"WURM", "CWURM"}, {"WUTM", "CWUTM"}, {"WUXD", "CWUXD"}, {"WVAB", "CWVAB"}, {"WVAC", "CWVAC"}, {"WVAD", "CWVAD"}, {"WVAE", "CWVAE"}, {"WVAI", "CWVAI"}, {"WVCC", "CWVCC"}, {"WVCM", "CWVCM"}, {"WVCS", "CWVCS"}, {"WVCX", "CWVCX"}, {"WVDS", "CWVDS"}, {"WVDT", "CWVDT"}, {"WVER", "CWWVR"}, {"WVGC", "CWVGC"}, {"WVGM", "CWVGM"}, {"WVIN", "CWVIN"}, {"WVLB", "CWVLB"}, {"WVMC", "CWVMC"}, {"WVMD", "CWVMD"}, {"WVPT", "CWVPT"}, {"WVRB", "CWVRB"}, {"WVRR", "CWVRR"}, {"WVRT", "CWVRT"}, {"WVSA", "CWVSA"}, {"WVSB", "CWVSB"}, {"WVSC", "CWVSC"}, {"WVSM", "CWVSM"}, {"WVSY", "CWVSY"}, {"WVTB", "CWVTB"}, {"WVTC", "CWVTC"}, {"WVTE", "CWVTE"}, {"WVTM", "CWVTM"}, {"WVVX", "CWVVX"}, {"WWBA", "CWWBA"}, {"WWEI", "CWWEI"}, {"WWLM", "CWWLM"}, {"WPFC", "CWPFC"}, {"WWSM", "CWWSM"}, {"WXAE", "CWXAE"}, {"WXAR", "CWXAR"}, {"WXCS", "CWXCS"}, {"WXDH", "CWXDH"}, {"WXDO", "CWXDO"}, {"WXDP", "CWXDP"}, {"WXDR", "CWXDR"}, {"WXDV", "CWXDV"}, {"WXDW", "CWXDW"}, {"WXDX", "CWXDX"}, {"WXMI", "CWXMI"}, {"XADC", "CWXDC"}, {"XADM", "CWXDM"}, {"XBGA", "CWLGA"}, {"XBGS", "CWLGS"}, {"XDIN", "CWWXI"}, {"XDRT", "CWXRT"}, {"XDUT", "CWXDU"}, {"XHAD", "CWXHA"}, {"XMEM", "CWXME"}, {"XMLM", "CWXMM"}, {"XNMI", "CWXNM"}, {"XREP", "CWXRP"}, {"ZAIO", "CWZAI"}, {"ZGBC", "CWZGB"}};
        svConversionTableV5_To_V6 = new Hashtable();
        for (i = 0; i < mappings.length; ++i) {
            svConversionTableV5_To_V6.put(mappings[i][0], mappings[i][1]);
        }
        svConversionTableV6_To_V5 = new Hashtable();
        for (i = 0; i < mappings.length; ++i) {
            svConversionTableV6_To_V5.put(mappings[i][1], mappings[i][0]);
        }
        String[][] stringArray = null;
    }
}

