/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.command.CommandTarget;
import com.ibm.websphere.command.TargetPolicy;
import com.ibm.websphere.command.TargetableCommand;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.beans.Beans;
import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Hashtable;

public class TargetPolicyDefault
implements TargetPolicy,
Serializable {
    private static final TraceComponent _tc = Tr.register(TargetPolicyDefault.class);
    private static final long serialVersionUID = 8533555590544760338L;
    protected Dictionary mapping = new Hashtable();
    protected Hashtable targetTable = new Hashtable();
    protected String defaultTargetName = "com.ibm.websphere.command.LocalTarget";
    protected transient CommandTarget defaultTarget = null;

    public CommandTarget getCommandTarget(TargetableCommand command) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCommandTarget", command);
        }
        CommandTarget target = null;
        target = command.getCommandTarget();
        if (target != null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getCommandTarget", target);
            }
            return target;
        }
        String targetName = command.getCommandTargetName();
        if (targetName == null) {
            String commandName = command.getClass().getName();
            targetName = (String)this.mapping.get(commandName);
        }
        if (targetName == null) {
            if (this.defaultTarget == null && this.defaultTargetName != null) {
                try {
                    this.defaultTarget = (CommandTarget)Beans.instantiate(this.getContextClassLoaderPrivileged(), this.defaultTargetName);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.websphere.command.TargetPolicyDefault.getCommandTarget", "134", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "executeCommand", e);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "executeCommand", "Beans.instantiate() failed " + e.getMessage());
                    }
                    e.printStackTrace();
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getCommandTarget", this.defaultTarget);
                    }
                    return this.defaultTarget;
                }
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getCommandTarget", this.defaultTarget);
            }
            return this.defaultTarget;
        }
        target = (CommandTarget)this.targetTable.get(targetName);
        if (target == null) {
            Object targetClass = null;
            try {
                Object targetObj = Beans.instantiate(this.getContextClassLoaderPrivileged(), targetName);
                target = (CommandTarget)targetObj;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.websphere.command.TargetPolicyDefault.getCommandTarget", "157", this);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "executeCommand", e);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "executeCommand", "Beans.instantiate() failed " + e.getMessage());
                }
                e.printStackTrace();
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getCommandTarget", this.defaultTarget);
                }
                return this.defaultTarget;
            }
            this.targetTable.put(targetName, target);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCommandTarget", target);
        }
        return target;
    }

    private ClassLoader getContextClassLoaderPrivileged() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContextClassLoaderPrivileged");
        }
        ClassLoader ldr = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getContextClassLoaderPrivileged", ldr);
        }
        return ldr;
    }

    public Dictionary listMappings() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "listMappings");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "listMappings", this.mapping);
        }
        return this.mapping;
    }

    public void registerCommand(String commandBeanName, String targetBeanName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "registerCommand", new Object[]{commandBeanName, targetBeanName});
        }
        this.mapping.put(commandBeanName, targetBeanName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "registerCommand");
        }
    }

    public void setDefaultTargetName(String defaultTargetName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setDefaultTargetName", defaultTargetName);
        }
        this.defaultTargetName = defaultTargetName;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setDefaultTargetName");
        }
    }

    public void unregisterCommand(String commandBeanName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "unregisterCommand", commandBeanName);
        }
        this.mapping.remove(commandBeanName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "unregisterCommand");
        }
    }
}

