/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.Factory;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPool;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPoolFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class DescriptionFactory {
    private static final TraceComponent tc = Tr.register(DescriptionFactory.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final String TYPE_MEMBER_ADDED = "member.added";
    public static final String TYPE_MEMBER_REMOVED = "member.removed";
    public static final String TYPE_ADD_EXTRINSIC = "type.add.extrinsic";
    public static final String TYPE_REMOVE_EXTRINSIC = "type.remove.extrinsic";
    public static final String TYPE_CLUSTER_WEIGHT = "type.cluster.weight.update";
    public static final String TYPE_CLUSTER_UPDATED = "type.cluster.updated";
    public static final String TYPE_MEMENTO_UPDATED = "type.memento.updated";
    public static final String CLUSTER_ACTIVE = "cluster.active";
    public static final String CLUSTER_DEACTIVE = "cluster.deactive";
    public static final String TYPE_CLUSTER_SCOPED_DATA_ADDED = "type.cluster.scoped.data.added";
    public static final String TYPE_CLUSTER_SCOPED_DATA_REMOVED = "type.cluster.scoped.data.removed";
    public static final String TYPE_MEMBER_SCOPED_DATA_ADDED = "type.member.scoped.data.added";
    private static final DescriptionFactory instance;
    private static final SleeperThreadPool pool;
    private Map coIdentifiers = Collections.synchronizedMap(new HashMap());
    private ThreadLocal recursion = new ThreadLocal();
    private Map defKeyToRefQHolder = new HashMap();

    private DescriptionFactory() {
    }

    public static DescriptionFactory getInstance() {
        return instance;
    }

    public Description createDescription(DescriptionKey key, String implKey) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDescription", new Object[]{key, implKey});
        }
        Class descriptionClass = Factory.loadClass(implKey);
        Constructor constructor = descriptionClass.getConstructor(DescriptionKey.class);
        Description result = (Description)constructor.newInstance(key);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDescription");
        }
        return result;
    }

    public Description createLocalDescription(DescriptionKey key, String implementationKey) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLocalDescription", new Object[]{key, implementationKey});
        }
        DescriptionA result = (DescriptionA)this.createDescription(key, implementationKey);
        result.setLocal();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createLocalDescription");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerNotificationListener(DescriptionModificationListener listener, String key, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerNotificationListener", new Object[]{listener, key, type});
        }
        Map map = this.coIdentifiers;
        synchronized (map) {
            ReferenceQueue refQueue;
            HashSet<WeakReference<DescriptionModificationListener>> listenersSet;
            HashMap typeToRefQueue;
            HashMap types = (HashMap)this.coIdentifiers.get(key);
            if (types == null) {
                types = new HashMap();
                this.coIdentifiers.put(key, types);
            }
            if ((typeToRefQueue = (HashMap)this.defKeyToRefQHolder.get(key)) == null) {
                typeToRefQueue = new HashMap();
                this.defKeyToRefQHolder.put(key, typeToRefQueue);
            }
            if ((listenersSet = (HashSet<WeakReference<DescriptionModificationListener>>)types.get(type)) == null) {
                listenersSet = new HashSet<WeakReference<DescriptionModificationListener>>();
                types.put(type, listenersSet);
            }
            if ((refQueue = (ReferenceQueue)typeToRefQueue.get(type)) == null) {
                refQueue = new ReferenceQueue();
                typeToRefQueue.put(type, refQueue);
            }
            listenersSet.add(new WeakReference<DescriptionModificationListener>(listener, refQueue));
            this.purge(listenersSet, refQueue);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerNotificationListener", this);
        }
    }

    public synchronized void deregisterNotificationListener(DescriptionModificationListener listener, String key, String type) {
        Map types;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterNotificationListener", new Object[]{listener, key, type});
        }
        if ((types = (Map)this.coIdentifiers.get(key)) != null) {
            Set listenersSet = (Set)types.get(type);
            if (listener != null && listenersSet != null) {
                Iterator iter = listenersSet.iterator();
                while (iter != null && iter.hasNext()) {
                    WeakReference wr = (WeakReference)iter.next();
                    if (listener != wr.get()) continue;
                    boolean removed = listenersSet.remove(wr);
                    if (!tc.isDebugEnabled()) continue;
                    if (removed) {
                        Tr.debug(tc, "deregisterNotificationListener removed listener", listener);
                        continue;
                    }
                    Tr.debug(tc, "Unexpected deregisterNotificationListener listener not removed", new Object[]{listener, listenersSet.toString()});
                }
            }
            if (listenersSet == null || listenersSet.isEmpty()) {
                Object removedType = types.remove(type);
                if (tc.isDebugEnabled()) {
                    if (removedType != null) {
                        Tr.debug(tc, "deregisterNotificationListener removed notification", type);
                    } else {
                        Tr.debug(tc, "Unexpected deregisterNotificationListener notification not removed", type);
                    }
                }
                if (types == null || types.isEmpty()) {
                    Object removedIdentity = this.coIdentifiers.remove(key);
                    if (tc.isDebugEnabled()) {
                        if (removedIdentity != null) {
                            Tr.debug(tc, "deregisterNotificationListener cleared ref", key);
                        } else {
                            Tr.debug(tc, "Unexpected deregisterNotificationListener ref did not exist", key);
                        }
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unexpected empty notification in deregisterNotificationListener");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterNotificationListener", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(DescriptionKey key, String type, Object data) {
        Description description = DescriptionManagerFactory.getDescriptionManager().getDescription(key);
        if (description == null) {
            Tr.event(tc, "unexpected description was null", key);
            return;
        }
        String definitionKey = description.getDefinitionKey();
        if (this.coIdentifiers.containsKey(definitionKey)) {
            HashSet<DescriptionKey> keys;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "notifyListeners", new Object[]{key, type, data});
            }
            if ((keys = (HashSet<DescriptionKey>)this.recursion.get()) == null) {
                keys = new HashSet<DescriptionKey>();
                this.recursion.set(keys);
            }
            if (!keys.contains(key)) {
                try {
                    keys.add(key);
                    Notifier notify = new Notifier(key, definitionKey, type, data);
                    if (type.equals(TYPE_MEMBER_ADDED)) {
                        pool.RunInTimeOrder(notify, 1500);
                    } else {
                        pool.Run(notify);
                    }
                }
                finally {
                    keys.remove(key);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "notifyListeners", this.recursion.get());
            }
        }
    }

    private void purge(Set listenersSet, ReferenceQueue refQueue) {
        WeakReference ref = null;
        while ((ref = (WeakReference)refQueue.poll()) != null) {
            listenersSet.remove(ref);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "purge", ref);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.coIdentifiers.size() + "]";
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.30 ");
        }
        instance = new DescriptionFactory();
        pool = SleeperThreadPoolFactory.getInstance();
    }

    private final class Notifier
    implements Runnable {
        private final DescriptionKey key;
        private final String definitionKey;
        private final String type;
        private final Object data;

        private Notifier(DescriptionKey key, String definitionKey, String type, Object data) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>", new Object[]{definitionKey, type, data});
            }
            this.key = key;
            this.definitionKey = definitionKey;
            this.type = type;
            this.data = data;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>");
            }
        }

        public void run() {
            HashSet listenerSet;
            HashSet clonedListenerSet;
            Map nullListeners;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run notifier", this);
            }
            HashMap types = new HashMap();
            Map definitionKeyListeners = (Map)DescriptionFactory.this.coIdentifiers.get(this.definitionKey);
            if (definitionKeyListeners != null) {
                types.putAll(definitionKeyListeners);
            }
            if ((nullListeners = (Map)DescriptionFactory.this.coIdentifiers.get(null)) != null) {
                types.putAll(nullListeners);
            }
            if ((clonedListenerSet = (HashSet)(listenerSet = (HashSet)types.get(this.type)).clone()) != null) {
                Iterator iter = clonedListenerSet.iterator();
                while (iter != null && iter.hasNext()) {
                    DescriptionModificationListener listener;
                    WeakReference ref = (WeakReference)iter.next();
                    DescriptionModificationListener descriptionModificationListener = listener = ref == null ? null : (DescriptionModificationListener)ref.get();
                    if (listener != null) {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "calling observer", listener);
                            }
                            listener.handleNotification(this.key, this.type, this.data, null);
                        }
                        catch (Exception e) {
                            FFDCFilter.processException(e, DescriptionFactory.class.getName() + ".notifyListeners", "173", this, new Object[]{listener});
                            if (!tc.isEventEnabled()) continue;
                            Tr.event(tc, "unexpected exception processing notification.", new Object[]{listener, e});
                        }
                        continue;
                    }
                    if (definitionKeyListeners == null || (listenerSet = (HashSet)definitionKeyListeners.get(this.type)) == null) continue;
                    listenerSet.remove(ref);
                    if (!listenerSet.isEmpty() || definitionKeyListeners == null) continue;
                    definitionKeyListeners.remove(this.type);
                    if (!definitionKeyListeners.isEmpty() || DescriptionFactory.this.coIdentifiers == null) continue;
                    DescriptionFactory.this.coIdentifiers.remove(this.definitionKey);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run notifier");
            }
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o instanceof Notifier) {
                Notifier other = (Notifier)o;
                return other.key.equals(this.key) && other.definitionKey.equals(this.definitionKey) && other.type.equals(this.type) && other.data.equals(this.data);
            }
            return result;
        }

        public int hashCode() {
            return this.key.hashCode() & this.definitionKey.hashCode() & this.type.hashCode() & this.data.hashCode();
        }

        public String toString() {
            return super.toString() + "[" + this.key + " " + this.type + " " + this.definitionKey + " " + this.data + "]";
        }
    }
}

