/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import com.ibm.security.krb5.wss.util.XMLUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;

public class MiscUtils {
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public static final String makeDateTime() {
        Date d = new Date();
        return MiscUtils.formatDateTime(d);
    }

    public static final String formatDateTime(Date d) {
        if (d == null) {
            return null;
        }
        return df.format(d);
    }

    public static final Date parseDateTime(String s) {
        if (s == null) {
            return null;
        }
        try {
            Date d = df.parse(s);
            return d;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Node insertCommentBefore(Node parent, Node commentMe) {
        String cPrefix = "The unencrypted form of the following is\n\n";
        String cPostlude = "\n\n";
        Node newNode = commentMe.cloneNode(true);
        Comment commentKey = commentMe.getOwnerDocument().createComment(cPrefix + XMLUtil.getStringUnchanged(newNode) + cPostlude);
        parent.insertBefore(commentKey, commentMe);
        return commentMe;
    }

    public static Node insertCommentBefore(Node parent, Node commentMe, Node beforeMe) {
        String cPrefix = "The unencrypted form of the following is\n\n";
        String cPostlude = "\n\n";
        Comment commentKey = commentMe.getOwnerDocument().createComment(cPrefix + XMLUtil.getStringUnchanged(commentMe) + cPostlude);
        parent.insertBefore(commentKey, beforeMe);
        return commentMe;
    }

    private MiscUtils() {
    }

    static {
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

