/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import com.ibm.security.krb5.wss.util.I2Dom;
import com.ibm.security.krb5.wss.util.LocalConstants;
import com.ibm.security.krb5.wss.util.Programmable;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import java.security.MessageDigest;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyIdentifier
extends Programmable
implements I2Dom,
LocalConstants {
    public static final String VALUETYPE = "ValueType";
    public static final String ENCODINGTYPE = "EncodingType";
    public static final String VALUE = "value";
    public static final String PREFIX = "prefix";

    public KeyIdentifier() {
        super(KeyIdentifier.class);
        this.put(PREFIX, "wsse");
    }

    public KeyIdentifier(Map settings) {
        super(KeyIdentifier.class, settings);
    }

    @Override
    public Element toDom(Document factory) {
        Element e = factory.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
        String pfix = (String)this.props.get(PREFIX);
        if (pfix != null) {
            e.setPrefix(pfix);
        }
        e.setAttribute(VALUETYPE, (String)this.props.get(VALUETYPE));
        String value = null;
        Object obj = this.props.get(VALUE);
        byte[] output = null;
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update((byte[])obj);
            output = sha1.digest();
        }
        catch (Exception ex) {
            throw new RuntimeException("SHA provider needed");
        }
        if (obj != null) {
            value = Base64.encode(output);
        }
        if (value == null) {
            throw new RuntimeException("need value");
        }
        e.appendChild(factory.createTextNode(value));
        return e;
    }
}

