/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class KeyAndCert {
    private Key key;
    private Certificate cert;

    public KeyAndCert(String b64CertS) {
        this.cert = KeyAndCert.getCertFromString(b64CertS);
        this.key = this.cert.getPublicKey();
    }

    public KeyAndCert(Key thisKey, Certificate thisCert) {
        this.key = thisKey;
        this.cert = thisCert;
    }

    public Key getKey() {
        return this.key;
    }

    public Certificate getCert() {
        return this.cert;
    }

    public static Key getPubKeyFromCertString(String certS) {
        PublicKey answer = null;
        String phaseMessage = "converting to Certificate";
        try {
            Certificate cert = KeyAndCert.getCertFromString(certS);
            phaseMessage = "getting key from cert";
            answer = cert.getPublicKey();
        }
        catch (Exception e) {
            throw new RuntimeException(phaseMessage);
        }
        return answer;
    }

    public static Certificate getCertFromString(String certS) {
        X509Certificate answer = null;
        String phaseMessage = "converting to Certificate";
        try {
            X509Certificate cert;
            byte[] certB = Base64.decode(certS);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            answer = cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certB));
        }
        catch (Exception e) {
            throw new RuntimeException(phaseMessage);
        }
        return answer;
    }
}

