/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import com.ibm.security.krb5.wss.util.LocalConstants;
import com.ibm.security.krb5.wss.util.WsuIdResolver;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.ExclusiveC11r;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DsigServices
implements LocalConstants {
    public static Element makeDataReferenceList(Document factory, String[] uris, String prefix, boolean nsdecl) {
        String fudge = "";
        Element rl = factory.createElementNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
        if (prefix != null) {
            rl.setPrefix(prefix);
            fudge = ":" + prefix;
            prefix = prefix + ":";
        } else {
            prefix = "";
        }
        if (nsdecl) {
            rl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns" + fudge, "http://www.w3.org/2001/04/xmlenc#");
        }
        for (int i = 0; i < uris.length; ++i) {
            Element data = factory.createElementNS("http://www.w3.org/2001/04/xmlenc#", prefix + "DataReference");
            data.setAttribute("URI", "#" + uris[i]);
            rl.appendChild(data);
        }
        return rl;
    }

    public static void removeFromDataReferenceList(Element dataRef, String uri) {
        if (!uri.startsWith("#")) {
            uri = "#" + uri;
        }
        NodeList suspects = dataRef.getChildNodes();
        Element current = null;
        String attr = null;
        for (int i = 0; i < suspects.getLength(); ++i) {
            current = (Element)suspects.item(i);
            attr = current.getAttribute("URI");
            if (!attr.equals(uri)) continue;
            dataRef.removeChild(current);
            break;
        }
    }

    public static void verifyThisSignature(Element sig, Key verifyKey) {
        SignatureContext sText = new SignatureContext();
        sText.setAlgorithmFactory(AlgorithmFactory.getInstance());
        sText.setIDResolver((IDResolver)new WsuIdResolver());
        Validity vlid = sText.verify(sig, verifyKey);
        if (!vlid.getCoreValidity()) {
            throw new RuntimeException(DsigServices.debugVerifyFailure(sig.getOwnerDocument(), sig, vlid));
        }
    }

    public static void verifyNthSignature(Document in, Key verifyKey, int whichSig) {
        SignatureContext sText = new SignatureContext();
        sText.setAlgorithmFactory(AlgorithmFactory.getInstance());
        sText.setIDResolver((IDResolver)new WsuIdResolver());
        NodeList nl = in.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        Element sig = (Element)nl.item(whichSig);
        Validity vlid = sText.verify(sig, verifyKey);
        if (!vlid.getCoreValidity()) {
            throw new RuntimeException(DsigServices.debugVerifyFailure(in, sig, vlid));
        }
    }

    public static void verifyNthSignature(Element in, Key verifyKey, int whichSig) {
        SignatureContext sText = new SignatureContext();
        sText.setAlgorithmFactory(AlgorithmFactory.getInstance());
        sText.setIDResolver((IDResolver)new WsuIdResolver());
        NodeList nl = in.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        Element sig = (Element)nl.item(whichSig);
        Validity vlid = sText.verify(sig, verifyKey);
        if (!vlid.getCoreValidity()) {
            throw new RuntimeException(DsigServices.debugVerifyFailure(in.getOwnerDocument(), sig, vlid));
        }
    }

    public static void verifyLastSignature(Document in, Key verifyKey) {
        NodeList nl = in.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        DsigServices.verifyNthSignature(in, verifyKey, nl.getLength() - 1);
    }

    private static String debugVerifyFailure(Document in, Element sig, Validity vlid) {
        String failure = "signature validation failed";
        for (int i = 0; i < vlid.getNumberOfReferences(); ++i) {
            if (vlid.getReferenceValidity(i)) continue;
            failure = failure + " on URI " + vlid.getReferenceURI(i) + " because " + vlid.getReferenceMessage(i);
            Element elem = new MyIDResolver().resolveID(in, vlid.getReferenceURI(i).substring(1));
            if (elem == null) continue;
            ExclusiveC11r excC11 = new ExclusiveC11r();
            try {
                FileOutputStream fo = new FileOutputStream("c14n.txt");
                excC11.canonicalize((Node)elem, (OutputStream)fo);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return failure;
    }

    private static class MyIDResolver
    implements IDResolver {
        private MyIDResolver() {
        }

        public Element resolveID(Document doc, String id) {
            Element answer = null;
            NodeList nl = doc.getElementsByTagName("*");
            if (nl != null) {
                Element temp = null;
                for (int i = 0; i < nl.getLength(); ++i) {
                    temp = (Element)nl.item(i);
                    Attr attr = temp.getAttributeNode("wsu:Id");
                    if (attr == null || !id.equals(attr.getValue())) continue;
                    answer = temp;
                    break;
                }
            }
            return answer;
        }
    }
}

