/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.jgss.i18n.PropertyResource;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.StringTokenizer;

public class Debug {
    public static final int OPTS_ALL = 1;
    public static final int OPTS_OFF = 2;
    public static final int OPTS_CAT_APPLICATION = 3;
    public static final int OPTS_CAT_CONTEXT = 4;
    public static final int OPTS_CAT_CREDENTIAL = 5;
    public static final int OPTS_CAT_MARSHAL = 6;
    public static final int OPTS_CAT_WRAP = 7;
    public static final int OPTS_CAT_UNMARSHAL = 8;
    private final int BITS_LEN = 9;
    private BitSet options = new BitSet(9);
    private HexDumpEncoder encoder = new HexDumpEncoder();
    private static String debug;
    private static String helpMessage;
    private static final String[] catNames;

    public Debug() {
        try {
            this.setOptions();
        }
        catch (Exception exc) {
            System.out.println("Exception in Debug constuctor: " + exc.toString());
            this.options = new BitSet(9);
        }
    }

    public Debug(BitSet options) {
        try {
            if (options != null) {
                this.options = options;
            } else {
                this.setOptions();
            }
        }
        catch (Exception exc) {
            System.out.println("Exception in Debug constuctor: " + exc.toString());
            options = new BitSet(9);
        }
    }

    public void out(int category, String msg) {
        if (category == 1 || category == 2) {
            return;
        }
        try {
            if (this.on(category)) {
                System.out.println(catNames[category] + msg);
                System.out.flush();
            }
        }
        catch (Exception exc) {
            System.out.println("Exception in Debug.out(int,String): " + exc.toString());
            this.options = new BitSet(9);
        }
    }

    public void out(int category, byte[] msg) {
        if (category == 1 || category == 2) {
            return;
        }
        try {
            if (this.on(category)) {
                if (msg == null) {
                    System.out.println(catNames[category] + "null");
                    System.out.flush();
                    return;
                }
                String hex = this.encoder.encodeBuffer(msg);
                System.out.println(catNames[category] + hex);
                System.out.flush();
            }
        }
        catch (Throwable exc) {
            this.options = new BitSet(9);
        }
    }

    void out(int category, byte[] msg, String separator) {
        this.out(category, msg);
    }

    public boolean on() {
        return this.options.get(1) || this.options.get(3) || this.options.get(4) || this.options.get(5) || this.options.get(6) || this.options.get(7) || this.options.get(8);
    }

    public boolean on(int category) {
        return this.options.get(category) || this.options.get(1);
    }

    public void set(int option) {
        if (option == 2) {
            this.options = new BitSet(9);
        } else {
            this.options.set(option);
        }
    }

    public void unset(int option) {
        if (option == 2) {
            return;
        }
        if (option == 1) {
            this.options = new BitSet(9);
        } else {
            this.options.clear(option);
        }
    }

    public String toString() {
        String str = this.getClass().getName() + "[";
        if (this.options.get(1)) {
            PropertyResource gpr = PropertyResource.getGeneralInstance();
            str = str + gpr.getString("AllCategoriesOn") + "]";
            return str;
        }
        if (!this.on()) {
            PropertyResource gpr = PropertyResource.getGeneralInstance();
            str = str + gpr.getString("Off") + "]";
            return str;
        }
        if (this.options.get(3)) {
            str = str + "cred";
        }
        if (this.options.get(4)) {
            str = str + ", context";
        }
        if (this.options.get(5)) {
            str = str + ", credential";
        }
        if (this.options.get(6)) {
            str = str + ", marshal";
        }
        if (this.options.get(7)) {
            str = str + ", wrap";
        }
        if (this.options.get(8)) {
            str = str + ", unmarshal";
        }
        str = str + "]";
        return str;
    }

    private void setOptions() {
        if (debug == null) {
            this.options.set(3);
            return;
        }
        String token = null;
        StringTokenizer strTok = new StringTokenizer(debug, ", \t\n\r\f");
        while (strTok.hasMoreTokens()) {
            token = strTok.nextToken();
            if (token.equalsIgnoreCase("off")) {
                this.options = new BitSet(9);
                return;
            }
            if (token.equalsIgnoreCase("all")) {
                this.options.set(1);
                return;
            }
            if (token.equalsIgnoreCase("app") || token.equalsIgnoreCase("application")) {
                this.options.set(3);
                continue;
            }
            if (token.equalsIgnoreCase("ctx") || token.equalsIgnoreCase("context")) {
                this.options.set(4);
                continue;
            }
            if (token.equalsIgnoreCase("wrap")) {
                this.options.set(7);
                continue;
            }
            if (token.equalsIgnoreCase("marsh") || token.equalsIgnoreCase("marshal")) {
                this.options.set(6);
                continue;
            }
            if (token.equalsIgnoreCase("unmarsh") || token.equalsIgnoreCase("unmarshal")) {
                this.options.set(8);
                continue;
            }
            if (token.equalsIgnoreCase("cred") || token.equalsIgnoreCase("credential") || token.equalsIgnoreCase("creds") || token.equalsIgnoreCase("credentials")) {
                this.options.set(5);
                continue;
            }
            if (!token.equalsIgnoreCase("help")) continue;
            System.out.println(helpMessage);
            System.out.flush();
            System.exit(1);
        }
        if (this.options.size() == 0) {
            this.options.set(3);
        }
    }

    static {
        catNames = new String[]{"[KTP_DBG_NULL] ", "[KTP_DBG_ALL] ", "[KTP_DBG_OFF] ", "[KTP_DBG_APP] ", "[KTP_DBG_CTX] ", "[KTP_DBG_CRED] ", "[KTP_DBG_MARSH] ", "[KTP_DBG_WRAP] ", "[KTP_DBG_UNMARSH] "};
        try {
            debug = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.ibm.security.ktp.debug");
                }
            });
        }
        catch (Exception exc) {
            System.err.println("Exception obtaining system ktp debug property: " + exc.toString());
            debug = null;
        }
        helpMessage = "com.ibm.security.ktp.debug is controlled by the Java property com.ibm.security.ktp.debug.\nThe property can be set to one or more values.\nMultiple values must be separated by space or comma.\nSupported values are:\n\thelp\t- outputs this message and terminates the JVM\n\tall\t- turns on debugging for all categories\n\toff\t- turns off debugging completely\n\tapp\t- application debugging, the default\n\tctx\t- context operations debugging\n\tcred\t- credentials (including name) operations\n\tmarsh\t- marshaling of tokens\n\tunmarsh\t- unmarshaling of tokens\n\tunwrap\t- unwrap operations\n\twrap\t- wrap operations.\n";
    }
}

