/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.util;

import com.ibm.security.krb5.wss.util.I2Dom;
import com.ibm.security.krb5.wss.util.KeyStoreUtils;
import com.ibm.security.krb5.wss.util.LocalConstants;
import com.ibm.security.krb5.wss.util.Programmable;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinarySecurityToken
extends Programmable
implements I2Dom,
LocalConstants {
    public static final String PREFIX = "prefix";
    public static final String VALUETYPE = "ValueType";
    public static final String ENCODINGTYPE = "EncodingType";
    public static final String CERTIFICATE = "certificate";
    public static final String BYTEARRAY = "bytearray";
    public static final String ID = "id";
    public static final String ADDNSWSU = "addnswsu";

    public BinarySecurityToken() {
        super(BinarySecurityToken.class);
        this.put(PREFIX, "wsse");
    }

    public BinarySecurityToken(Map settings) {
        super(BinarySecurityToken.class, settings);
    }

    @Override
    public Element toDom(Document factory) {
        String valtype;
        Element e = factory.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
        String prefix = (String)this.props.get(PREFIX);
        if (prefix != null) {
            e.setPrefix(prefix);
        }
        if ((valtype = (String)this.props.get(VALUETYPE)) == null) {
            throw new IllegalStateException("need ValueType");
        }
        if (!(valtype.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier") || valtype.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3") || valtype.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ") || valtype.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ@1510") || valtype.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ@4120") || valtype.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ") || valtype.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ@1510") || valtype.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ@4120"))) {
            throw new IllegalArgumentException("unknown VALUETYPE");
        }
        e.setAttribute(VALUETYPE, valtype);
        String enctype = (String)this.props.get(ENCODINGTYPE);
        if (enctype == null) {
            throw new IllegalStateException("need EncodingType");
        }
        e.setAttribute(ENCODINGTYPE, enctype);
        String id = (String)this.props.get(ID);
        if (id == null) {
            throw new IllegalStateException("need ID");
        }
        String addnswsu = (String)this.props.get(ADDNSWSU);
        if ("true".equals(addnswsu)) {
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        }
        e.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
        String output = null;
        Object obj = this.props.get(CERTIFICATE);
        if (obj == null) {
            output = Base64.encode((byte[])this.props.get(BYTEARRAY));
        } else {
            Certificate cert = (Certificate)obj;
            if (valtype.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier")) {
                output = KeyStoreUtils.getB64Skid(cert, false);
            } else {
                try {
                    output = Base64.encode(cert.getEncoded());
                }
                catch (CertificateEncodingException cee) {
                    throw new IllegalStateException("could not encode cert");
                }
            }
        }
        if (output == null) {
            throw new IllegalStateException("need Certificate or byte array");
        }
        e.appendChild(factory.createTextNode(output));
        return e;
    }
}

