/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss.soap;

import com.ibm.crypto.provider.AESKeySpec;
import com.ibm.crypto.provider.RC4KeySpec;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.jgss.Debug;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.wss.KerberosTokenConsumer;
import com.ibm.security.krb5.wss.soap.util.SoapPingResponse;
import com.ibm.security.krb5.wss.soap.util.TokenReceiver;
import com.ibm.security.krb5.wss.util.DsigServices;
import com.ibm.security.krb5.wss.util.EncServices;
import com.ibm.security.krb5.wss.util.KeyIdentifier;
import com.ibm.security.krb5.wss.util.LocalConstants;
import com.ibm.security.krb5.wss.util.MiscUtils;
import com.ibm.security.krb5.wss.util.Programmable;
import com.ibm.security.krb5.wss.util.RecursiveIDResolver;
import com.ibm.security.krb5.wss.util.SecurityTokenReference;
import com.ibm.security.krb5.wss.util.SoapFault;
import com.ibm.security.krb5.wss.util.TemplateTool;
import com.ibm.security.krb5.wss.util.XMLUtil;
import com.ibm.security.krb5.wss.util.XmlHeader;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.ExclusiveC11r;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KerberosSoapReceiver
extends Programmable
implements TokenReceiver,
LocalConstants {
    public static final String KEYTABROOTNAME = "keytabrootname";
    public static final String SERVICENAME = "servicename";
    public static final String SUBJECT = "subject";
    public static final String SERVICEPASSWORD = "servicePassword";
    public static final String LOGINCONF = "loginConfig";
    private static final String debugPrefix = "KerberosSoapReceiver: ";
    private Document docIn;
    private Document resp;
    private String pText;
    private String phaseMessage;
    private String faultCode = "wst:InvalidRequest";
    private Debug debug = new Debug();
    private boolean wrapped = false;
    private byte[] rawKey;
    private byte[] rawSubKey;
    private int encType;

    public KerberosSoapReceiver() {
        super(KerberosSoapReceiver.class);
    }

    public KerberosSoapReceiver(Map settings) {
        super(KerberosSoapReceiver.class, settings);
    }

    @Override
    public void readInput(InputStream is) throws IllegalStateException {
        try {
            this.docIn = XMLUtil.parse(is);
            this.resp = null;
        }
        catch (Exception e) {
            this.resp = XMLUtil.newDocument();
            SoapFault sf = new SoapFault().setDetail("error parsing input");
            this.resp.appendChild(sf.toDom(this.resp));
        }
    }

    @Override
    public void processInput() throws IllegalStateException {
        if (this.resp != null) {
            return;
        }
        this.resp = XMLUtil.newDocument();
        try {
            AESKeySpec aesKeySpec;
            SecretKeyFactory keyFactory;
            this.phaseMessage = "looking for wsse:Security element";
            this.debug.out(5, debugPrefix + this.phaseMessage);
            Element wsse = (Element)this.docIn.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security").item(0);
            Element bst = (Element)wsse.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken").item(0);
            byte[] rawToken = XMLUtil.getElementText(bst, false).getBytes();
            this.debug.out(5, "KerberosSoapReceiver: The Base64 Encoded ApReqBytes =\n" + new HexDumpEncoder().encodeBuffer(rawToken));
            HashMap<String, Object> inputMap = new HashMap<String, Object>();
            inputMap.put("serviceKeyTab", (String)this.props.get(KEYTABROOTNAME));
            inputMap.put("serviceName", (String)this.props.get(SERVICENAME));
            inputMap.put("serverPassword", (String)this.props.get(SERVICEPASSWORD));
            inputMap.put("loginConf", (String)this.props.get(LOGINCONF));
            inputMap.put("base64Token", rawToken);
            inputMap.put("characterEncoding", "UTF-8");
            KerberosTokenConsumer ktc = new KerberosTokenConsumer();
            ktc.init(inputMap);
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            ktc.invoke(contextMap);
            this.rawKey = (byte[])contextMap.get("contextSessionKeyBytes");
            this.rawSubKey = (byte[])contextMap.get("contextSubKeyBytes");
            this.encType = (Integer)contextMap.get("contextSessionKeyEnc");
            this.debug.out(5, "KerberosSoapReceiver: The Raw SubKey Bytes Used to Verify=\n" + new HexDumpEncoder().encodeBuffer(this.rawSubKey));
            this.debug.out(5, "KerberosSoapReceiver: The Raw Session Key Bytes Used to Verify=\n" + new HexDumpEncoder().encodeBuffer(this.rawKey));
            SignatureContext sc = new SignatureContext();
            sc.setIDResolver((IDResolver)new RecursiveIDResolver());
            this.phaseMessage = "verify the signature";
            this.debug.out(5, debugPrefix + XMLUtil.getStringUnchanged(this.docIn));
            Element sigE = (Element)wsse.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            SecretKey key = null;
            if (EncryptedData.isRc4HMacEncType((int)this.encType)) {
                RC4KeySpec rc4KeySpec = new RC4KeySpec(this.rawKey);
                keyFactory = SecretKeyFactory.getInstance("RC4", "IBMJCE");
                key = keyFactory.generateSecret((KeySpec)rc4KeySpec);
            } else if (this.encType == 16) {
                SecretKeySpec DESedeKeySpec = new SecretKeySpec(this.rawKey, "DESede");
                keyFactory = SecretKeyFactory.getInstance("DESede", "IBMJCE");
                key = keyFactory.generateSecret(DESedeKeySpec);
            } else if (this.encType == 17) {
                aesKeySpec = new AESKeySpec(this.rawKey);
                keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
                key = keyFactory.generateSecret((KeySpec)aesKeySpec);
            } else if (this.encType == 18) {
                aesKeySpec = new AESKeySpec(this.rawKey);
                keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
                key = keyFactory.generateSecret((KeySpec)aesKeySpec);
            } else if (EncryptedData.isDesEncType((int)this.encType)) {
                SecretKeySpec DESKeySpec2 = new SecretKeySpec(this.rawKey, "DES");
                keyFactory = SecretKeyFactory.getInstance("DES", "IBMJCE");
                key = keyFactory.generateSecret(DESKeySpec2);
            } else {
                throw new RuntimeException("Unsupported Encryption Type for the Subsession Key");
            }
            Validity vlid = sc.verify(sigE, (Key)key);
            byte[] signKey = null;
            if (!vlid.getCoreValidity() && this.rawSubKey != null) {
                this.debug.out(5, "KerberosSoapReceiver: Retrying the verify with the subSession Key");
                this.encType = (Integer)contextMap.get("contextSubKeyEnc");
                SecretKey keySub = null;
                if (EncryptedData.isRc4HMacEncType((int)this.encType)) {
                    RC4KeySpec rc4KeySpec = new RC4KeySpec(this.rawSubKey);
                    SecretKeyFactory keyFactory2 = SecretKeyFactory.getInstance("RC4", "IBMJCE");
                    keySub = keyFactory2.generateSecret((KeySpec)rc4KeySpec);
                } else if (this.encType == 16) {
                    SecretKeySpec DESedeKeySpec = new SecretKeySpec(this.rawSubKey, "DESede");
                    SecretKeyFactory keyFactory3 = SecretKeyFactory.getInstance("DESede", "IBMJCE");
                    keySub = keyFactory3.generateSecret(DESedeKeySpec);
                } else if (this.encType == 17) {
                    AESKeySpec aesKeySpec2 = new AESKeySpec(this.rawSubKey);
                    SecretKeyFactory keyFactory4 = SecretKeyFactory.getInstance("AES", "IBMJCE");
                    keySub = keyFactory4.generateSecret((KeySpec)aesKeySpec2);
                } else if (this.encType == 18) {
                    AESKeySpec aesKeySpec3 = new AESKeySpec(this.rawSubKey);
                    SecretKeyFactory keyFactory5 = SecretKeyFactory.getInstance("AES", "IBMJCE");
                    keySub = keyFactory5.generateSecret((KeySpec)aesKeySpec3);
                } else if (EncryptedData.isDesEncType((int)this.encType)) {
                    SecretKeySpec DESKeySpec3 = new SecretKeySpec(this.rawSubKey, "DES");
                    SecretKeyFactory keyFactory6 = SecretKeyFactory.getInstance("DES", "IBMJCE");
                    keySub = keyFactory6.generateSecret(DESKeySpec3);
                } else {
                    throw new RuntimeException("Unsupported Encryption Type for the Subsession Key");
                }
                vlid = sc.verify(sigE, (Key)keySub);
                signKey = this.rawSubKey;
            } else {
                signKey = this.rawKey;
            }
            if (!vlid.getCoreValidity()) {
                this.debug.out(5, "KerberosSoapReceiver: Signiture Validation Failed because: " + KerberosSoapReceiver.debugVerifyFailure(sigE.getOwnerDocument(), sigE, vlid));
                throw new RuntimeException("sig validation failed");
            }
            Element ping = (Element)this.docIn.getElementsByTagNameNS("http://xmlsoap.org/Ping", "Ping").item(0);
            this.pText = XMLUtil.getElementText(ping, true);
            this.genSoapParts(this.resp, this.pText, signKey, rawToken);
        }
        catch (Exception e) {
            this.resp = XMLUtil.newDocument();
            if (e instanceof RuntimeException) {
                SoapFault sf = null;
                if (e instanceof SoapFault) {
                    sf = (SoapFault)e;
                } else {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = this.phaseMessage;
                    }
                    sf = new SoapFault(this.faultCode).setDetail(msg);
                }
                this.resp.appendChild(sf.toDom(this.resp));
            }
            e.printStackTrace();
        }
    }

    @Override
    public Document getResponse() throws IllegalStateException {
        if (this.resp != null) {
            return this.resp;
        }
        return this.resp;
    }

    @Override
    public String getResponseString() throws IllegalStateException {
        return new XmlHeader().toString() + XMLUtil.getStringUnchanged(this.getResponse());
    }

    private Response genSoapParts(Document doc, String pingText, byte[] rawKeyBytes, byte[] apreq) {
        Element root = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        root.setPrefix("soap");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soap", "http://schemas.xmlsoap.org/soap/envelope/");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        doc.appendChild(root);
        Element soapHdr = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
        soapHdr.setPrefix("soap");
        root.appendChild(soapHdr);
        Element wsseE = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        wsseE.setPrefix("wsse");
        wsseE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:mustUnderstand", "1");
        soapHdr.appendChild(wsseE);
        Element timeE = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Timestamp");
        timeE.setPrefix("wsu");
        timeE.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", "timestamp");
        Element createdE = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Created");
        createdE.setPrefix("wsu");
        createdE.appendChild(doc.createTextNode(MiscUtils.makeDateTime()));
        timeE.appendChild(createdE);
        wsseE.appendChild(timeE);
        Element RefL = DsigServices.makeDataReferenceList(doc, new String[]{"response"}, "xenc", false);
        wsseE.appendChild(RefL);
        Element soapBody = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
        soapBody.setPrefix("soap");
        soapBody.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", "body");
        Element pingE = SoapPingResponse.makePingElement(doc, pingText);
        soapBody.appendChild(pingE);
        root.appendChild(soapBody);
        try {
            AESKeySpec aesKeySpec;
            SecretKeyFactory keyFactory;
            this.debug.out(5, "KerberosSoapReceiver: In genSoapParts, about to sign the parts");
            Element protoSig = TemplateTool.genSignatureElem(doc, new String[]{"timestamp", "body"}, "http://www.w3.org/2000/09/xmldsig#hmac-sha1", false);
            wsseE.appendChild(protoSig);
            KeyIdentifier keyId = new KeyIdentifier();
            if (!this.wrapped) {
                keyId.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
            } else {
                keyId.put("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
            }
            keyId.put("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
            keyId.put("value", apreq);
            SecurityTokenReference str = new SecurityTokenReference();
            str.put("keyidentifier", keyId);
            protoSig.appendChild(TemplateTool.genKeyInfoElem(doc, str.toDom(doc), false));
            SignatureContext sc = new SignatureContext();
            sc.setIDResolver((IDResolver)new RecursiveIDResolver());
            this.phaseMessage = "sign the doc";
            this.debug.out(5, debugPrefix + XMLUtil.getStringUnchanged(doc));
            this.debug.out(5, "KerberosSoapReceiver: In genSoapParts, rawKeyBytes =\n" + new HexDumpEncoder().encodeBuffer(rawKeyBytes));
            SecretKey key = null;
            if (EncryptedData.isRc4HMacEncType((int)this.encType)) {
                RC4KeySpec rc4KeySpec = new RC4KeySpec(rawKeyBytes);
                keyFactory = SecretKeyFactory.getInstance("RC4", "IBMJCE");
                key = keyFactory.generateSecret((KeySpec)rc4KeySpec);
            } else if (this.encType == 16) {
                SecretKeySpec DESedeKeySpec = new SecretKeySpec(rawKeyBytes, "DESede");
                keyFactory = SecretKeyFactory.getInstance("DESede", "IBMJCE");
                key = keyFactory.generateSecret(DESedeKeySpec);
            } else if (this.encType == 17) {
                aesKeySpec = new AESKeySpec(rawKeyBytes);
                keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
                key = keyFactory.generateSecret((KeySpec)aesKeySpec);
            } else if (this.encType == 18) {
                aesKeySpec = new AESKeySpec(rawKeyBytes);
                keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
                key = keyFactory.generateSecret((KeySpec)aesKeySpec);
            } else if (EncryptedData.isDesEncType((int)this.encType)) {
                SecretKeySpec DESKeySpec2 = new SecretKeySpec(rawKeyBytes, "DES");
                keyFactory = SecretKeyFactory.getInstance("DES", "IBMJCE");
                key = keyFactory.generateSecret(DESKeySpec2);
            } else {
                throw new RuntimeException("Unsupported Encryption Type for the Subsession Key");
            }
            sc.sign(protoSig, (Key)key);
            this.debug.out(5, "KerberosSoapReceiver: signed the doc");
            aesKeySpec = new AESKeySpec(rawKeyBytes);
            keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
            key = keyFactory.generateSecret((KeySpec)aesKeySpec);
            this.debug.out(5, "KerberosSoapReceiver: generated an AES key");
            Element kiE = TemplateTool.genKeyInfoElem(doc, str.toDom(doc), true);
            EncServices.encryptAndReplaceDataContent(doc, key, "response", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", soapBody, kiE);
            this.debug.out(5, "KerberosSoapReceiver: signed and encrypted doc\n" + XMLUtil.getStringUnchanged(doc));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return new Response(root, wsseE, soapBody, pingE);
    }

    void setUseSubjectCredsOnly(boolean useSubjectCredsOnly) {
        final String subjectOnly = useSubjectCredsOnly ? "true" : "false";
        String property = "javax.security.auth.useSubjectCredsOnly";
        this.debug.out(3, "KerberosSoapReceiver: KerberosSoapReceiver: setting useSubjectCredsOnly property to " + useSubjectCredsOnly);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty("javax.security.auth.useSubjectCredsOnly", subjectOnly);
                return null;
            }
        });
    }

    private static String debugVerifyFailure(Document in, Element sig, Validity vlid) {
        String failure = "signature validation failed";
        for (int i = 0; i < vlid.getNumberOfReferences(); ++i) {
            if (vlid.getReferenceValidity(i)) continue;
            failure = failure + " on URI " + vlid.getReferenceURI(i) + " because " + vlid.getReferenceMessage(i);
            Element elem = new MyIDResolver().resolveID(in, vlid.getReferenceURI(i).substring(1));
            if (elem == null) continue;
            ExclusiveC11r excC11 = new ExclusiveC11r();
            try {
                FileOutputStream fo = new FileOutputStream("c14n.txt");
                excC11.canonicalize((Node)elem, (OutputStream)fo);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return failure;
    }

    class Response {
        Element rootE;
        Element wsseE;
        Element bodyE;
        Element pingE;

        Response(Element root, Element wsse, Element body, Element ping) {
            this.rootE = root;
            this.wsseE = wsse;
            this.bodyE = body;
            this.pingE = ping;
        }
    }

    private static class MyIDResolver
    implements IDResolver {
        private MyIDResolver() {
        }

        public Element resolveID(Document doc, String id) {
            Element answer = null;
            NodeList nl = doc.getElementsByTagName("*");
            if (nl != null) {
                Element temp = null;
                for (int i = 0; i < nl.getLength(); ++i) {
                    temp = (Element)nl.item(i);
                    Attr attr = temp.getAttributeNode("wsu:Id");
                    if (attr == null || !id.equals(attr.getValue())) continue;
                    answer = temp;
                    break;
                }
            }
            return answer;
        }
    }
}

