/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.auth.callback.CcacheFileTextInputCallback;
import com.ibm.security.auth.callback.DefaultCcacheTextInputCallback;
import com.ibm.security.auth.callback.DefaultKeytabTextInputCallback;
import com.ibm.security.auth.callback.KeytabFileTextInputCallback;
import com.ibm.security.jgss.TokenHeader;
import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.APOptions;
import com.ibm.security.krb5.internal.APReq;
import com.ibm.security.krb5.internal.Authenticator;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.EncTicketPart;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.krb5.internal.TicketFlags;
import com.ibm.security.krb5.wss.KerberosCredsUtil;
import com.ibm.security.krb5.wss.util.Debug;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class KerberosTokenConsumer {
    private static final String debugPrefix = "KerberosTokenConsumer: ";
    private static final byte[] AP_REQ_TOK_ID = new byte[]{1, 0};
    private static final int TOK_ID_LEN = 2;
    private static final int WRAPPED = 1;
    private static final int NOT_WRAPPED = 0;
    public static final int CB_SIZE = 16;
    public static final int CKSUMTYPE_KRB = 32771;
    public static final int CKSUM_SIZE_MIN = 24;
    private static final int Des3EType_KD_KDC_REP_TICKET = 2;
    private static final int AES128_KD_KDC_REP_TICKET = 2;
    private static final int AES256_KD_KDC_REP_TICKET = 2;
    private static final int Rc4HMac_KD_AS_REP_SERV = 2;
    private static final int Rc4HMac_KD_AP_REQ_AUTHN = 11;
    private static final int Des3EType_KD_AP_REQ_AUTH = 11;
    private static final int AES128_KD_AP_REQ_AUTH = 11;
    private static final int AES256_KD_AP_REQ_AUTH = 11;
    private static final int Rc4HMac_KD_TGS_REP = 8;
    public static Oid MECH_TYPE_KRB5;
    private boolean wrapped = false;
    private String keyTabFile;
    private String serviceName;
    private String clientName;
    private long tgsExpiryTime = 0L;
    private String clientRealmName;
    private String serviceRealmName;
    private String encoding;
    private Subject subject;
    private boolean useSubject;
    private byte[] rawSubKey;
    private byte[] rawSessionKey;
    private int rawSessionKeyType;
    private byte[] delegCred;
    private KerberosTicket delegatedTicket;
    private EncryptionKey sessionKey;
    private EncryptionKey subKey;
    private EncryptionKey serviceKey;
    private Authenticator authn = null;
    private Credentials creds = null;
    private Debug debug = new Debug();
    private String stringToken;
    private String jaasServiceName;
    private String jaasServicePassword;
    private String jaasLoginConf;
    private byte[] base64token;
    private byte[] decodedtoken;

    public void init(Map config2) throws Exception {
        this.keyTabFile = (String)config2.get("serviceKeyTab");
        this.subject = (Subject)config2.get("subject");
        this.encoding = (String)config2.get("characterEncoding");
        this.base64token = (byte[])config2.get("base64Token");
        this.decodedtoken = null;
        if (this.base64token == null) {
            this.decodedtoken = (byte[])config2.get("decodedToken");
        }
        this.stringToken = null;
        if (this.decodedtoken == null) {
            this.stringToken = (String)config2.get("stringToken");
        }
        if (this.base64token == null && this.decodedtoken == null && this.stringToken == null) {
            throw new RuntimeException("Cannot process a NULL Token");
        }
        this.jaasServiceName = (String)config2.get("serviceName");
        this.jaasServicePassword = (String)config2.get("serverPassword");
        this.serviceRealmName = (String)config2.get("serviceRealmName");
        this.jaasLoginConf = (String)config2.get("loginConf");
        Config krb5Config = Config.getInstance();
        String realm = krb5Config.getDefaultRealm();
        if (this.serviceRealmName == null || this.serviceRealmName.trim().equals("")) {
            this.serviceRealmName = realm;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(Map<String, Object> context) throws Exception {
        if (context == null) {
            throw new RuntimeException("Cannot process a NULL context");
        }
        String fullServiceName = null;
        if (this.jaasServiceName != null && this.serviceRealmName != null) {
            fullServiceName = this.jaasServiceName + "@" + this.serviceRealmName;
        }
        if (this.subject == null && this.jaasLoginConf != null && fullServiceName != null && this.jaasServicePassword != null) {
            this.debug.out(5, "KerberosTokenConsumer: Attempting to do a JAAS Login for: \n" + fullServiceName);
            try {
                LoginContext lc = new LoginContext(this.jaasLoginConf, new NullPrompter(fullServiceName, this.jaasServicePassword.toCharArray()));
                lc.login();
                this.subject = lc.getSubject();
                this.setUseSubjectCreds(true);
            }
            catch (Exception exc) {
                this.debug.out(5, "KerberosTokenConsumer: Failed to do a JAAS Login for: \n" + fullServiceName);
                this.setUseSubjectCreds(false);
            }
        } else if (this.subject != null) {
            this.debug.out(5, "KerberosTokenConsumer: Will attempt to use supplied Subject\n");
            this.setUseSubjectCreds(true);
        }
        try {
            byte[] temp1;
            byte[] temp12;
            byte[] rawToken = null;
            if (this.base64token != null) {
                this.debug.out(5, "KerberosTokenConsumer: Received a Base 64 encoded Token\n");
                String bufferString = this.encoding != null ? new String(this.base64token, this.encoding) : new String(this.base64token, "UTF-8");
                BASE64Decoder base64 = new BASE64Decoder();
                rawToken = base64.decodeBuffer(bufferString);
            } else if (this.decodedtoken != null) {
                this.debug.out(5, "KerberosTokenConsumer: Received a Decoded Raw Token Token\n");
                rawToken = this.decodedtoken;
            } else if (this.stringToken != null) {
                this.debug.out(5, "KerberosTokenConsumer: Received a Base64 Encoded String Token\n");
                BASE64Decoder base64 = new BASE64Decoder();
                rawToken = base64.decodeBuffer(this.stringToken);
            }
            this.debug.out(5, "KerberosTokenConsumer: The Decoded Raw Token BYTES =\n" + new HexDumpEncoder().encodeBuffer(rawToken));
            APReq apreq = null;
            if (rawToken[0] == 110) {
                this.debug.out(5, "KerberosTokenConsumer: Decoded an AP_REQ input token\n");
                apreq = new APReq(rawToken);
            } else {
                if (rawToken[0] != 96) throw new RuntimeException("Input Token not of type GSS_Kerberosv5_AP_REQ or Kerberosv5_AP_REQ");
                this.debug.out(5, "KerberosTokenConsumer: Decoded a GSS Wrapped input token\n");
                this.wrapped = true;
                ByteArrayInputStream inStream = new ByteArrayInputStream(rawToken);
                TokenHeader header = new TokenHeader((InputStream)inStream);
                Oid mechOid = header.getMechanism();
                this.debug.out(5, "KerberosTokenConsumer: The Mechanism OID =\n" + mechOid.toString());
                if (!mechOid.equals(MECH_TYPE_KRB5)) {
                    I18NException.throwGSSException((int)2, (int)0, (String)"MismatchedMechs", (Object[])new String[]{mechOid.toString(), MECH_TYPE_KRB5.toString()});
                }
                int mechTokenSize = header.getMechTokenLen();
                byte[] buff = this.stream2Bytes(inStream, mechTokenSize);
                byte[] innerToken = new byte[mechTokenSize];
                System.arraycopy(buff, 0, innerToken, 0, mechTokenSize);
                byte[] tokenId = new byte[2];
                System.arraycopy(innerToken, 0, tokenId, 0, 2);
                int krbMsgLen = innerToken.length - 2;
                byte[] krbMsg = new byte[krbMsgLen];
                System.arraycopy(innerToken, 2, krbMsg, 0, krbMsgLen);
                if (!Arrays.equals(tokenId, AP_REQ_TOK_ID)) throw new RuntimeException("GSS Token was not an APReq message");
                apreq = new APReq(krbMsg);
            }
            Ticket ticket = apreq.getTicket();
            APOptions apopts = apreq.getOptions();
            EncryptedData encPart = ticket.getEncryptedPart();
            this.serviceName = ticket.getServer().getNameString();
            this.debug.out(5, "KerberosTokenConsumer: The Ticket Service Name = " + this.serviceName);
            this.debug.out(5, "KerberosTokenConsumer: The encrypted part enc type = " + encPart.getEType());
            String qualifiedServiceName = this.serviceName + "@" + this.serviceRealmName;
            try {
                if (this.useSubjectCredsOnly()) {
                    this.creds = this.getServerCredsFromSubject(qualifiedServiceName);
                    if (this.creds != null) {
                        this.debug.out(5, "KerberosTokenConsumer: Found Credentials in the Subject for = " + qualifiedServiceName);
                    }
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
                this.debug.out(5, "KerberosTokenConsumer: No Valid Credentials Found in the Subject\n");
                this.creds = null;
            }
            if (this.creds == null && this.keyTabFile != null) {
                this.debug.out(5, "KerberosTokenConsumer: Not using Subject Credentials, using KeyTab creds\n");
                this.creds = Credentials.getServiceCreds((String)qualifiedServiceName, (File)new File(this.keyTabFile));
            } else if (this.creds == null) {
                this.debug.out(5, "KerberosTokenConsumer: Not using Subject Credentials, using default KeyTab creds\n");
                this.creds = Credentials.getServiceCreds((String)qualifiedServiceName, null);
            }
            if (this.creds == null) {
                I18NException.throwGSSException((int)11, (int)0, (String)"NoKrbCred", (Object[])new String[]{"Failed to obtain credentials for " + qualifiedServiceName});
            }
            this.debug.out(5, "KerberosTokenConsumer: encPart.getEType()= \n" + encPart.getEType());
            this.serviceKey = this.creds.getServiceKey(encPart.getEType());
            this.debug.out(5, "KerberosTokenConsumer: service key= \n" + new HexDumpEncoder().encode(this.serviceKey.getBytes()) + "\n  service key enc type= " + this.serviceKey.getEType());
            byte[] temp = null;
            boolean desKey = encPart.isDesEncType();
            if (desKey) {
                temp12 = encPart.decrypt(this.serviceKey, 2);
                temp = encPart.reset(temp12, true);
            } else if (encPart.isAES128EncType()) {
                temp12 = encPart.decrypt(this.serviceKey, 2);
                temp = encPart.reset(temp12, true);
            } else if (encPart.isAES256EncType()) {
                temp12 = encPart.decrypt(this.serviceKey, 2);
                temp = encPart.reset(temp12, true);
            } else {
                try {
                    temp = encPart.decrypt(this.serviceKey, 2);
                }
                catch (KrbException exc) {
                    temp = encPart.decrypt(this.serviceKey, 8);
                }
            }
            this.debug.out(4, "Successfully decrypted ticket");
            EncTicketPart decTicket = new EncTicketPart(temp);
            this.clientName = decTicket.getClient().getNameString();
            this.clientRealmName = decTicket.getClient().getRealmAsString();
            this.tgsExpiryTime = decTicket.getEndTime().getTime();
            this.sessionKey = decTicket.getEncryptionKey();
            if (apopts.get(1)) {
                this.sessionKey = this.creds.getSessionKey();
            }
            this.debug.out(5, "KerberosTokenConsumer: The AP_REQ Session Key =\n" + new HexDumpEncoder().encodeBuffer(this.sessionKey.getBytes()) + "\n  session key enc type= " + this.sessionKey.getEType());
            EncryptedData authenticator = apreq.getEncryptedAuthenticator();
            this.subKey = null;
            desKey = EncryptedData.isDesEncType((int)this.sessionKey.getEType());
            if (desKey) {
                temp1 = authenticator.decrypt(this.sessionKey, 11);
                temp = authenticator.reset(temp1, true);
            } else if (EncryptedData.isAES128EncType((int)this.sessionKey.getEType())) {
                temp1 = authenticator.decrypt(this.sessionKey, 11);
                temp = authenticator.reset(temp1, true);
            } else if (EncryptedData.isAES256EncType((int)this.sessionKey.getEType())) {
                temp1 = authenticator.decrypt(this.sessionKey, 11);
                temp = authenticator.reset(temp1, true);
            } else {
                temp = authenticator.decrypt(this.sessionKey, 11);
            }
            this.authn = new Authenticator(temp);
            this.subKey = this.authn.getSubKey();
            this.verifyAPReq(this.authn, decTicket);
            this.delegCred = this.getDelegatedCreds(this.authn);
            this.rawSessionKey = this.sessionKey.getBytes();
            this.rawSessionKeyType = this.sessionKey.getEType();
            if (this.delegCred != null && this.delegCred.length > 0) {
                Credentials delegCreds = KerberosCredsUtil.getClientCredentials(this.delegCred, this.sessionKey);
                this.delegatedTicket = new KerberosTicket(delegCreds.getEncoded(), new KerberosPrincipal(delegCreds.getClient().toString()), new KerberosPrincipal(delegCreds.getServer().toString()), delegCreds.getSessionKey().getBytes(), delegCreds.getSessionKey().getEType(), delegCreds.getFlags(), delegCreds.getAuthTime(), delegCreds.getStartTime(), delegCreds.getEndTime(), delegCreds.getRenewTill(), delegCreds.getClientAddresses());
            }
            this.rawSubKey = null;
            if (this.subKey != null) {
                this.rawSubKey = this.subKey.getBytes();
                this.debug.out(5, "KerberosTokenConsumer: The AP_REQ SubSession Key =\n" + new HexDumpEncoder().encodeBuffer(this.rawSubKey));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.fillContext(context);
    }

    private byte[] getDelegatedCreds(Authenticator authenticator) {
        byte[] deleCreds = null;
        if (authenticator.getChecksum() != null) {
            try {
                int offset = 0;
                byte[] bytes = null;
                byte[] encoded = authenticator.getChecksum().getBytes();
                int cbLen = KerberosTokenConsumer.bytesToInt(encoded);
                if (cbLen != 16) {
                    throw new RuntimeException("Length (" + cbLen + ") of Channel Binding is not " + 16);
                }
                byte[] bndBytes = new byte[cbLen];
                System.arraycopy(encoded, offset += 4, bndBytes, 0, cbLen);
                bytes = new byte[4];
                System.arraycopy(encoded, offset += cbLen, bytes, 0, bytes.length);
                offset += 4;
                if (encoded.length == 24) {
                    return null;
                }
                if (encoded.length < 28) {
                    throw new Exception("Checksum too short");
                }
                bytes = new byte[2];
                System.arraycopy(encoded, offset += 2, bytes, 0, bytes.length);
                int credsLen = KerberosTokenConsumer.bytesToInt(bytes, 2);
                offset += 2;
                if (credsLen != encoded.length - 24 - 4) {
                    throw new Exception("Checksum size mismatch");
                }
                deleCreds = new byte[credsLen];
                System.arraycopy(encoded, offset, deleCreds, 0, deleCreds.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return deleCreds;
    }

    private void fillContext(Map<String, Object> context) {
        KerberosKey kkey;
        if (this.isWrapped()) {
            Integer wrap = new Integer(1);
            context.put("contextWrapped", wrap);
            context.put("contextWrappedType", new String(wrap.getClass().getName()));
        } else {
            Integer notWrap = new Integer(0);
            context.put("contextWrapped", notWrap);
            context.put("contextWrappedType", new String(notWrap.getClass().getName()));
        }
        if (this.rawSessionKey != null) {
            context.put("contextSessionKeyBytes", this.rawSessionKey);
            context.put("contextSessionKeyBytesType", this.rawSessionKeyType);
        }
        if (this.rawSubKey != null) {
            context.put("contextSubKeyBytes", this.rawSubKey);
            context.put("contextSubKeyBytesType", new String(this.rawSubKey.getClass().getName()));
        }
        if (this.delegCred != null) {
            context.put("contextDelegatedCredsBytes", this.delegCred);
        }
        if (this.delegatedTicket != null) {
            context.put("contextDelegatedKerberosTicket", this.delegatedTicket);
        }
        if ((kkey = this.getServiceKerberosKey()) != null) {
            context.put("contextKerberosServiceKey", kkey);
            context.put("contextKerberosServiceKeyType", new String(kkey.getClass().getName()));
        }
        if (this.sessionKey != null) {
            Integer sessEncType = new Integer(this.getSessionKeyEncType());
            context.put("contextSessionKeyEnc", sessEncType);
            context.put("contextSessionKeyEncType", new String(sessEncType.getClass().getName()));
        }
        if (this.subKey != null) {
            Integer subEncType = new Integer(this.getSubSessionKeyEncType());
            context.put("contextSubKeyEnc", subEncType);
            context.put("contextSubKeyEncType", new String(subEncType.getClass().getName()));
        }
        if (this.subject != null) {
            context.put("contextSubject", this.subject);
            context.put("contextSubjectType", new String(this.subject.getClass().getName()));
        }
        if (this.clientName != null) {
            context.put("clientName", this.clientName);
        }
        if (this.clientRealmName != null) {
            context.put("clientName", this.clientRealmName);
        }
        if (this.tgsExpiryTime > 0L) {
            context.put("tgsExpiryTime", this.tgsExpiryTime);
        }
        if (this.serviceRealmName != null) {
            context.put("serviceRealmName", this.serviceRealmName);
        }
    }

    public void setUseSubjectCreds(boolean setUseSubjectCreds) {
        this.useSubject = setUseSubjectCreds;
    }

    private boolean useSubjectCredsOnly() {
        return this.useSubject;
    }

    private boolean isWrapped() {
        return this.wrapped;
    }

    static int bytesToInt(byte[] num) {
        int n = 4;
        int ret = 0;
        while (--n >= 0) {
            ret <<= 8;
            ret |= num[n] & 0xFF;
        }
        return ret;
    }

    static int bytesToInt(byte[] num, int len) {
        int n = len;
        if (n > 4) {
            n = 4;
        } else if (n < 0) {
            return 0;
        }
        int ret = 0;
        while (--n >= 0) {
            ret <<= 8;
            ret |= num[n] & 0xFF;
        }
        return ret;
    }

    private KerberosKey getServiceKerberosKey() {
        KerberosKey kkey = null;
        try {
            if (this.serviceKey != null) {
                Integer kvno = this.serviceKey.getKeyVersionNumber();
                kkey = new KerberosKey(new KerberosPrincipal(this.serviceName + "@" + this.serviceRealmName), this.serviceKey.getBytes(), this.serviceKey.getEType(), kvno != null ? kvno : 0);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
        return kkey;
    }

    private int getSessionKeyEncType() {
        if (this.sessionKey != null) {
            return this.sessionKey.getEType();
        }
        return 0;
    }

    private int getSubSessionKeyEncType() {
        if (this.subKey != null) {
            return this.subKey.getEType();
        }
        return 0;
    }

    private void verifyAPReq(Authenticator authn, EncTicketPart ticket) throws GSSException {
        TicketFlags flags;
        KerberosTime timeNow;
        KerberosTime starttime;
        KerberosTime ctime = authn.getTime();
        PrincipalName cname = authn.getClient();
        PrincipalName temp = ticket.getClient();
        try {
            ctime.setMicroSeconds(authn.getMicroSeconds());
            if (cname.getRealm() == null) {
                cname.setRealm(authn.getRealm());
            }
            if (temp.getRealm() == null) {
                temp.setRealm(ticket.getClientRealm());
            }
        }
        catch (KrbException exc) {
            I18NException.throwGSSException((int)11, (int)exc.returnCode(), (String)"KrbErrorAPREQ", (Object[])new String[]{exc.toString()});
        }
        catch (Exception exc) {
            I18NException.throwGSSException((int)11, (int)0, (String)"ErrorAPREQ", (Object[])new String[]{exc.toString()});
        }
        if (!cname.equals(temp)) {
            String temp2 = null;
            if (temp != null) {
                temp2 = temp.toString();
            }
            if (temp2 != null) {
                I18NException.throwGSSException((int)10, (int)36, (String)"TktNameMismatch", (Object[])new String[]{cname.toString(), temp2});
            } else {
                I18NException.throwGSSException((int)10, (int)36, (String)"TktNameMismatch2", (Object[])new String[]{cname.toString()});
            }
        }
        if (!ctime.inClockSkew()) {
            I18NException.throwGSSException((int)10, (int)37, (String)"ClientTimeTooSkewed", (Object[])new Date[]{ctime.toDate()});
        }
        if ((starttime = ticket.getStartTime()) == null) {
            starttime = ticket.getAuthTime();
        }
        if (starttime.greaterThanWRTClockSkew(timeNow = new KerberosTime(true))) {
            I18NException.throwGSSException((int)10, (int)33, (String)"TktNYV", (Object[])new Date[]{starttime.toDate(), timeNow.toDate()});
        }
        if (timeNow.greaterThanWRTClockSkew(ticket.getEndTime())) {
            I18NException.throwGSSException((int)10, (int)32, (String)"TktExpired", (Object[])new Date[]{timeNow.toDate(), ticket.getEndTime().toDate()});
        }
        if ((flags = ticket.getTicketFlags()) != null && flags.get(7)) {
            I18NException.throwGSSException((int)10, (int)33, (String)"TktInvalid");
        }
    }

    private byte[] stream2Bytes(InputStream in, int len) throws GSSException {
        byte[] buffer = new byte[len];
        int readLen = 0;
        try {
            readLen = in.read(buffer, 0, len);
        }
        catch (Exception exc) {
            I18NException.throwGSSException((int)10, (int)0, (String)"StreamReadError", (Object[])new String[]{exc.toString()});
        }
        if (readLen != len) {
            I18NException.throwGSSException((int)10, (int)0, (String)"StreamDataLenMismatch", (Object[])new Integer[]{new Integer(len), new Integer(readLen)});
        }
        return buffer;
    }

    private Credentials getServerCredsFromSubject(String name) throws GSSException {
        Credentials creds = null;
        String principal = name;
        KerberosKey[] keys = null;
        KerberosTicket kticket = null;
        EncryptionKey[] serviceKeys = null;
        try {
            Object doPrivileged = AccessController.doPrivileged(new SubjectKeyFinder(principal));
            keys = (KerberosKey[])doPrivileged;
        }
        catch (PrivilegedActionException exc) {
            throw (GSSException)exc.getException();
        }
        try {
            kticket = (KerberosTicket)AccessController.doPrivileged(new SubjectCredFinder(principal));
        }
        catch (PrivilegedActionException exc) {
            throw (GSSException)exc.getException();
        }
        if (kticket != null) {
            if (keys != null) {
                serviceKeys = new EncryptionKey[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    serviceKeys[i] = new EncryptionKey(keys[i].getEncoded(), keys[i].getKeyType(), new Integer(keys[i].getVersionNumber()));
                }
            }
            try {
                creds = new Credentials(kticket.getEncoded(), kticket.getClient().getName(), kticket.getServer().getName(), kticket.getSessionKey().getEncoded(), kticket.getSessionKeyType(), kticket.getFlags(), kticket.getAuthTime(), kticket.getStartTime(), kticket.getEndTime(), kticket.getRenewTill(), kticket.getClientAddresses());
            }
            catch (KrbException exc) {
                I18NException.throwGSSException((int)13, (int)0, (String)"KrbSubjectCredError", (Object[])new String[]{exc.toString()});
            }
            catch (Exception exc) {
                I18NException.throwGSSException((int)13, (int)0, (String)"SubjectCredError", (Object[])new String[]{exc.toString()});
            }
            if (creds != null && serviceKeys != null) {
                try {
                    creds.setServiceKeys(serviceKeys);
                }
                catch (Exception exc) {
                    I18NException.throwGSSException((int)11, (int)0, (String)"Error", (Object[])new String[]{exc.toString()});
                }
            }
        } else if (keys != null) {
            serviceKeys = new EncryptionKey[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                serviceKeys[i] = new EncryptionKey(keys[i].getEncoded(), keys[i].getKeyType(), new Integer(keys[i].getVersionNumber()));
            }
            try {
                creds = new Credentials(keys[0].getPrincipal().getName(), serviceKeys);
            }
            catch (KrbException exc) {
                I18NException.throwGSSException((int)13, (int)0, (String)"KrbSubjectCredError", (Object[])new String[]{exc.toString()});
            }
        }
        if (creds == null) {
            I18NException.throwGSSException((int)13, (int)0, (String)"NoSubjectPrincipalCred", (Object[])new String[]{principal});
        }
        return creds;
    }

    static {
        try {
            MECH_TYPE_KRB5 = new Oid("1.2.840.113554.1.2.2");
        }
        catch (Exception exc) {
            new Debug().out(4, "Exception creating Oid(s)" + exc);
        }
    }

    class NullPrompter
    implements CallbackHandler {
        private String userName;
        private char[] authenticator;

        private NullPrompter() {
        }

        public NullPrompter(String userName, char[] authenticator) {
            this.userName = userName;
            this.authenticator = authenticator;
        }

        public void nukeEm() {
            this.userName = null;
            for (int i = 0; i < this.authenticator.length; ++i) {
                this.authenticator[i] = 32;
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof TextOutputCallback || callbacks[i] instanceof CcacheFileTextInputCallback || callbacks[i] instanceof DefaultCcacheTextInputCallback || callbacks[i] instanceof DefaultKeytabTextInputCallback || callbacks[i] instanceof KeytabFileTextInputCallback) continue;
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName(this.userName);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword(this.authenticator);
                    continue;
                }
                KerberosTokenConsumer.this.debug.out(5, "KerberosTokenConsumer: Unrecognized Callback :" + callbacks[i]);
            }
        }
    }

    private class SubjectCredFinder
    implements PrivilegedExceptionAction {
        private String client;

        public SubjectCredFinder(String client) {
            this.client = client;
        }

        public Object run() throws GSSException {
            KerberosTokenConsumer.this.debug.out(5, "KerberosTokenConsumer: SubjectCredFinder: client=" + this.client);
            try {
                if (KerberosTokenConsumer.this.subject == null && KerberosTokenConsumer.this.useSubject) {
                    final AccessControlContext secContext = AccessController.getContext();
                    Object doPrivileged = AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Subject.getSubject(secContext);
                        }
                    });
                    KerberosTokenConsumer.this.subject = (Subject)doPrivileged;
                }
            }
            catch (Exception exc) {
                KerberosTokenConsumer.this.subject = null;
            }
            if (KerberosTokenConsumer.this.subject == null) {
                I18NException.throwGSSException((int)13, (int)0, (String)"SKFNoSubject");
            }
            for (Object entry : KerberosTokenConsumer.this.subject.getPrivateCredentials()) {
                if (!(entry instanceof KerberosTicket)) continue;
                KerberosTicket kticket = (KerberosTicket)entry;
                String ktc = kticket.getClient().getName();
                if (this.client == null) {
                    KerberosTokenConsumer.this.debug.out(5, "KerberosTokenConsumer: SubjectCredFinder (default) KerberosTicket: client=" + ktc);
                    return kticket;
                }
                if (!ktc.equals(this.client)) continue;
                KerberosTokenConsumer.this.debug.out(5, "KerberosTokenConsumer: SubjectCredFinder KerberosTicket: client=" + ktc);
                return kticket;
            }
            return null;
        }
    }

    private class SubjectKeyFinder
    implements PrivilegedExceptionAction {
        private String principal;

        public SubjectKeyFinder(String principal) {
            this.principal = principal;
        }

        public Object run() throws GSSException {
            try {
                if (KerberosTokenConsumer.this.subject == null && KerberosTokenConsumer.this.useSubject) {
                    final AccessControlContext secContext = AccessController.getContext();
                    KerberosTokenConsumer.this.subject = (Subject)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return Subject.getSubject(secContext);
                        }
                    });
                }
            }
            catch (Exception exc) {
                KerberosTokenConsumer.this.subject = null;
            }
            if (KerberosTokenConsumer.this.subject == null) {
                I18NException.throwGSSException((int)13, (int)0, (String)"SKFNoSubject");
            }
            Vector<KerberosKey> v = new Vector<KerberosKey>();
            for (Object entry : KerberosTokenConsumer.this.subject.getPrivateCredentials()) {
                if (!(entry instanceof KerberosKey)) continue;
                KerberosKey key = (KerberosKey)entry;
                if (this.principal == null) {
                    this.principal = key.getPrincipal().getName();
                    if (this.principal != null) {
                        v.add(key);
                        continue;
                    }
                    KerberosTokenConsumer.this.debug.out(5, "KerberosTokenConsumer: SubjectKeyFinder: disregarding key without owner");
                    continue;
                }
                if (!key.getPrincipal().getName().equals(this.principal)) continue;
                v.add(key);
            }
            if (v.size() > 0) {
                KerberosKey[] keys = v.toArray(new KerberosKey[0]);
                if (KerberosTokenConsumer.this.debug.on(5)) {
                    String msg = "KerberosTokenConsumer: Retrieved " + keys.length + " keys from Subject. Key types:";
                    for (int i = 0; i < keys.length; ++i) {
                        msg = msg + "\n\t[" + (i + 1) + "] " + EncryptedData.encTypeToString((int)keys[i].getKeyType());
                    }
                    KerberosTokenConsumer.this.debug.out(5, msg);
                }
                return keys;
            }
            return null;
        }
    }
}

