/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.wss;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.EncKrbCredPart;
import com.ibm.security.krb5.internal.KRBCred;
import com.ibm.security.krb5.wss.util.Debug;

public class KerberosCredsUtil {
    protected static Credentials getClientCredentials(byte[] delegatedCreds, EncryptionKey encKey) throws Exception {
        Credentials ccreds = null;
        try {
            KRBCred krbCred = new KRBCred(delegatedCreds);
            if (krbCred.tickets.length != 1) {
                I18NException.throwGSSException((int)16, (int)0, (String)"BadNumberOfTkts", (Object[])new Integer[]{new Integer(krbCred.tickets.length)});
            }
            try {
                byte[] temp = null;
                if (EncryptedData.isDesEncType((int)encKey.getEType())) {
                    try {
                        byte[] temp1 = krbCred.encPart.decrypt(encKey, 14);
                        temp = krbCred.encPart.reset(temp1, true);
                    }
                    catch (Exception exc) {
                        temp = krbCred.encPart.getBytes();
                    }
                } else {
                    temp = krbCred.encPart.decrypt(encKey, 14);
                }
                Debug debug = new Debug();
                debug.out(4, "Successfully decrypted creds");
                EncKrbCredPart unencPart = new EncKrbCredPart(temp);
                PrincipalName client = unencPart.ticketInfo[0].pname;
                PrincipalName server = unencPart.ticketInfo[0].sname;
                client.setRealm(unencPart.ticketInfo[0].prealm);
                server.setRealm(unencPart.ticketInfo[0].srealm);
                ccreds = new Credentials(krbCred.tickets[0], client, server, unencPart.ticketInfo[0].key, unencPart.ticketInfo[0].flags, unencPart.ticketInfo[0].authtime, unencPart.ticketInfo[0].starttime, unencPart.ticketInfo[0].endtime, unencPart.ticketInfo[0].renewTill, unencPart.ticketInfo[0].caddr);
            }
            catch (KrbException exc) {
                I18NException.throwGSSException((int)11, (int)exc.returnCode(), (String)"KrbErrorCredConversion", (Object[])new String[]{exc.toString()});
            }
            catch (Exception exc) {
                I18NException.throwGSSException((int)11, (int)0, (String)"ErrorCredConversion", (Object[])new String[]{exc.toString()});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ccreds;
    }
}

