/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASFormatter;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASMessageCatalog;
import com.ibm.ras.RASMessageEvent;
import java.util.Locale;

public class RASMessageFormatter
extends RASFormatter {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = 5225655501360484531L;
    private static String[] attribs = new String[]{"loggingClass", "loggingMethod", "organization", "product", "component", "server", "client"};
    private Locale locale = Locale.getDefault();

    public RASMessageFormatter() {
        this.addEventClass("com.ibm.ras.RASMessageEvent");
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale loc) {
        if (loc != null) {
            this.locale = loc;
        }
    }

    public String format(RASIEvent event) {
        String sep = this.getSeparator();
        StringBuffer bfr = new StringBuffer(256);
        RASMessageEvent mevent = (RASMessageEvent)event;
        long timeStamp = mevent.getTimeStamp();
        bfr.append(this.getDate(timeStamp) + sep);
        bfr.append(this.getTime(timeStamp) + sep);
        for (int j = 0; j < attribs.length; ++j) {
            String attrib = (String)mevent.getAttribute(attribs[j]);
            if (attrib == null) continue;
            bfr.append(attrib + sep);
        }
        bfr.append(this.lineSep);
        bfr.append("  " + this.getText(mevent));
        return bfr.toString();
    }

    protected String getText(RASMessageEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        String text = event.getText();
        Object[] parms = event.getParameters();
        String messageFile = event.getMessageFile();
        String stackTrace = (String)event.getAttribute("exceptionTrace");
        if (stackTrace != null) {
            bfr.append(stackTrace);
        } else if (messageFile == null) {
            bfr.append(text);
            if (parms != null) {
                for (int j = 0; j < parms.length; ++j) {
                    bfr.append(", p" + (j + 1) + "=" + (String)parms[j]);
                }
            }
        } else {
            RASMessageCatalog cat = new RASMessageCatalog(messageFile, this.getLocale());
            bfr.append(cat.getMsg(text, parms));
        }
        if (stackTrace == null) {
            bfr.append(this.lineSep);
        }
        return bfr.toString();
    }
}

