/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIFormatter;
import com.ibm.ras.RASObject;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;

public abstract class RASFormatter
extends RASObject
implements RASIFormatter,
RASConstants {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    public static final String DEFAULT_DATE_FORMAT = "yyyy.MM.dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss.SSS";
    public static final String DEFAULT_SEPARATOR = " ";
    protected static final String INDENT = "  ";
    private static final Object dateLock = new Object();
    private static final Object timeLock = new Object();
    private boolean defaultFormatter = false;
    private transient Date date;
    private transient Date time;
    private transient FieldPosition dateField;
    private transient FieldPosition timeField;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat timeFormat;
    private String separator;
    protected transient String lineSep;
    private transient StringBuffer dateBuffer;
    private transient StringBuffer timeBuffer;
    private Vector eventClasses = new Vector();

    public RASFormatter() {
        this.lineSep = System.getProperty("line.separator");
        TimeZone tz = TimeZone.getDefault();
        this.dateFormat.setTimeZone(tz);
        this.timeFormat.setTimeZone(tz);
    }

    protected void init() {
        super.init();
        this.setSeparator(DEFAULT_SEPARATOR);
        this.dateFormat = new SimpleDateFormat();
        this.timeFormat = new SimpleDateFormat();
        this.setDateFormat(DEFAULT_DATE_FORMAT);
        this.setTimeFormat(DEFAULT_TIME_FORMAT);
        this.date = new Date();
        this.time = new Date();
        this.dateBuffer = new StringBuffer();
        this.timeBuffer = new StringBuffer();
        this.dateField = new FieldPosition(0);
        this.timeField = new FieldPosition(0);
    }

    public Hashtable getConfig() {
        Hashtable ht = super.getConfig();
        ht.put("dateFormat", this.getDateFormat().toPattern());
        ht.put("timeFormat", this.getTimeFormat().toPattern());
        ht.put("separator", this.getSeparator());
        return ht;
    }

    public void setConfig(Hashtable ht) {
        super.setConfig(ht);
        if (ht.containsKey("dateFormat")) {
            this.setDateFormat((String)ht.get("dateFormat"));
        }
        if (ht.containsKey("timeFormat")) {
            this.setTimeFormat((String)ht.get("timeFormat"));
        }
        if (ht.containsKey("separator")) {
            this.setSeparator((String)ht.get("separator"));
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String sep) {
        if (sep != null) {
            this.separator = sep;
        }
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat format) {
        if (format != null) {
            this.dateFormat = format;
        }
    }

    public void setDateFormat(String pattern) {
        if (pattern != null) {
            this.dateFormat.applyPattern(pattern);
        }
    }

    public SimpleDateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(SimpleDateFormat format) {
        if (format != null) {
            this.timeFormat = format;
        }
    }

    public void setTimeFormat(String pattern) {
        if (pattern != null) {
            this.timeFormat.applyPattern(pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDate(long timeStamp) {
        Object object = dateLock;
        synchronized (object) {
            this.date.setTime(timeStamp);
            this.dateBuffer.setLength(0);
            StringBuffer output = this.dateFormat.format(this.date, this.dateBuffer, this.dateField);
            return output.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTime(long timeStamp) {
        Object object = timeLock;
        synchronized (object) {
            this.time.setTime(timeStamp);
            this.timeBuffer.setLength(0);
            StringBuffer output = this.timeFormat.format(this.time, this.timeBuffer, this.timeField);
            return output.toString();
        }
    }

    public void setDefault(boolean flag) {
        this.defaultFormatter = flag;
    }

    public boolean isDefault() {
        return this.defaultFormatter;
    }

    public void addEventClass(String name) {
        if (name != null && !this.eventClasses.contains(name)) {
            this.eventClasses.addElement(name);
        }
    }

    public void removeEventClass(String name) {
        if (name != null && this.eventClasses.contains(name)) {
            this.eventClasses.removeElement(name);
        }
    }

    public Enumeration getEventClasses() {
        return this.eventClasses.elements();
    }

    public abstract String format(RASIEvent var1);
}

