/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIQueue;
import com.ibm.ras.RASQueueEmptyException;
import com.ibm.ras.RASQueueFullException;
import com.ibm.ras.RASUtil;

public class RASCircularQueue
implements RASIQueue {
    private static final String S = "(C) Copyright Tivoli Systems 1999.";
    public static final int DEFAULT_QUEUE_SIZE = 10000;
    private int first;
    private int last;
    private int queueSize;
    private int maxQueueSize;
    private Object[] queue = null;

    public RASCircularQueue() {
        this(10000);
    }

    public RASCircularQueue(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException(RASUtil.rasMsgs.getMessage("ERR_QUEUE_SIZE", new Integer(size)));
        }
        if (size == 0) {
            size = 10000;
        }
        this.first = 0;
        this.last = 0;
        this.queueSize = 0;
        this.maxQueueSize = size;
        this.queue = new Object[size];
    }

    public synchronized int getQueueSize() {
        return this.queueSize;
    }

    public int getMaximumQueueSize() {
        return this.maxQueueSize;
    }

    public synchronized boolean isEmpty() {
        return this.queueSize == 0;
    }

    public synchronized boolean isFull() {
        return false;
    }

    public boolean isCircular() {
        return true;
    }

    public synchronized void enqueue(Object object) throws RASQueueFullException {
        if (object != null) {
            this.queue[this.last] = object;
            if (this.queueSize < this.maxQueueSize) {
                ++this.queueSize;
            }
            if (this.last == this.first && this.queueSize == this.maxQueueSize) {
                this.first = (this.first + 1) % this.maxQueueSize;
            }
            this.last = (this.last + 1) % this.maxQueueSize;
        }
    }

    public synchronized Object dequeue() throws RASQueueEmptyException {
        Object object = this.firstObject();
        this.first = (this.first + 1) % this.maxQueueSize;
        --this.queueSize;
        return object;
    }

    public void requeue(Object object) throws IllegalStateException {
        throw new IllegalStateException();
    }

    public synchronized Object firstObject() throws RASQueueEmptyException {
        if (this.isEmpty()) {
            throw new RASQueueEmptyException();
        }
        return this.queue[this.first];
    }
}

