/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.provider;

import com.ibm.ffdc.util.formatting.DateFormatProvider;
import com.ibm.ffdc.util.provider.FfdcProvider;
import com.ibm.ffdc.util.provider.FfdcProviderDependent;
import com.ibm.ffdc.util.provider.Incident;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IncidentSummaryLogger<T extends FfdcProvider>
extends FfdcProviderDependent<T> {
    private int logIdx = -1;

    protected IncidentSummaryLogger(T provider) {
        super(provider);
    }

    protected int getLogIdx() {
        return this.logIdx;
    }

    protected abstract void log(List<Incident> var1);

    protected void logIncidentSummary(PrintStream ps, List<Incident> incidents) {
        try {
            try {
                ps.println();
                ps.println(" Index  Count  Time of first Occurrence    Time of last Occurrence     Exception SourceId ProbeId");
                ps.println("------+------+---------------------------+---------------------------+---------------------------");
                int i = -1;
                for (Incident incident : incidents) {
                    ps.println(this.formatIncidentEntry(incident, ++i));
                }
                this.logIdx = i;
            }
            catch (ConcurrentModificationException cme) {
                ps.println("incomplete  dump, see next entry for full table");
                this.ffdcerror(cme);
            }
            ps.println("------+------+---------------------------+---------------------------+---------------------------");
        }
        catch (Throwable th) {
            this.ffdcerror(th);
        }
    }

    private String formatIncidentEntry(Incident entry, int index) {
        int fill;
        DateFormat formatter = this.getDateFormatter();
        String dateString = "";
        String firstDateString = "";
        Date date = new Date(entry.getTimeStamp());
        try {
            dateString = formatter.format(date);
            firstDateString = formatter.format(entry.getDateOfFirstOccurrence());
        }
        catch (Throwable th) {
            this.ffdcerror(th);
        }
        StringBuffer outputBuffer = new StringBuffer();
        Character firstChar = Character.valueOf(index > this.logIdx ? (char)'+' : ' ');
        String temp = String.valueOf(index);
        outputBuffer.append(firstChar);
        int length = 5 - temp.length();
        for (fill = 0; fill < length; ++fill) {
            outputBuffer.append(' ');
        }
        outputBuffer.append(temp);
        outputBuffer.append(' ');
        temp = String.valueOf(entry.getCount());
        length = 6 - temp.length();
        for (fill = 0; fill < length; ++fill) {
            outputBuffer.append(' ');
        }
        outputBuffer.append(temp);
        outputBuffer.append(' ');
        temp = firstDateString;
        length = 27 - temp.length();
        for (fill = 0; fill < length; ++fill) {
            outputBuffer.append(' ');
        }
        outputBuffer.append(temp);
        outputBuffer.append(' ');
        temp = dateString;
        length = 27 - temp.length();
        for (fill = 0; fill < length; ++fill) {
            outputBuffer.append(' ');
        }
        outputBuffer.append(temp);
        outputBuffer.append(' ');
        outputBuffer.append(entry.getExceptionName());
        outputBuffer.append(' ');
        outputBuffer.append(entry.getSourceId());
        outputBuffer.append(' ');
        outputBuffer.append(entry.getProbeId());
        String label = entry.getLabel();
        if (label != null) {
            outputBuffer.append(' ');
            outputBuffer.append(label);
        }
        return outputBuffer.toString();
    }

    protected DateFormat getDateFormatter() {
        return DateFormatProvider.getDateFormat();
    }
}

