/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fcg.bcel;

import com.ibm.fcg.FcgAttrs;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgMethodGen;
import com.ibm.fcg.FcgReferenceType;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.FcgVariable;
import com.ibm.fcg.bcel.FcgClassGenBCEL;
import com.ibm.fcg.bcel.FcgCodeGenBCEL;
import com.ibm.fcg.bcel.FcgInstructionListBCEL;
import com.ibm.fcg.ifacecore.FcgBasicType;
import com.ibm.fcg.impl.FcgMethodGenImpl;
import com.ibm.fcg.impl.FinalCodeGenerator;
import com.ibm.fcg.impl.HiddenOptions;
import com.ibm.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.MethodGen;
import com.ibm.xtq.bcel.generic.Type;
import java.util.ArrayList;

public class FcgMethodGenBCEL
extends FcgMethodGenImpl
implements FcgMethodGen {
    private MethodGen m_bcelMethodGen;
    protected FcgClassGenBCEL m_classGen;
    protected FcgReferenceType m_className;
    protected final String m_methodName;
    protected FcgType[] m_throws;
    protected final boolean m_isStatic;
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final String S_HIDDEN_OPT_REG_INFO = "fcg.register.info";
    static final boolean S_REG_INFO_SPECIFIED = HiddenOptions.wasSpecified("fcg.register.info");
    public static final String S_REG_INFO_VALUE = S_REG_INFO_SPECIFIED ? HiddenOptions.getStringValue("fcg.register.info") : null;
    private static final FcgInstructionListBCEL.BcelVariable s_float = new FcgInstructionListBCEL.BcelVariable();
    private static final FcgInstructionListBCEL.BcelVariable s_double = new FcgInstructionListBCEL.BcelVariable();
    private static final FcgInstructionListBCEL.BcelVariable s_long = new FcgInstructionListBCEL.BcelVariable();
    private static final FcgInstructionListBCEL.BcelVariable s_ref = new FcgInstructionListBCEL.BcelVariable();
    private static final FcgInstructionListBCEL.BcelVariable s_int = new FcgInstructionListBCEL.BcelVariable();
    private final RegistersInUse m_registers;

    public FcgMethodGenBCEL(FcgClassGen fcgClassGen, FcgAttrs fcgAttrs, FcgType fcgType, FcgReferenceType fcgReferenceType, String string, FcgInstructionList fcgInstructionList) {
        super(fcgClassGen, fcgInstructionList);
        fcgInstructionList = this.m_code;
        this.m_isStatic = fcgAttrs.isStatic();
        this.m_registers = new RegistersInUse();
        this.m_classGen = (FcgClassGenBCEL)fcgClassGen;
        if (fcgAttrs == null) {
            fcgAttrs = FcgAttrs.PUBLIC;
        }
        this.m_attrs = fcgAttrs;
        this.m_retType = fcgType;
        this.m_className = fcgReferenceType;
        if (string == null) {
            string = "<init>";
        }
        this.m_methodName = string;
        ConstantPoolGen constantPoolGen = this.m_classGen.getbcelConstPool();
        InstructionList instructionList = fcgInstructionList == null ? null : ((FcgInstructionListBCEL)fcgInstructionList).getCode();
        int n = FcgCodeGenBCEL.fcg2bcelAttrs(fcgAttrs);
        Type type = FcgCodeGenBCEL.fcg2bcelType(fcgType);
        String[] stringArray = EMPTY_STRING_ARRAY;
        String string2 = fcgReferenceType.getTypeName();
        this.m_bcelMethodGen = null;
    }

    public FcgMethodGenBCEL(FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList) {
        super(fcgClassGen, fcgInstructionList);
        fcgInstructionList = this.m_code;
        this.m_attrs = FcgAttrs.PUBLIC;
        this.m_isStatic = this.m_attrs.isStatic();
        this.m_registers = new RegistersInUse();
        this.m_classGen = (FcgClassGenBCEL)fcgClassGen;
        this.m_methodName = "<init>";
        this.m_retType = FcgBasicType.VOID;
        int n = FcgCodeGenBCEL.fcg2bcelAttrs(this.m_attrs);
        String[] stringArray = EMPTY_STRING_ARRAY;
        String string = this.m_classGen.getClassName();
        InstructionList instructionList = fcgInstructionList != null ? ((FcgInstructionListBCEL)fcgInstructionList).getCode() : new InstructionList();
        this.m_bcelMethodGen = new MethodGen(n, (Type)Type.VOID, Type.NO_ARGS, stringArray, this.m_methodName, string, instructionList, this.m_classGen.getbcelConstPool());
    }

    public void finish() {
        this.m_bcelMethodGen.setMaxLocals();
        this.m_bcelMethodGen.setMaxStack();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Method: " + this.m_methodName);
        return stringBuffer.toString();
    }

    public FcgType getReturnType() {
        return this.m_retType;
    }

    public FcgType[] getArgumentTypes() {
        int n = this.m_parms.size();
        FcgType[] fcgTypeArray = new FcgType[this.m_parms.size()];
        for (int i = 0; i < n; ++i) {
            fcgTypeArray[i] = ((FcgVariable)this.m_parms.get(i)).getType();
        }
        return fcgTypeArray;
    }

    public String[] getArgumentNames() {
        int n = this.m_parms.size();
        String[] stringArray = new String[this.m_parms.size()];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((FcgVariable)this.m_parms.get(i)).getName();
        }
        return stringArray;
    }

    public String getName() {
        return this.m_methodName;
    }

    public FcgAttrs getAttributes() {
        return this.m_attrs;
    }

    public FcgVariable addParameter(FcgType fcgType, String string) {
        int n;
        FcgVariable fcgVariable = ((FinalCodeGenerator)this.m_code).defineMethodParam(FcgAttrs.NONE, fcgType, string);
        if (FinalCodeGenerator.DO_COMPILE_CHECKING && string != null) {
            n = this.m_parms.size();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(((FcgVariable)this.m_parms.get(i)).getName())) continue;
                FcgInstructionListBCEL.error("FCG: method " + this.getName() + " has more than on parameter with the name " + string);
            }
        }
        this.m_parms.add(fcgVariable);
        n = this.m_registers.getFreeReg(fcgType);
        ((FcgInstructionListBCEL.BcelVariable)fcgVariable).setRegister(n);
        this.m_registers.setReg(n, fcgVariable);
        return fcgVariable;
    }

    public void setExceptionTypes(FcgClassReferenceType[] fcgClassReferenceTypeArray) {
        this.m_throws = fcgClassReferenceTypeArray;
        for (int i = 0; i < fcgClassReferenceTypeArray.length; ++i) {
            String string = fcgClassReferenceTypeArray[i].getTypeName();
        }
    }

    protected MethodGen getBCELMethodGen() {
        return this.m_bcelMethodGen;
    }

    public void setBCELMethodGen(MethodGen methodGen) {
        this.m_bcelMethodGen = methodGen;
    }

    RegistersInUse getRegisters() {
        return this.m_registers;
    }

    static {
        s_float.setType(FcgType.FLOAT);
        s_double.setType(FcgType.DOUBLE);
        s_long.setType(FcgType.LONG);
        s_ref.setType(FcgType.OBJECT);
        s_int.setType(FcgType.INT);
        s_float.setName("*** UNUSED, WAS FLOAT ***");
        s_double.setName("*** UNUSED, WAS DOUBLE ***");
        s_long.setName("*** UNUSED, WAS LONG ***");
        s_ref.setName("*** UNUSED, WAS REF ***");
        s_int.setName("*** UNUSED, WAS INT ***");
    }

    class RegistersInUse {
        private int m_regs_requested;
        static final boolean trace = false;
        final int first;
        final ArrayList reg2FcgVari = new ArrayList();
        int m_firstUnusedReg;

        private RegistersInUse() {
            if (FcgMethodGenBCEL.this.m_isStatic) {
                this.first = 0;
                this.m_firstUnusedReg = 0;
            } else {
                this.reg2FcgVari.add(0, null);
                this.first = 1;
                this.m_firstUnusedReg = 1;
                if (S_REG_INFO_SPECIFIED) {
                    this.m_regs_requested = 1;
                }
            }
        }

        final void setReg(int n, FcgVariable fcgVariable) {
            int n2;
            boolean bl;
            FcgType fcgType = fcgVariable.getType();
            boolean bl2 = bl = fcgType == FcgType.LONG || fcgType == FcgType.DOUBLE;
            if (n == this.m_firstUnusedReg) {
                this.m_firstUnusedReg = bl ? (this.m_firstUnusedReg += 2) : ++this.m_firstUnusedReg;
            }
            if (n < (n2 = this.reg2FcgVari.size())) {
                this.setRegister(n, fcgVariable);
                if (bl) {
                    if (n + 1 == n2) {
                        this.reg2FcgVari.add(null);
                    }
                    this.setRegister(n + 1, fcgVariable);
                }
            } else if (n == n2) {
                this.reg2FcgVari.add(fcgVariable);
                if (bl) {
                    this.reg2FcgVari.add(n + 1, fcgVariable);
                }
            } else if (n == n2 + 1) {
                this.reg2FcgVari.add(null);
                this.reg2FcgVari.add(fcgVariable);
                if (bl) {
                    this.reg2FcgVari.add(n + 1, fcgVariable);
                }
            }
        }

        private void setRegister(int n, FcgVariable fcgVariable) {
            this.reg2FcgVari.set(n, fcgVariable);
        }

        private final FcgVariable getRegister(int n) {
            return (FcgVariable)this.reg2FcgVari.get(n);
        }

        private final int getMaxReg() {
            return this.reg2FcgVari.size();
        }

        private final String getRegVarName(int n) {
            FcgVariable fcgVariable = this.getRegister(n);
            if (fcgVariable == null) {
                return null;
            }
            return fcgVariable.getName();
        }

        private final FcgType getRegType(int n) {
            FcgVariable fcgVariable = this.getRegister(n);
            if (fcgVariable == null) {
                return null;
            }
            return fcgVariable.getType();
        }

        int getFreeReg(FcgType fcgType) {
            if (S_REG_INFO_SPECIFIED) {
                this.m_regs_requested = fcgType == FcgType.LONG || fcgType == FcgType.DOUBLE ? (this.m_regs_requested += 2) : ++this.m_regs_requested;
            }
            int n = this.getMaxReg();
            int n2 = this.m_firstUnusedReg;
            for (n2 = this.m_firstUnusedReg; n2 < n; ++n2) {
                FcgVariable fcgVariable = this.getRegister(n2);
                if (!this.notInUse(n2)) continue;
                if (fcgType == FcgType.DOUBLE && fcgVariable != s_double) {
                    if (n2 + 1 < n) {
                        if (!this.notInUse(n2 + 1)) continue;
                        return n2;
                    }
                    return n2;
                }
                if (fcgType instanceof FcgReferenceType && fcgVariable != s_ref) {
                    return n2;
                }
                if (fcgType == FcgType.FLOAT && fcgVariable != s_float) {
                    return n2;
                }
                if (fcgType == FcgType.LONG && fcgVariable != s_long) {
                    if (n2 + 1 < n) {
                        if (!this.notInUse(n2 + 1)) continue;
                        return n2;
                    }
                    return n2;
                }
                if (fcgVariable == s_int) continue;
                return n2;
            }
            for (n2 = this.m_firstUnusedReg; n2 < n; ++n2) {
                if (!this.notInUse(n2)) continue;
                if (fcgType == FcgType.LONG || fcgType == FcgType.DOUBLE) {
                    if (n2 + 1 == n) {
                        return n2;
                    }
                    if (n2 + 1 >= n || !this.notInUse(n2 + 1)) continue;
                    return n2;
                }
                return n2;
            }
            n2 = n == 0 ? this.first : n;
            return n2;
        }

        private boolean notInUse(int n) {
            FcgVariable fcgVariable = this.getRegister(n);
            return fcgVariable == s_ref || fcgVariable == s_int || fcgVariable == s_double || fcgVariable == s_long || fcgVariable == s_float;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("REGISTERS USAGE: (all regs below " + this.m_firstUnusedReg + " in use)\n");
            for (int i = 0; i < this.getMaxReg(); ++i) {
                String string;
                FcgType fcgType = this.getRegType(i);
                if (fcgType != null) {
                    string = this.getRegVarName(i);
                    String string2 = "" + i + " :     ";
                    string2 = string2.substring(0, 5);
                    stringBuffer.append(string2).append(" : ");
                    stringBuffer.append(string).append(", ").append(((Object)fcgType).toString());
                    stringBuffer.append('\n');
                    continue;
                }
                string = "" + i + " : *** USED, BUT NOT PRESENTLY IN USE ***\n";
                stringBuffer.append(string);
            }
            if (S_REG_INFO_SPECIFIED) {
                stringBuffer.append("without register re-use " + this.m_regs_requested + " would have been used\n");
            }
            return stringBuffer.toString();
        }

        void clearReg(FcgInstructionListBCEL.BcelVariable bcelVariable) {
            int n = bcelVariable.getRegister();
            FcgType fcgType = this.getRegType(n);
            if (n < this.m_firstUnusedReg) {
                this.m_firstUnusedReg = n;
            }
            if (fcgType == FcgType.INT) {
                this.setRegister(n, s_int);
            } else if (fcgType instanceof FcgReferenceType) {
                this.setRegister(n, s_ref);
            } else if (fcgType == FcgType.LONG) {
                this.setRegister(n, s_long);
                this.setRegister(n + 1, s_long);
            } else if (fcgType == FcgType.DOUBLE) {
                this.setRegister(n, s_double);
                this.setRegister(n + 1, s_double);
            } else if (fcgType == FcgType.FLOAT) {
                this.setRegister(n, s_float);
            } else {
                this.setRegister(n, s_int);
            }
        }
    }
}

