/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.am;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManagerThread;
import com.ibm.ejs.util.am.AlarmThreadPool;
import com.ibm.ejs.util.am._Alarm;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import java.util.Vector;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;

public class AlarmManager {
    private static final TraceComponent tc = Tr.register(AlarmManager.class, null, null);
    public static final String ALARM_WORKBASED = "com.ibm.ejs.am.mode.workbased";
    static final ConcurrentSkipListMap<_Alarm, _Alarm> deferredAlarmQ = new ConcurrentSkipListMap();
    static final ConcurrentSkipListMap<_Alarm, _Alarm> nonDeferredAlarmQ = new ConcurrentSkipListMap();
    static AlarmManagerThread deferredAlarmManagerThread;
    static AlarmManagerThread nonDeferredAlarmManagerThread;
    private static boolean initialized;
    private static boolean deferred;
    private static Vector<_Alarm> deferredAlarmList;
    private static int activeWork;
    private static final Executor deferrableExecutor;
    private static final Executor nondeferrableExecutor;

    private AlarmManager() {
    }

    private static final synchronized void init() {
        if (initialized) {
            return;
        }
        if (PlatformHelperFactory.getPlatformHelper().isBaseServantJvm()) {
            deferred = true;
        }
        deferredAlarmManagerThread = new AlarmManagerThread(deferredAlarmQ, deferred);
        Thread dThread = new Thread((Runnable)deferredAlarmManagerThread, "Deferred Alarm Manager");
        dThread.setDaemon(true);
        dThread.start();
        nonDeferredAlarmManagerThread = new AlarmManagerThread(nonDeferredAlarmQ, false);
        Thread ndThread = new Thread((Runnable)nonDeferredAlarmManagerThread, "Non-Deferred Alarm Manager");
        ndThread.setDaemon(true);
        ndThread.start();
        initialized = true;
    }

    public static final Alarm create(long n, AlarmListener listener, Object alarmContext) {
        return AlarmManager.createDeferrable(n, listener, alarmContext);
    }

    public static final Alarm create(long n, AlarmListener listener) {
        return AlarmManager.createDeferrable(n, listener, null);
    }

    public static final Alarm createNonDeferrable(long n, AlarmListener l, Object alarmContext) {
        return AlarmManager.createNonDeferrable(n, l, alarmContext, nondeferrableExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Alarm createNonDeferrable(long n, AlarmListener l, Object alarmContext, Executor executor) {
        AlarmManager.init();
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "createNonDeferrable", new Object[]{new Long(n), l, alarmContext, executor});
        }
        if (l == null) {
            throw new NullPointerException();
        }
        if (n < 0L) {
            n = 0L;
        }
        if ((n += System.currentTimeMillis()) < 0L) {
            n = Long.MAX_VALUE;
        }
        _Alarm result = new _Alarm(n, l, alarmContext, false, executor);
        nonDeferredAlarmQ.put(result, result);
        _Alarm waitingOn = AlarmManager.nonDeferredAlarmManagerThread.waitingOn;
        if (waitingOn == null || result.compareTo(waitingOn) < 0) {
            ConcurrentSkipListMap<_Alarm, _Alarm> concurrentSkipListMap = nonDeferredAlarmQ;
            synchronized (concurrentSkipListMap) {
                nonDeferredAlarmQ.notify();
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "createNonDeferrable", result);
        }
        return result;
    }

    public static final Alarm createNonDeferrable(long n, AlarmListener l) {
        return AlarmManager.createNonDeferrable(n, l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Alarm createDeferrable(long n, AlarmListener l, Object alarmContext) {
        AlarmManager.init();
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "createDeferrable", new Object[]{new Long(n), l, alarmContext});
        }
        if (l == null) {
            throw new NullPointerException();
        }
        if (n < 0L) {
            n = 0L;
        }
        _Alarm result = new _Alarm(n, l, alarmContext, true, deferrableExecutor);
        if (!deferred || activeWork > 0) {
            result.expirationTime += System.currentTimeMillis();
            if (result.expirationTime < 0L) {
                result.expirationTime = Long.MAX_VALUE;
            }
            deferredAlarmQ.put(result, result);
            _Alarm waitingOn = AlarmManager.deferredAlarmManagerThread.waitingOn;
            if (waitingOn == null || result.compareTo(waitingOn) < 0) {
                ConcurrentSkipListMap<_Alarm, _Alarm> concurrentSkipListMap = deferredAlarmQ;
                synchronized (concurrentSkipListMap) {
                    deferredAlarmQ.notify();
                }
            }
        } else {
            if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                Tr.debug(tc, "Alarm has been deferred", result);
            }
            Vector<_Alarm> vector = deferredAlarmList;
            synchronized (vector) {
                deferredAlarmList.add(result);
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "createDeferrable", result);
        }
        return result;
    }

    public static final Alarm createDeferrable(long n, AlarmListener l) {
        return AlarmManager.createDeferrable(n, l, null);
    }

    static final void cancel(Alarm a) {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel");
        }
        AlarmManager.disableAlarm(a);
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean disableAlarm(Alarm a) {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "disableAlarm", a);
        }
        boolean disabled = false;
        Object object = a;
        synchronized (object) {
            if (!((_Alarm)a).fired) {
                disabled = true;
                ((_Alarm)a).fired = true;
            }
        }
        if (((_Alarm)a).deferrable) {
            object = deferredAlarmList;
            synchronized (object) {
                deferredAlarmList.remove(a);
            }
            deferredAlarmQ.remove(a);
        } else {
            nonDeferredAlarmQ.remove(a);
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "disableAlarm", disabled);
        }
        return disabled;
    }

    private static final void armDeferredAlarms() {
        AlarmManager.createNonDeferrable(1000L, new AlarmListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alarm(Object alarmContext) {
                _Alarm result = null;
                boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
                ConcurrentSkipListMap<_Alarm, _Alarm> concurrentSkipListMap = deferredAlarmQ;
                synchronized (concurrentSkipListMap) {
                    Vector vector = deferredAlarmList;
                    synchronized (vector) {
                        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Starting arm of " + deferredAlarmList.size() + " deferred alarms");
                        }
                        for (int ix = 0; ix < deferredAlarmList.size(); ++ix) {
                            result = (_Alarm)deferredAlarmList.elementAt(ix);
                            result.expirationTime += System.currentTimeMillis();
                            if (result.expirationTime < 0L) {
                                result.expirationTime = Long.MAX_VALUE;
                            }
                            deferredAlarmQ.put(result, result);
                        }
                        deferredAlarmList.clear();
                        if (isAnyTracingEnabled && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Completed arm of deferred alarms");
                        }
                        deferredAlarmQ.notify();
                    }
                }
            }
        });
    }

    public static synchronized void incActiveWork() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "activeWork = " + activeWork);
        }
        if (activeWork == 0) {
            AlarmManager.armDeferredAlarms();
        }
        ++activeWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decActiveWork() {
        ConcurrentSkipListMap<_Alarm, _Alarm> concurrentSkipListMap = deferredAlarmQ;
        synchronized (concurrentSkipListMap) {
            Class<AlarmManager> clazz = AlarmManager.class;
            synchronized (AlarmManager.class) {
                --activeWork;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "activeWork = " + activeWork);
                }
                if (activeWork == 0) {
                    deferredAlarmQ.notify();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
    }

    public static synchronized int getActiveWork() {
        return activeWork;
    }

    static {
        initialized = false;
        deferred = false;
        deferredAlarmList = new Vector();
        activeWork = 0;
        deferrableExecutor = new ThreadPoolExecutor(new AlarmThreadPool("Deferrable Alarm"));
        nondeferrableExecutor = new ThreadPoolExecutor(new AlarmThreadPool("Non-deferrable Alarm"));
    }

    private static class ThreadPoolExecutor
    implements Executor {
        private ThreadPool threadPool;

        public ThreadPoolExecutor(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        public String toString() {
            return super.toString() + '[' + this.threadPool + ']';
        }

        public void execute(Runnable command) {
            try {
                this.threadPool.execute(command);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

