/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.ASSERT;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.util.AccessController;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;

public class Uuid
implements Serializable {
    protected long low64Bits;
    protected static long logicalTime = 0L;
    protected int timeLow;
    protected short timeMid;
    protected short timeHigh;
    protected short clockSeq;
    protected byte[] node = new byte[6];
    protected static byte[] thisIpAddress = null;
    protected String uuidString = null;
    protected static byte[] badadd = new byte[]{11, 10, 13, 10, 13, 13};
    static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long serialVersionUID = -3465601508791529063L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uuid() {
        Class<Uuid> clazz = Uuid.class;
        synchronized (Uuid.class) {
            int i;
            this.low64Bits = System.currentTimeMillis();
            if (logicalTime >= this.low64Bits) {
                this.low64Bits = ++logicalTime;
            } else {
                logicalTime = this.low64Bits;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.clockSeq = (short)this.hashCode();
            byte[] tmpnode = this.getIpAddress();
            for (i = 0; i < tmpnode.length && i < 4; ++i) {
                this.node[i] = tmpnode[i];
            }
            while (i < 4) {
                this.node[i++] = 0;
            }
            this.node[4] = -86;
            this.node[5] = 119;
            this.timeLow = (int)this.low64Bits & 0xFFFFFFFF;
            this.timeMid = (short)(this.low64Bits >> 32 & 0xFFFFL);
            this.timeHigh = (short)(this.low64Bits >> 48 & 0xFFFFL);
            if (this.timeHigh == 0) {
                Random r = new Random(this.timeLow);
                int rint = r.nextInt();
                this.timeHigh = (short)(this.timeHigh | rint | 0xE000);
            }
            this.uuidString = Integer.toHexString(this.timeLow) + "-" + Uuid.toHexString(this.timeMid) + "-" + Uuid.toHexString(this.timeHigh) + "-" + Uuid.toHexString(this.clockSeq) + "-";
            for (i = 0; i < 6; ++i) {
                this.uuidString = this.uuidString + Uuid.toHexString(this.node[i]);
            }
            return;
        }
    }

    public String toString() {
        return this.uuidString;
    }

    public boolean isEqual(Uuid uuid) {
        return uuid.toString().equals(this.uuidString);
    }

    private static String toHexString(short v) {
        char[] c = new char[]{hexChars[v >> 12 & 0xF], hexChars[v >> 8 & 0xF], hexChars[v >> 4 & 0xF], hexChars[v & 0xF]};
        return new String(c, 0, 4);
    }

    private static String toHexString(byte v) {
        char[] c = new char[]{hexChars[v >> 4 & 0xF], hexChars[v & 0xF]};
        return new String(c, 0, 2);
    }

    private byte[] getIpAddress() {
        if (thisIpAddress == null) {
            InetAddress localHostAddress = null;
            try {
                try {
                    localHostAddress = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws UnknownHostException {
                            return InetAddress.getLocalHost();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ejs.util.Uuid.getIpAddress", "291", this);
                    throw (UnknownHostException)e.getException();
                }
                thisIpAddress = localHostAddress.getAddress();
            }
            catch (UnknownHostException ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ejs.util.Uuid.getIpAddress", "298", this);
                return badadd;
            }
        }
        return thisIpAddress;
    }

    public static void main(String[] args) {
        Uuid uuid = new Uuid();
        if (args.length > 0) {
            int howMany = Integer.parseInt(args[0]);
            Uuid[] uuids = new Uuid[howMany];
            for (int i = 0; i < howMany; ++i) {
                uuids[i] = new Uuid();
                System.out.println("Uuid #" + (i + 1) + ": " + uuids[i].toString());
            }
            ASSERT.isTrue(uuid.isEqual(uuid));
            ASSERT.isFalse(uuid.isEqual(uuids[howMany - 1]));
        } else {
            System.out.println(uuid.toString());
        }
    }
}

