/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ffdc.Manager;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Random;

public class ThreadLocal {
    ReferenceQueue queue = new ReferenceQueue();
    int nbuckets = 127;
    Entry[] buckets = new Entry[this.nbuckets];

    protected Object initialValue() {
        return null;
    }

    public Object get() {
        Entry ourEntry = this.ourEntry(true);
        return ourEntry == null ? null : ourEntry.value;
    }

    public void set(Object value) {
        this.clean();
        Entry ourEntry = this.ourEntry(false);
        ourEntry.value = value;
    }

    private Entry ourEntry(boolean doingGet) {
        int bucketIndex;
        Thread ourThread = Thread.currentThread();
        Entry ourEntry = this.lookup(ourThread, bucketIndex = (ourThread.hashCode() & Integer.MAX_VALUE) % this.nbuckets);
        if (ourEntry == null) {
            Object value;
            Object object = value = doingGet ? this.initialValue() : null;
            if (value != null || !doingGet) {
                ourEntry = new Entry(ourThread, bucketIndex, value, this.queue);
                this.insert(ourEntry);
            }
        }
        return ourEntry;
    }

    void clean() {
        Entry oldEntry;
        while ((oldEntry = (Entry)this.queue.poll()) != null) {
            this.remove(oldEntry);
        }
    }

    Entry lookup(Thread t, int bucketIndex) {
        Entry e = this.buckets[bucketIndex];
        while (e != null) {
            if (e.get() == t) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(Entry e) {
        Entry[] entryArray = this.buckets;
        synchronized (this.buckets) {
            e.next = this.buckets[e.bucketIndex];
            this.buckets[e.bucketIndex] = e;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Entry e) {
        Entry[] entryArray = this.buckets;
        synchronized (this.buckets) {
            Entry x = this.buckets[e.bucketIndex];
            if (x == e) {
                this.buckets[e.bucketIndex] = x.next;
            } else {
                while (x != null) {
                    if (x.next == e) {
                        x.next = e.next;
                        break;
                    }
                    x = x.next;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static void main(String[] args) {
        final ThreadLocal var = new ThreadLocal(){

            protected Object initialValue() {
                return new Integer(0);
            }

            void remove(Entry e) {
                System.out.println("removing");
                super.remove(e);
            }

            void insert(Entry e) {
                System.out.println("insert " + Thread.currentThread() + " entry " + e + " bucket " + e.bucketIndex);
                if (this.buckets[e.bucketIndex] != null) {
                    System.out.println("bucket collision " + e.bucketIndex);
                }
                super.insert(e);
            }
        };
        final Random r = new Random();
        int threadCount = Integer.parseInt(args[0]);
        int i = 0;
        while (i < threadCount) {
            final int ii = i++;
            new Thread(){

                public void run() {
                    Object[] stuff = new Object[100];
                    System.out.println("Thread " + ii + " starting");
                    for (int j = 0; j < 100; ++j) {
                        Integer k = (Integer)var.get();
                        if (k != j) {
                            System.err.println("MISMATCH");
                        }
                        ThreadLocal.pause((r.nextInt() & 0xFF) + 100);
                        var.set(new Integer(j + 1));
                        for (int n = 0; n < j; ++n) {
                            stuff[n] = new byte[10240];
                        }
                    }
                    System.out.println("Thread " + ii + " done");
                }
            }.start();
            ThreadLocal.pause(2500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pause(int millis) {
        Object o = new Object();
        try {
            Object object = o;
            synchronized (object) {
                o.wait(millis);
            }
        }
        catch (InterruptedException e) {
            Manager.Ffdc.log(e, ThreadLocal.class, "com.ibm.ejs.util.ThreadLocal.pause", "129");
        }
    }

    static class Entry
    extends WeakReference {
        Object value;
        Entry next;
        int bucketIndex;

        Entry(Object thread, int bucketIndex, Object value, ReferenceQueue queue) {
            super(thread, queue);
            this.value = value;
            this.bucketIndex = bucketIndex;
        }
    }
}

