/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ffdc.Manager;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;

public class IndentTrace {
    private static String inFile = null;
    private static String outFile = null;
    private static Hashtable threadsTable = new Hashtable();
    private static final int POS1 = 7;
    private static final int POS2 = 15;
    private static final int POS3 = 31;
    private static int currentIndent = 0;

    public static void main(String[] args) throws IOException {
        if (args.length > 2) {
            System.out.println("Wrong number of Args \nUsage: java IndentTrace [inFile] [outFile]");
            System.exit(1);
        }
        if (args.length >= 1) {
            inFile = args[0];
        }
        if (args.length == 2) {
            outFile = args[1];
        }
        BufferedReader bin = null;
        PrintWriter os = null;
        try {
            bin = inFile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(inFile));
            os = outFile == null ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(outFile));
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, IndentTrace.class, "com.ibm.ejs.util.IndentTrace.main", "71");
            System.out.println("Error when creating input or output stream");
            System.exit(1);
        }
        String currentLine = null;
        while ((currentLine = bin.readLine()) != null) {
            if (currentLine.length() > 33) {
                char c1 = currentLine.charAt(30);
                char c2 = currentLine.charAt(31);
                char c3 = currentLine.charAt(32);
                if (c1 == ' ' && c3 == ' ' && (c2 == '>' || c2 == '<' || c2 == 'F' || c2 == 'E' || c2 == 'D' || c2 == 'W' || c2 == 'X')) {
                    String tmp = IndentTrace.processLine(currentLine, c2);
                    IndentTrace.writeLine(os, tmp);
                    continue;
                }
                String sub1 = currentLine.substring(0, 31);
                StringBuffer sb = new StringBuffer();
                boolean isSecondCase = true;
                for (int i = 0; i < 31; ++i) {
                    if (sub1.charAt(i) == ' ') continue;
                    isSecondCase = false;
                }
                if (isSecondCase) {
                    StringBuffer indent = new StringBuffer();
                    for (int i = 0; i < currentIndent; ++i) {
                        indent.append(' ');
                    }
                    currentLine = indent.append(currentLine).toString();
                    IndentTrace.writeLine(os, currentLine);
                    continue;
                }
                IndentTrace.writeLine(os, currentLine);
                continue;
            }
            IndentTrace.writeLine(os, currentLine);
        }
        if (os != null) {
            os.close();
        }
        System.exit(0);
    }

    private static String processLine(String line, char c) {
        StringBuffer sb = new StringBuffer();
        Integer indent = null;
        int indentVal = 0;
        String threadId = line.substring(8, 16);
        indent = (Integer)threadsTable.get(threadId);
        if (indent != null) {
            indentVal = indent;
            if (c == '>') {
                indent = new Integer(++indentVal);
                threadsTable.put(threadId, indent);
            } else if (c == '<') {
                int indentVal1 = indentVal;
                indent = new Integer(--indentVal1);
                threadsTable.put(threadId, indent);
            }
            currentIndent = indentVal;
        } else {
            threadsTable.put(threadId, new Integer(0));
            currentIndent = 0;
        }
        sb.append(line.substring(0, 30));
        while (indentVal > 0) {
            sb.append(' ');
            --indentVal;
        }
        sb.append(line.substring(30));
        return sb.toString();
    }

    private static void writeLine(PrintWriter os, String s) throws IOException {
        if (os != null) {
            os.println(s);
        } else {
            System.out.println(s);
        }
    }
}

