/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.ExternalStore;
import com.ibm.ffdc.Manager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileStore
implements ExternalStore {
    private String rootDir;

    public FileStore() {
        this(System.getProperty("java.tmpdir"));
    }

    public FileStore(String directory) {
        this.rootDir = directory;
    }

    public String store(Object o) throws IOException {
        String hash = Integer.toString(o.hashCode());
        this.store(hash, o);
        return hash;
    }

    public synchronized void store(Object key, Object o) throws IOException {
        String filename = o.getClass().getName();
        String skey = (String)key;
        try {
            FileOutputStream fos = new FileOutputStream(this.rootDir + skey);
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            ObjectOutputStream os = new ObjectOutputStream(gzos);
            os.writeObject(o);
            os.flush();
            os.close();
        }
        catch (Throwable e) {
            Manager.Ffdc.log(e, this, "com.ibm.ejs.util.FileStore.store", "87", this);
        }
    }

    public synchronized Object retrieve(Object key) throws IOException, ClassNotFoundException {
        String skey = (String)key;
        FileInputStream fis = new FileInputStream(this.rootDir + skey);
        GZIPInputStream gzis = new GZIPInputStream(fis);
        ObjectInputStream is = new ObjectInputStream(gzis);
        Object o = is.readObject();
        is.close();
        File f = new File(this.rootDir + skey);
        f.delete();
        return o;
    }

    public static void main(String[] args) {
        System.out.println(System.getProperties().toString());
        String key = null;
        if (args.length != 0) {
            FileStore fs = new FileStore();
            Properties p = new Properties();
            try {
                p = (Properties)fs.retrieve(args[0]);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, FileStore.class, "com.ibm.ejs.util.FileStore.main", "117");
                System.out.println("FileStore test failed: " + e.toString());
            }
            p.list(System.out);
        } else {
            FileStore fs = new FileStore();
            System.out.println("New file store constructed");
            try {
                key = fs.store(System.getProperties());
            }
            catch (IOException e) {
                Manager.Ffdc.log(e, FileStore.class, "com.ibm.ejs.util.FileStore.main", "129");
                System.out.println("File Store test failed: " + e.toString());
            }
            System.out.println("Stored object in file: " + key);
        }
    }
}

