/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.Bucket;
import com.ibm.ejs.util.Element;
import com.ibm.ffdc.Manager;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastHashtable<K, V>
extends Dictionary<K, V> {
    private static final boolean isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    protected Bucket<K, V>[] buckets;
    protected int size = 0;

    public FastHashtable(int expectedEntries) {
        this.buckets = new Bucket[expectedEntries];
        if (!isZOS) {
            for (int i = 0; i < expectedEntries; ++i) {
                this.buckets[i] = new Bucket();
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object getLock(K key) {
        return this.getBucketForKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(K key) {
        Bucket<K, V> bucket;
        Bucket<K, V> bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            return element != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Bucket<Object, V> bucket;
        Object k = key;
        Bucket<Object, V> bucket2 = bucket = this.getBucketForKey(k);
        synchronized (bucket2) {
            Element element = bucket.findByKey(k);
            return element != null ? (V)element.ivObject : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Object k = key;
        Bucket<Object, V> bucket = this.getBucketForKey(k);
        Element element = null;
        Object object = bucket;
        synchronized (object) {
            element = bucket.removeByKey(k);
        }
        if (element != null) {
            object = this;
            synchronized (object) {
                --this.size;
            }
            return element.ivObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V object) {
        Bucket<K, V> bucket;
        FastHashtable fastHashtable = this;
        synchronized (fastHashtable) {
            ++this.size;
        }
        Bucket<K, V> bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element e = bucket.replaceByKey(key, object);
            return e != null ? (V)e.ivObject : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(K key, V object) {
        Bucket<K, V> bucket;
        FastHashtable fastHashtable = this;
        synchronized (fastHashtable) {
            ++this.size;
        }
        Bucket<K, V> bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            bucket.addByKey(key, object);
        }
    }

    @Override
    public final Enumeration elements() {
        return new ObjectEnumerator();
    }

    @Override
    public final Enumeration keys() {
        return new KeyEnumerator();
    }

    public synchronized void clear() {
        this.size = 0;
        this.buckets = new Bucket[this.buckets.length];
        if (!isZOS) {
            for (int i = 0; i < this.buckets.length; ++i) {
                this.buckets[i] = new Bucket();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Bucket<K, V> getBucketForKey(K key) {
        if (isZOS) {
            int bucket_index = (key.hashCode() & Integer.MAX_VALUE) % this.buckets.length;
            Bucket<K, V> thebucket = this.buckets[bucket_index];
            if (thebucket == null) {
                FastHashtable fastHashtable = this;
                synchronized (fastHashtable) {
                    thebucket = this.buckets[bucket_index];
                    if (thebucket == null) {
                        this.buckets[bucket_index] = thebucket = new Bucket();
                    }
                }
            }
            return thebucket;
        }
        return this.buckets[(key.hashCode() & Integer.MAX_VALUE) % this.buckets.length];
    }

    public Object get(Object bucket, Object key) {
        Element element = ((Bucket)bucket).findByKey(key);
        return element != null ? element.ivObject : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object bucket, Object key, Object object) {
        FastHashtable fastHashtable = this;
        synchronized (fastHashtable) {
            ++this.size;
        }
        Element e = ((Bucket)bucket).replaceByKey(key, object);
        return e != null ? e.ivObject : null;
    }

    class KeyEnumerator
    extends ElementEnumerator {
        KeyEnumerator() {
        }

        public Object nextElement() {
            return ((Element)super.nextElement()).ivKey;
        }
    }

    class ObjectEnumerator
    extends ElementEnumerator {
        ObjectEnumerator() {
        }

        public Object nextElement() {
            return ((Element)super.nextElement()).ivObject;
        }
    }

    class ElementEnumerator
    implements Enumeration {
        private int bucketIndex = 0;
        private Element ivCurrentBucketElement;

        ElementEnumerator() {
        }

        public boolean hasMoreElements() {
            if (this.ivCurrentBucketElement != null) {
                return true;
            }
            return this.findNextBucket();
        }

        public Object nextElement() {
            if (this.ivCurrentBucketElement == null && !this.findNextBucket()) {
                throw new NoSuchElementException();
            }
            while (true) {
                try {
                    Element nextElement = this.ivCurrentBucketElement;
                    this.ivCurrentBucketElement = this.ivCurrentBucketElement.ivNext;
                    return nextElement;
                }
                catch (NoSuchElementException e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ejs.util.FastHashtable.nextElement", "267", this);
                    if (this.findNextBucket()) continue;
                    throw new NoSuchElementException();
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean findNextBucket() {
            this.ivCurrentBucketElement = null;
            while (this.bucketIndex < FastHashtable.this.buckets.length) {
                Bucket bucket;
                if ((bucket = FastHashtable.this.buckets[this.bucketIndex++]) == null) continue;
                Bucket bucket2 = bucket;
                synchronized (bucket2) {
                    if (bucket.size() > 0) {
                        this.ivCurrentBucketElement = bucket.ivHead;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

