/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Bucket<K, V> {
    Element<K, V> ivHead = null;
    private int ivNumElements = 0;

    Bucket() {
    }

    Element findByKey(K key) {
        Element e = this.ivHead;
        while (e != null) {
            if (key.equals(e.ivKey)) {
                return e;
            }
            e = e.ivNext;
        }
        return null;
    }

    Element replaceByKey(K key, V object) {
        Element element = this.removeByKey(key);
        this.addByKey(key, object);
        return element;
    }

    void addByKey(K key, V object) {
        Element<K, V> newElement = new Element<K, V>(key, object);
        newElement.ivNext = this.ivHead;
        this.ivHead = newElement;
        ++this.ivNumElements;
    }

    Element removeByKey(K key) {
        Element previous = null;
        Element e = this.ivHead;
        while (e != null) {
            if (key.equals(e.ivKey)) {
                if (previous == null) {
                    this.ivHead = e.ivNext;
                } else {
                    previous.ivNext = e.ivNext;
                }
                --this.ivNumElements;
                return e;
            }
            previous = e;
            e = e.ivNext;
        }
        return null;
    }

    public int size() {
        return this.ivNumElements;
    }
}

