/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.csi.PoolImplBase;
import com.ibm.ejs.csi.PoolImplThreadSafe;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.csi.Pool;
import com.ibm.websphere.csi.PoolDiscardStrategy;
import com.ibm.websphere.csi.PoolManager;
import com.ibm.websphere.pmi.PmiBean;
import java.util.Vector;

public class PoolManagerImpl
extends PoolManager
implements AlarmListener {
    private Vector pools;
    private int previousNumPools = 10;
    private PoolImplBase[] poolArray = new PoolImplBase[10];
    private long drainInterval = 30000L;

    public void setDrainInterval(long di) {
        this.drainInterval = di;
    }

    public void alarm(Object alarmContext) {
        int i;
        int numPools = this.pools.size();
        if (numPools > 0) {
            if (numPools > this.previousNumPools) {
                this.poolArray = new PoolImplBase[numPools];
                this.previousNumPools = numPools;
            }
            this.poolArray = this.pools.toArray(this.poolArray);
            for (i = 0; i < this.poolArray.length && this.poolArray[i] != null; ++i) {
                if (this.poolArray[i].inactive) {
                    this.poolArray[i].periodicDrain();
                    continue;
                }
                this.poolArray[i].inactive = true;
            }
        }
        for (i = numPools; i < this.poolArray.length; ++i) {
            this.poolArray[i] = null;
        }
        AlarmManager.create(this.drainInterval, this, null);
    }

    public PoolManagerImpl() {
        this.pools = new Vector();
        AlarmManager.create(this.drainInterval, this, null);
    }

    void add(Pool p) {
        this.pools.addElement(p);
    }

    void remove(Pool p) {
        this.pools.removeElement(p);
    }

    public Pool createThreadSafePool(int minimum, int maximum) {
        PoolImplThreadSafe result = new PoolImplThreadSafe(minimum, maximum, 20, null, null, this);
        this.pools.addElement(result);
        return result;
    }

    public Pool createThreadSafePool(int minimum, int maximum, PmiBean beanPerf) {
        PoolImplThreadSafe result = new PoolImplThreadSafe(minimum, maximum, 20, beanPerf, null, this);
        this.pools.addElement(result);
        return result;
    }

    public Pool create(int minimum, int maximum, PmiBean beanPerf, PoolDiscardStrategy d) {
        PoolImplThreadSafe result = new PoolImplThreadSafe(minimum, maximum, 20, beanPerf, d, this);
        this.pools.addElement(result);
        return result;
    }
}

