/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.logger;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.StringWriter;

public class TraceWriter
extends StringWriter {
    private final TraceComponent destination;
    private static final TraceComponent tc = Tr.register(TraceWriter.class);

    public TraceWriter(TraceComponent dest) {
        this.destination = dest;
    }

    public TraceWriter(String componentName) {
        this.destination = Tr.register(componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            super.flush();
            this.formatTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            super.write(cbuf, off, len);
            this.formatTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) {
        Object object = this.lock;
        synchronized (object) {
            super.write(b);
            if (b == 10) {
                this.formatTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str) {
        Object object = this.lock;
        synchronized (object) {
            super.write(str);
            this.formatTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            super.write(str, off, len);
            this.formatTrace();
        }
    }

    public boolean isTraceEnabled() {
        return this.destination.isDebugEnabled();
    }

    private void formatTrace() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatTrace");
        }
        String str = this.toString();
        int start = 0;
        int end = str.indexOf(10);
        while (end >= 0) {
            Tr.debug(this.destination, str.substring(start, end));
            start = end + 1;
            end = str.indexOf(10, start);
        }
        this.getBuffer().delete(0, start);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatTrace");
        }
    }
}

