/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.IExtendedSecurityPriv.ComponentData;
import com.ibm.IExtendedSecurityPriv.ComponentDataHolder;
import com.ibm.IExtendedSecurityPriv.ObjectDoesNotExistHere;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityUtilityImpl.SecurityTaggedComponent;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.orbssl.SSLServerConnectionData;
import org.omg.CORBA.SystemException;

public final class SSLTaggedComponent
extends SecurityTaggedComponent {
    private static final TraceComponent tc = Tr.register(SSLTaggedComponent.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private int _SSLPort = 0;

    public int get_SSLPort() {
        return this._SSLPort;
    }

    private SSLTaggedComponent(byte[] taggedComponent) {
        try {
            CDRInputStream tagStream = ORB.createCDRInputStream(null, (byte[])taggedComponent, (int)taggedComponent.length);
            tagStream.consumeEndian();
            this.set_targetCoalescedSuppQOP(tagStream.read_short());
            this.set_targetCoalescedReqQOP(tagStream.read_short());
            this._SSLPort = tagStream.read_short();
            this.set_tagID(20);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSL Tag values: sslPort =  " + this._SSLPort + ", target requires  = " + this._targetCoalescedReqQOP + ", target supports = " + this._targetCoalescedSuppQOP);
            }
        }
        catch (SystemException e) {
            Manager.Ffdc.log(e, (Object)this, "com.ibm.ISecurityLocalObjectBaseL13Impl.SSLTaggedComponent.SSLTaggedComponent", "110", new Object[]{this});
            Tr.error(tc, "security.JSAS0449E", new Object[]{e});
        }
    }

    public static synchronized SSLTaggedComponent getSSLTaggedComponent(Profile profile, IOR ior) {
        byte[] tagComp = null;
        SSLTaggedComponent sslTaggedComponent = null;
        try {
            tagComp = profile.getTaggedComponent(20);
            if (ior != null && tagComp == null) {
                Profile proxyProfile = ior.getProfile(0);
                tagComp = proxyProfile.getTaggedComponent(20);
            }
            if (tagComp != null) {
                sslTaggedComponent = new SSLTaggedComponent(tagComp);
            }
            return sslTaggedComponent;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, SSLTaggedComponent.class, "com.ibm.ISecurityLocalObjectBaseL13Impl.SSLTaggedComponent.getSSLTaggedComponent", "157");
            return null;
        }
    }

    public static final ComponentDataHolder getSSLComponentData(SecurityConnectionInterceptor connInt) throws ObjectDoesNotExistHere {
        String logMethod = "SSLTaggedComponent.getSSLComponentData";
        String logMsg = null;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        try {
            boolean ssltaglistSize = true;
            short target_supports = 0;
            if (csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported") || csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired")) {
                target_supports = 32;
                target_supports = (short)(target_supports + 8);
                target_supports = (short)(target_supports + 16);
                if (csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported")) {
                    target_supports = (short)(target_supports + 64);
                }
                if (csiv2.getBoolean("com.ibm.CSI.claimMessageIntegritySupported")) {
                    target_supports = (short)(target_supports + 2);
                }
                if (csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialitySupported")) {
                    target_supports = (short)(target_supports + 4);
                }
            } else {
                target_supports = 1;
            }
            short target_requires = 0;
            if (csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired")) {
                target_requires = 16384;
                target_supports = (short)(target_supports + 32);
                target_supports = (short)(target_supports + 8);
                target_supports = (short)(target_supports + 16);
                if (csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired")) {
                    target_requires = (short)(target_requires + 64);
                }
                if (csiv2.getBoolean("com.ibm.CSI.claimMessageIntegrityRequired")) {
                    target_requires = (short)(target_requires + 2);
                }
                if (csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialityRequired")) {
                    target_requires = (short)(target_requires + 4);
                }
            } else {
                target_requires = 1;
            }
            int SSLPort = 0;
            SSLServerConnectionData serverConnData = null;
            serverConnData = csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired") || csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported") ? connInt.getCSIClientCertRegisteredSSLServerConnectionDataObject() : connInt.getCSIRegisteredSSLServerConnectionDataObject();
            if (serverConnData != null) {
                SSLPort = serverConnData.getServerPort();
                if (SSLPort == 0) {
                    logMsg = "security.JSAS0446E";
                    SecurityLogger.logError(logMsg, new Object[]{logMethod});
                }
            } else {
                SSLPort = csiv2.getInteger("com.ibm.CORBA.SSLPort");
            }
            ComponentDataHolder cDataHolder = new ComponentDataHolder();
            CDROutputStream SSLComponentBodyStream = ORB.createCDROutputStream(null);
            SSLComponentBodyStream.putEndian();
            SSLComponentBodyStream.write_short(target_supports);
            SSLComponentBodyStream.write_short(target_requires);
            SSLComponentBodyStream.write_short((short)SSLPort);
            byte[] SSLComponentBody = SSLComponentBodyStream.toByteArray();
            cDataHolder.value = new ComponentData(20, SSLComponentBody);
            return cDataHolder;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, SSLTaggedComponent.class, "com.ibm.ISecurityLocalObjectBaseL13Impl.SSLTaggedComponent.getSSLComponentData", "302");
            return null;
        }
    }
}

