/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

public class CSICredentialsManager {
    private static final TraceComponent tc = Tr.register(CSICredentialsManager.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    static CSICredentialsManager credsMgr = null;

    public static CSICredentialsManager getInstance() {
        if (credsMgr == null) {
            credsMgr = new CSICredentialsManager();
        }
        return credsMgr;
    }

    public synchronized Subject getInvocationSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvocationSubject", this);
        }
        Subject subject = null;
        WSCredential wsCred = null;
        CSIUtil csiUtil = new CSIUtil();
        ContextManager contextMgr = ContextManagerFactory.getInstance();
        try {
            subject = contextMgr.getInvocationSubject();
            wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
            if (subject != null && SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") && !contextMgr.getWSCredTokenMapper().checkValidityOfAllTokensAndRefresh(subject)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JSAS0030W: Credentials are invalid. Trying unauthenticated login.");
                }
                Tr.error(tc, "security.JSAS0030W");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInvocationSubject");
                }
                return SubjectHelper.createUnauthenticatedSubject();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject is valid.");
            }
            if (wsCred == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No invocation subject during Identity Assertion processing.  Return Unauthenticated subject");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInvocationSubject");
                }
                return SubjectHelper.createUnauthenticatedSubject();
            }
            if (wsCred.isBasicAuth() && !wsCred.isUnauthenticated() && SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The invocation credential is either BasicAuth or GSSUP.  Getting authentiated subject.");
                    }
                    subject = contextMgr.login(wsCred);
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getInvocationCredentials", "169", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Java runtime exception while trying ContextManager.login. Returning unauthenticated subject", new Object[]{e});
                    }
                    subject = SubjectHelper.createUnauthenticatedSubject();
                }
            }
            if (subject == null) {
                subject = SubjectHelper.createUnauthenticatedSubject();
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getInvocationCredentials", "181", this);
            Tr.debug(tc, "Java runtime exception while trying to get Invocation credentials from current.", new Object[]{e});
            subject = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvocationSubject", subject);
        }
        return subject;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Subject getClientSubject(String targetRealm, CSIv2EffectivePerformPolicy effectivePolicy) throws Exception {
        block68: {
            if (CSICredentialsManager.tc.isEntryEnabled()) {
                Tr.entry(CSICredentialsManager.tc, "getClientSubject", new Object[]{targetRealm, effectivePolicy, this});
            }
            subject = null;
            wsCred = null;
            targetHostName = effectivePolicy.getTargetHostName();
            csiUtil = new CSIUtil();
            loginHelper = null;
            contextMgr = ContextManagerFactory.getInstance();
            csiv2 = SecurityObjectLocator.getCSIv2Config();
            if (!SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") && csiv2.getBoolean("com.ibm.CSI.isRealmHostSubjectLookupEnabled") && (subject = VaultImpl.getInstance().getRealmHostSubject(targetRealm + ":" + targetHostName)) != null) {
                if (CSICredentialsManager.tc.isDebugEnabled()) {
                    Tr.debug(CSICredentialsManager.tc, "Returning credential from realm/server Subject cache.");
                }
                if (CSICredentialsManager.tc.isEntryEnabled()) {
                    Tr.exit(CSICredentialsManager.tc, "getClientSubject", subject);
                }
                return subject;
            }
            if (!SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") && csiv2.getBoolean("com.ibm.CSI.isRealmSubjectLookupEnabled") && (subject = VaultImpl.getInstance().getRealmSubject(targetRealm)) != null) {
                if (CSICredentialsManager.tc.isDebugEnabled()) {
                    Tr.debug(CSICredentialsManager.tc, "Returning subject from the realm/subject cache.");
                }
                if (CSICredentialsManager.tc.isEntryEnabled()) {
                    Tr.exit(CSICredentialsManager.tc, "getClientSubject", subject);
                }
                return subject;
            }
            try {
                subject = contextMgr.getInvocationSubject();
                wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "231", new Object[]{this});
                Tr.debug(CSICredentialsManager.tc, "Java runtime exception while trying to get_credentials from current.", new Object[]{e});
            }
            if (wsCred != null && wsCred.isUnauthenticated()) {
                if (CSICredentialsManager.tc.isEntryEnabled()) {
                    Tr.exit(CSICredentialsManager.tc, "getClientSubject", subject);
                }
                return subject;
            }
            if (!SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") && subject == null) {
                subject = VaultImpl.getInstance().get_default_subject();
                wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                if (CSICredentialsManager.tc.isDebugEnabled() && wsCred != null) {
                    Tr.debug(CSICredentialsManager.tc, "Found a default Subject on the client side: " + wsCred.getSecurityName());
                }
            }
            v0 = targetIsKerberos = (_authenticationTarget = Integer.valueOf(SecurityObjectLocator.getCSIv2Config().getInteger("com.ibm.CORBA.authenticationTarget"))) != null && _authenticationTarget == 6;
            if (!(SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") || wsCred != null && ((WSCredentialImpl)wsCred).isForwardable(targetRealm, effectivePolicy, subject))) {
                if (CSICredentialsManager.tc.isDebugEnabled()) {
                    Tr.debug(CSICredentialsManager.tc, "There is no invocation subject on the current thread; Login will be performed for " + targetRealm + "/null");
                }
                if ((loginHelper = new LoginHelperImpl(VaultImpl.getInstance().getORB())) == null) {
                    Tr.error(CSICredentialsManager.tc, "security.JSAS0020E");
                    if (CSICredentialsManager.tc.isEntryEnabled()) {
                        Tr.exit(CSICredentialsManager.tc, "getClientSubject", null);
                    }
                    return null;
                }
                try {
                    retry = false;
                    do {
                        try {
                            wsCredFinal = wsCred;
                            realm = targetRealm;
                            helper = loginHelper;
                            subject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    if (wsCredFinal != null && wsCredFinal.isBasicAuth() && !wsCredFinal.isUnauthenticated() && targetIsKerberos) {
                                        String user = wsCredFinal.getSecurityName();
                                        String pwd = StringBytesConversion.getConvertedString((byte[])wsCredFinal.getCredentialToken());
                                        return helper.request_login_controlled(user, realm, pwd, null, false);
                                    }
                                    return helper.request_login_controlled(null, realm, null, null, false);
                                }
                            });
                            retry = false;
                            wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                        }
                        catch (PrivilegedActionException pae) {
                            if (!csiv2.getBoolean("com.ibm.CORBA.authenticationRetryEnabled")) continue;
                            retry_count = csiUtil.getCurrent().get_retry_count();
                            if (CSICredentialsManager.tc.isDebugEnabled()) {
                                Tr.debug(CSICredentialsManager.tc, "Retry count is " + retry_count);
                            }
                            if (retry_count < csiv2.getInteger("com.ibm.CORBA.authenticationRetryCount")) {
                                if (CSICredentialsManager.tc.isDebugEnabled()) {
                                    Tr.debug(CSICredentialsManager.tc, "LOGGING IN AGAIN!!!  Previous login failed but retry count is not above the maximum retries.");
                                }
                                csiUtil.getCurrent().increment_retry_count();
                                retry = true;
                                continue;
                            }
                            retry = false;
                            Manager.Ffdc.log(pae, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "340", new Object[]{this});
                            Tr.debug(CSICredentialsManager.tc, SecurityMessages.getMsgOrUseDefault("JSAS0240E", "JSAS0240E: Login failed.  Verify the userid/password is correct.  Check the properties file to ensure the login source is valid.  If this error occurs on the server, check the server properties to ensure the principalName has a valid realm and userid."));
                            throw pae.getException();
                        }
                    } while (retry);
                    if (subject == null) ** GOTO lbl93
                    contextMgr.setInvocationSubject(subject);
                }
                catch (WSLoginFailedException e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "354", new Object[]{this});
                    Tr.error(CSICredentialsManager.tc, "security.JSAS0240E", new Object[]{e});
                    subject = null;
                    if (CSICredentialsManager.tc.isDebugEnabled()) {
                        Tr.debug(CSICredentialsManager.tc, "Login Failed reason: " + e.getMessage());
                    }
                    throw e;
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "366", new Object[]{this});
                    Tr.error(CSICredentialsManager.tc, "security.JSAS0240E", new Object[]{e});
                    subject = null;
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
            } else if (wsCred != null && !((WSCredentialImpl)wsCred).isForwardable(targetRealm, effectivePolicy, subject)) {
                if (CSICredentialsManager.tc.isDebugEnabled()) {
                    Tr.debug(CSICredentialsManager.tc, "Credential is not forwardable to the target realm. Force to create Unauthenticated subject. target realm:" + targetRealm);
                }
                wsCred = null;
            }
lbl93:
            // 5 sources

            if (wsCred != null && wsCred.isCurrent() && !wsCred.isForwardable()) {
                block67: {
                    if (CSICredentialsManager.tc.isDebugEnabled()) {
                        Tr.debug(CSICredentialsManager.tc, "Resolved credentials is NOT forwardable. The credentials will be mapped.");
                    }
                    if (wsCred.getOID().equalsIgnoreCase("No OID for this mechanism")) {
                        if (CSICredentialsManager.tc.isDebugEnabled()) {
                            Tr.debug(CSICredentialsManager.tc, "LocalOS credentials is not forwardable.");
                        }
                        try {
                            security_name = wsCred.getRealmSecurityName();
                            if (security_name != null && security_name.length() > 0) {
                                subject = VaultImpl.getInstance().getBasicAuthSubject(security_name);
                                if (subject != null) {
                                    if (CSICredentialsManager.tc.isDebugEnabled()) {
                                        Tr.debug(CSICredentialsManager.tc, "Returned BasicAuth subject.  Security_name: " + security_name);
                                    }
                                    if (CSICredentialsManager.tc.isEntryEnabled()) {
                                        Tr.exit(CSICredentialsManager.tc, "getClientSubject", subject);
                                    }
                                    return subject;
                                }
                                if (subject == null) {
                                    if (CSICredentialsManager.tc.isDebugEnabled()) {
                                        Tr.debug(CSICredentialsManager.tc, "No matched BasicAuth subject for this LocalOS subject.  Return Unauthenticated subject.");
                                    }
                                    if (CSICredentialsManager.tc.isEntryEnabled()) {
                                        Tr.exit(CSICredentialsManager.tc, "getClientSubject");
                                    }
                                    return SubjectHelper.createUnauthenticatedSubject();
                                }
                                break block67;
                            }
                            if (CSICredentialsManager.tc.isDebugEnabled()) {
                                Tr.debug(CSICredentialsManager.tc, "No security name found.  Return unauthenticated subject.");
                            }
                            if (CSICredentialsManager.tc.isEntryEnabled()) {
                                Tr.exit(CSICredentialsManager.tc, "getClientSubject");
                            }
                            return SubjectHelper.createUnauthenticatedSubject();
                        }
                        catch (Exception e) {
                            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientSubject", "438", new Object[]{this});
                            if (CSICredentialsManager.tc.isDebugEnabled()) {
                                Tr.debug(CSICredentialsManager.tc, SecurityMessages.getMsgOrUseDefault("TrcMsg405", "Unable to get client security name from credentials."));
                            }
                            Tr.debug(CSICredentialsManager.tc, e.getMessage(), e);
                        }
                    }
                }
                try {
                    if (!contextMgr.isServerCred(wsCred)) break block68;
                    if (CSICredentialsManager.tc.isDebugEnabled()) {
                        Tr.debug(CSICredentialsManager.tc, "Server invokes downstream request to different target realm: " + targetRealm);
                    }
                    if (CSICredentialsManager.tc.isDebugEnabled()) {
                        Tr.debug(CSICredentialsManager.tc, "Using key file to map server credential for new target realm.");
                    }
                    try {
                        if (csiv2.getString("com.ibm.CORBA.keyFileName") != null && csiv2.getString("com.ibm.CORBA.keyFileName").length() > 0) {
                            _keyFile = loginHelper.getKeyFileObject();
                            keyFileEntry = _keyFile.find(targetRealm, wsCred.getRealmSecurityName());
                            if (keyFileEntry != null) {
                                security_name = keyFileEntry.getUserid();
                                password = keyFileEntry.getPassword();
                                subject = SubjectHelper.createBasicAuthSubject(targetRealm, security_name, password);
                                wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                            } else {
                                Tr.error(CSICredentialsManager.tc, "security.JSAS0480E");
                                subject = SubjectHelper.createUnauthenticatedSubject();
                                wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                            }
                            break block68;
                        }
                        Tr.error(CSICredentialsManager.tc, "security.JSAS0480E");
                        subject = SubjectHelper.createUnauthenticatedSubject();
                        wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                    }
                    catch (Exception ex) {
                        Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "505", new Object[]{this});
                        Tr.error(CSICredentialsManager.tc, "security.JSAS0480E", new Object[]{ex});
                        subject = SubjectHelper.createUnauthenticatedSubject();
                        wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                    }
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager.getClientCredentials", "515", new Object[]{this});
                    if (CSICredentialsManager.tc.isDebugEnabled()) {
                        Tr.debug(CSICredentialsManager.tc, "Java runtime exception while trying to get_mapped_credentials.", new Object[]{e});
                    }
                    subject = SubjectHelper.createUnauthenticatedSubject();
                    wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                }
            }
        }
        if (subject != null && SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") && !contextMgr.getWSCredTokenMapper().checkValidityOfAllTokensAndRefresh(subject)) {
            if (CSICredentialsManager.tc.isDebugEnabled()) {
                Tr.debug(CSICredentialsManager.tc, "JSAS0030W: Credentials are invalid. Trying unauthenticated login.");
            }
            Tr.error(CSICredentialsManager.tc, "security.JSAS0030W");
            subject = SubjectHelper.createUnauthenticatedSubject();
        } else if (CSICredentialsManager.tc.isDebugEnabled()) {
            Tr.debug(CSICredentialsManager.tc, "Subject is valid.");
        }
        if (wsCred == null) {
            if (CSICredentialsManager.tc.isDebugEnabled()) {
                Tr.debug(CSICredentialsManager.tc, "Credentials are null or invalidated by rejection.");
            }
            subject = SubjectHelper.createUnauthenticatedSubject();
        }
        if (!SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") && csiv2.getBoolean("com.ibm.CSI.isRealmHostSubjectLookupEnabled") && subject != null) {
            if (CSICredentialsManager.tc.isDebugEnabled()) {
                Tr.debug(CSICredentialsManager.tc, "Adding credential to realm/server Subject cache.");
            }
            VaultImpl.getInstance().addRealmHostSubject(targetRealm + ":" + targetHostName, subject);
        }
        if (!SecurityObjectLocator.getAdminData().getBoolean("isServerProcess") && csiv2.getBoolean("com.ibm.CSI.isRealmSubjectLookupEnabled") && subject != null) {
            if (CSICredentialsManager.tc.isDebugEnabled()) {
                Tr.debug(CSICredentialsManager.tc, "caching realm and the basic auth subject");
            }
            VaultImpl.getInstance().addRealmSubject(targetRealm, subject);
        }
        if (CSICredentialsManager.tc.isEntryEnabled()) {
            Tr.exit(CSICredentialsManager.tc, "getClientSubject", subject);
        }
        return subject;
    }
}

