/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityL13SupportImpl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class SecurityLogger {
    private static ORB orb = null;
    private static String serverID;
    private static String serverName;
    private static String filterString;
    private static TraceComponent tc;
    public static boolean debugTraceEnabled;
    public static boolean debugEntryEnabled;
    public static boolean traceByteArrays;
    public static boolean traceEnabled;
    private static StringBuffer msgBuffer;
    private static final long Security = 0x4000000L;
    private static final long Normal = 1L;
    private static final long Harmless = 2L;
    private static final long Warning = 4L;
    private static final long Minor = 8L;
    private static final long Critical = 16L;
    private static final long Fatal = 32L;
    private static final long FatalException = 4L;
    private static final long CriticalException = 8L;
    private static final long OtherException = 16L;

    public SecurityLogger(ORB orb) {
        serverID = new Integer(orb.getServerId()).toString();
        serverName = orb.getProperty("com.ibm.CORBA.ServerName");
        if (serverName != null && !serverName.equals("")) {
            serverID = serverName;
        }
        SecurityLogger.orb = orb;
        filterString = orb.getProperty("com.ibm.CORBA.securityTraceFilter");
        if (filterString == null) {
            filterString = "";
        }
    }

    public static synchronized boolean debugMessage(String classMethodName, byte[] byteArray) {
        StringBuffer arrayBuffer = new StringBuffer(500);
        if (tc.isDebugEnabled() && SecurityLogger.filter(classMethodName)) {
            String[] stringArray = SecurityLogger.toHexAsciiFormat(byteArray);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayBuffer.append(stringArray[i]).append(System.getProperty("line.separator")).append("        ");
            }
            SecurityLogger.debug(classMethodName, arrayBuffer.toString());
        }
        return true;
    }

    public static synchronized boolean debugMessage(String classMethodName, String traceText) {
        if (tc.isDebugEnabled() && SecurityLogger.filter(classMethodName)) {
            SecurityLogger.debug(classMethodName, traceText);
        }
        if (debugTraceEnabled != tc.isDebugEnabled()) {
            SecurityLogger.reInitGuards();
        }
        return true;
    }

    public static synchronized void debugEntry(String classMethodName) {
        if (tc.isEntryEnabled() && SecurityLogger.filter(classMethodName)) {
            SecurityLogger.entry(classMethodName);
        }
    }

    public static synchronized void debugEntry(String classMethodName, Object[] params) {
        if (tc.isEntryEnabled() && SecurityLogger.filter(classMethodName)) {
            SecurityLogger.entry(classMethodName, params);
        }
    }

    public static synchronized void debugExit(String classMethodName) {
        if (tc.isEntryEnabled() && SecurityLogger.filter(classMethodName)) {
            SecurityLogger.exit(classMethodName);
        }
    }

    public static synchronized boolean logActivity(String classMethodName, int severity, String msg) {
        if (tc.isDebugEnabled() && SecurityLogger.filter(classMethodName)) {
            SecurityLogger.audit(classMethodName, msg);
        }
        return true;
    }

    public static synchronized void logError(String classMethodName, String key) {
        Tr.error(tc, key);
    }

    public static synchronized void logError(String key, Object[] params) {
        Tr.error(tc, key, params);
    }

    public static synchronized void logWarning(String key, Object[] params) {
        Tr.warning(tc, key, params);
    }

    public static synchronized void logWarning(String classMethodName, String msg) {
        Tr.warning(tc, "security.JSAS0000E", new Object[]{msg, System.getProperty("line.separator")});
    }

    public static synchronized void logAudit(String classMethodName, String key) {
        Tr.audit(tc, key);
    }

    public static synchronized boolean logError(String classMethodName, String msg, int errorCode) {
        Tr.error(tc, "security.JSAS0000E", new Object[]{msg, System.getProperty("line.separator")});
        return true;
    }

    public static synchronized boolean logException(String classMethodName, Exception ex, int severity, int errorCode) {
        SecurityLogger.exception(classMethodName, ex);
        return true;
    }

    public static synchronized boolean traceException(String classMethodName, Exception ex, int severityCode, int errorCode) {
        SecurityLogger.exception(classMethodName, ex);
        return true;
    }

    public static synchronized boolean traceException(String classMethodName, Throwable t, int severityCode, int errorCode) {
        SecurityLogger.exception(classMethodName, t);
        return true;
    }

    public static synchronized boolean traceMessage(String classMethodName, String traceText) {
        if (tc.isDebugEnabled() && SecurityLogger.filter(classMethodName)) {
            SecurityLogger.debug(classMethodName, traceText);
        }
        return true;
    }

    private static void debug(String classMethodName, String msg) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(classMethodName).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator")).append("        ").append(msg).append(System.getProperty("line.separator"));
        Tr.debug(tc, msgBuffer.toString());
    }

    private static void entry(String classMethodName) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(classMethodName).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator"));
        Tr.entry(tc, msgBuffer.toString());
    }

    private static void entry(String classMethodName, Object[] params) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(classMethodName).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator"));
        Tr.entry(tc, msgBuffer.toString(), params);
    }

    private static void exit(String classMethodName) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(classMethodName).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator"));
        Tr.exit(tc, msgBuffer.toString());
    }

    private static void exception(String classMethodName, Throwable t) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(classMethodName).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator"));
        Tr.debug(tc, msgBuffer.toString(), t);
    }

    private static void audit(String classMethodName, String msg) {
        msgBuffer.delete(0, msgBuffer.length());
        msgBuffer.append("[").append(classMethodName).append("], [ServerID: ").append(serverID).append("]").append(System.getProperty("line.separator")).append("        ").append(msg).append(System.getProperty("line.separator"));
        Tr.debug(tc, msgBuffer.toString());
    }

    private static String clean(String inString) {
        if (inString == null) {
            return null;
        }
        String outString = inString.trim();
        if (outString.startsWith("\"") && outString.endsWith("\"") || outString.startsWith("'") && outString.endsWith("'")) {
            outString = outString.substring(1, outString.length() - 1);
        }
        return outString;
    }

    public static String[] toHexAsciiFormat(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        int outputArraySize = (byteArray.length - 1) / 16 + 1;
        String[] outputArray = new String[outputArraySize];
        String paddedHex = null;
        String outputLine = null;
        for (int i = 0; i < outputArraySize; ++i) {
            int j;
            paddedHex = new String("0000" + Integer.toHexString(i * 16));
            outputLine = paddedHex.substring(paddedHex.length() - 4) + ": ";
            for (j = 0; j < 16; ++j) {
                if (i * 16 + j < byteArray.length) {
                    paddedHex = new String("00" + Integer.toHexString(byteArray[i * 16 + j]));
                    outputLine = outputLine + paddedHex.substring(paddedHex.length() - 2) + " ";
                    continue;
                }
                outputLine = outputLine + "   ";
            }
            outputLine = outputLine + "  [";
            for (j = 0; j < 16; ++j) {
                if (i * 16 + j < byteArray.length) {
                    if (Character.isISOControl((char)byteArray[i * 16 + j])) {
                        outputLine = outputLine + ".";
                        continue;
                    }
                    outputLine = outputLine + (char)byteArray[i * 16 + j];
                    continue;
                }
                outputLine = outputLine + " ";
            }
            outputArray[i] = outputLine = outputLine + "]";
        }
        return outputArray;
    }

    private static String getMethodName(String classMethodName) {
        int realmDelimiterIndex = classMethodName.lastIndexOf(".");
        return classMethodName.substring(realmDelimiterIndex + 1);
    }

    private static boolean filter(String classMethodName) {
        if (filterString.equals("")) {
            return true;
        }
        if (classMethodName != null) {
            int realmDelimiterIndex = classMethodName.lastIndexOf(".");
            String className = classMethodName.substring(0, realmDelimiterIndex);
            return className != null && filterString.indexOf(className) != -1;
        }
        return false;
    }

    private static void reInitGuards() {
        debugTraceEnabled = tc.isDebugEnabled();
        debugEntryEnabled = tc.isEntryEnabled();
        traceByteArrays = tc.isDebugEnabled();
        traceEnabled = tc.isDebugEnabled();
    }

    static {
        filterString = "";
        tc = Tr.register("SASRas", "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
        debugTraceEnabled = tc.isDebugEnabled();
        debugEntryEnabled = tc.isEntryEnabled();
        traceByteArrays = tc.isDebugEnabled();
        traceEnabled = tc.isDebugEnabled();
        msgBuffer = new StringBuffer(500);
    }
}

