/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.services.redirector;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.services.redirector.Redirector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;

public class RedirectorController {
    protected Hashtable connections = new Hashtable();
    private static final String thisClassName = RedirectorController.class.getName();
    private long timeStamp;
    private int maxOpenSockets;
    private int requestTimeoutMillis = 0;
    private long staleSocketThreshold = 300L;
    private static final long connectionTableCleanupIntervalMins = 5L;
    private static final long connectionTableCleanupIntervalMillis = 300000L;
    private boolean cleanupInProgress = false;
    private long timeLastCleaned = 0L;
    private Random rand = null;

    public RedirectorController() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "RedirectorController()");
        }
        this.timeStamp = System.currentTimeMillis();
        this.rand = new Random(this.timeStamp);
        this.timeLastCleaned = this.timeStamp;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "RedirectorController()");
        }
    }

    public synchronized Redirector getRedirector(String host, int port) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "getRedirector (" + host + "," + port + ")");
        }
        Redirector redirector = null;
        for (long i = 0L; i < (long)this.maxOpenSockets && redirector == null; ++i) {
            redirector = (Redirector)this.connections.get(Redirector.buildID(host, port, i));
            if (redirector == null) {
                redirector = new Redirector(host, port, i, this);
                this.connections.put(Redirector.buildID(host, port, i), redirector);
                continue;
            }
            if (!redirector.busy) continue;
            redirector = null;
        }
        if (redirector == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getRedirector", "All connections are in use for " + host + ":" + port + ".  Opening a new temporary connection.");
            }
            this.timeStamp = System.currentTimeMillis();
            String id = Redirector.buildID(host, port, this.timeStamp);
            while (this.connections.get(id) != null) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getRedirector", "timeStamp " + this.timeStamp + " is in use for " + host + ":" + port + ".  Regenerating.");
                }
                this.timeStamp = this.timeStamp / (long)this.rand.nextInt() + (long)this.rand.nextInt();
                if (this.timeStamp < 0L) {
                    this.timeStamp *= -1L;
                }
                id = Redirector.buildID(host, port, this.timeStamp);
            }
            redirector = new Redirector(host, port, this.timeStamp, this);
            this.connections.put(id, redirector);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "getRedirector(), returning " + redirector.getID());
        }
        return redirector;
    }

    public synchronized Redirector getRedirector(String id) {
        Redirector redirector = (Redirector)this.connections.get(id);
        return redirector;
    }

    public synchronized void addRedirector(String id, Redirector redirector) {
        this.connections.put(id, redirector);
    }

    public synchronized void removeRedirector(String id) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "removeRedirector(" + id + ")");
        }
        Redirector redirector = (Redirector)this.connections.remove(id);
        redirector.terminateServerConnection();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "removeRedirector()");
        }
    }

    public synchronized void cleanupConnectionTable() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "cleanupConnectionTable()");
        }
        Redirector redirector = null;
        Enumeration connTable = this.connections.elements();
        boolean removeConnection = false;
        while (connTable.hasMoreElements()) {
            redirector = (Redirector)connTable.nextElement();
            if (redirector.busy) continue;
            try {
                removeConnection = redirector.cleanupStaleConnection();
                if (!removeConnection) continue;
                this.connections.remove(redirector.getID());
            }
            catch (Exception e) {}
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "cleanupConnectionTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConnectionTable() {
        if (this.cleanupInProgress) {
            return;
        }
        long currTime = this.checkDeltaTime(this.timeLastCleaned, 300000L);
        if (currTime > 0L) {
            RedirectorController redirectorController = this;
            synchronized (redirectorController) {
                this.cleanupInProgress = true;
                if (currTime < this.timeLastCleaned) {
                    this.cleanupInProgress = false;
                    return;
                }
                this.timeLastCleaned = System.currentTimeMillis();
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "checkConnectionTable", "More than 5 minutes has elapsed since the last HTTP Tunnel connection table cleanup.  Cleanup starting...");
                }
                try {
                    this.cleanupConnectionTable();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.cleanupInProgress = false;
            }
        }
    }

    public void setMaxOpenSockets(int value) {
        this.maxOpenSockets = value;
    }

    public int maxOpenSockets() {
        return this.maxOpenSockets;
    }

    public void setRequestTimeout(int value) {
        this.requestTimeoutMillis = value;
    }

    public int getRequestTimeout() {
        return this.requestTimeoutMillis;
    }

    public long getStaleSocketThreshold() {
        return this.staleSocketThreshold;
    }

    public long checkDeltaTime(long firstTime, long thresholdTime) {
        long currTime = System.currentTimeMillis();
        if (currTime - firstTime >= thresholdTime) {
            return currTime;
        }
        return 0L;
    }
}

