/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.xcommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class XXCommand
extends Command {
    public XXCommand(Output o) {
        super(o, "x", "displays the hex value of the bytes at the specified address", "parameters: 0x<addr>\n\nDisplays the hex value of the bytes at the specified address, adjusted for the endianness of the architecture this dump file is from.\n\nNote: This command uses the number of items and unit size passed to it by the \"x/\" command.\n");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        int numUnits = (Integer)args.pop();
        int unitSize = (Integer)args.pop();
        if (args.isEmpty()) {
            this.out.error("\"x/x\" command takes exactly one parameter");
            return;
        }
        String param = (String)args.pop();
        if (!args.isEmpty()) {
            this.out.error("\"x/x\" only takes one parameter");
            return;
        }
        Long address = Utils.longFromStringWithPrefix(param);
        if (null == address) {
            this.out.error("invalid hex address specify; address must be specified as \"0x<hex_address>\"");
            return;
        }
        this.out.print("\n");
        for (int index = 0; index < numUnits; ++index) {
            boolean found = false;
            Iterator itImageAddressSpace = loadedImage.getAddressSpaces();
            long currAddr = address + (long)(index * unitSize);
            this.out.print("\t");
            this.out.print(Utils.toHex(currAddr));
            this.out.print(": ");
            while (itImageAddressSpace.hasNext() && !found) {
                ImageAddressSpace ias = (ImageAddressSpace)itImageAddressSpace.next();
                ImagePointer ip = ias.getPointer(currAddr);
                byte b = 0;
                short s = 0;
                int i = 0;
                long l = 0L;
                try {
                    switch (unitSize) {
                        case 1: {
                            b = ip.getByteAt(0L);
                            break;
                        }
                        case 2: {
                            s = ip.getShortAt(0L);
                            break;
                        }
                        case 4: {
                            i = ip.getIntAt(0L);
                            break;
                        }
                        case 8: {
                            l = ip.getLongAt(0L);
                        }
                    }
                    found = true;
                }
                catch (CorruptDataException e) {
                    found = false;
                }
                catch (MemoryAccessException e) {
                    found = false;
                }
                if (!found) continue;
                switch (unitSize) {
                    case 1: {
                        this.out.print(Utils.toFixedWidthHex(b));
                        break;
                    }
                    case 2: {
                        this.out.print(Utils.toFixedWidthHex(s));
                        break;
                    }
                    case 4: {
                        this.out.print(Utils.toFixedWidthHex(i));
                        break;
                    }
                    case 8: {
                        this.out.print(Utils.toFixedWidthHex(l));
                    }
                }
            }
            if (!found) {
                this.out.print("<address not found in any address space>");
            }
            this.out.print("\n");
        }
        this.out.print("\n");
    }
}

