/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.xcommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.runtime.ManagedRuntime;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.ClassOutput;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class XJCommand
extends Command {
    public XJCommand(Output o) {
        super(o, "j", "displays information about a particular object or all objects of a class", "parameters: 0x<object_addr>, <class_name>\n\nIf given class name, all static fields with their values will be printed, followed by all objects of that class with their fields and values.\n\nIf given an object address (in hex), static fields for that object's class will not be printed; the other fields and values of that object will be printed along with its address.\n\nNote: this command ignores the number of items and unit size passed to it by the \"x/\" command.\n");
        this.child_commands = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        String objName;
        args.pop();
        args.pop();
        boolean supers = false;
        if (args.isEmpty()) {
            this.out.error("\"x/j\" command requires one or two parameters");
            return;
        }
        String param = (String)args.pop();
        Long objAddress = Utils.longFromStringWithPrefix(param);
        if (null == objAddress) {
            objName = param;
            if (!args.isEmpty()) {
                String option = (String)args.pop();
                if (option.equals("super")) {
                    supers = true;
                } else {
                    if (!option.equals("nosuper")) {
                        this.out.error("second parameter for \"x/j\" must be \"super\" or \"nosuper\"");
                        return;
                    }
                    supers = false;
                }
            }
        } else {
            objName = null;
        }
        if (!args.isEmpty()) {
            this.out.error("\"x/j\" takes at most one parameter if address is specified or two parameters if class name is specified");
            return;
        }
        this.printRuntimeObjects(loadedImage, objAddress, objName, this.out, supers);
    }

    private void printRuntimeObjects(Image loadedImage, Long objAddress, String objName, Output out, boolean supers) {
        Iterator itRuntime = Utils.getRuntimes(loadedImage);
        int count = 1;
        out.print("\n");
        while (itRuntime.hasNext()) {
            ManagedRuntime mr = (ManagedRuntime)itRuntime.next();
            if (mr instanceof JavaRuntime) {
                out.print("\truntime #" + count + " - version: ");
                try {
                    out.print(mr.getVersion());
                }
                catch (CorruptDataException e) {
                    out.print(Exceptions.getCorruptDataExceptionString());
                }
                out.print("\n");
                this.printHeapObjects((JavaRuntime)mr, objAddress, objName, out, supers);
            }
            ++count;
        }
    }

    private void printHeapObjects(JavaRuntime jr, Long objAddress, String objName, Output out, boolean supers) {
        Iterator itHeap = jr.getHeaps();
        int count = 1;
        while (itHeap.hasNext()) {
            JavaHeap jh = (JavaHeap)itHeap.next();
            out.print("\t heap #" + count + " - name: ");
            out.print(jh.getName());
            out.print("\n\n");
            this.printObjects(jh, objAddress, objName, out, supers, jr);
            ++count;
        }
    }

    private void printObjects(JavaHeap jh, Long objAddress, String objName, Output out, boolean supers, JavaRuntime jr) {
        Iterator itObject = jh.getObjects();
        boolean found = false;
        if (objName != null) {
            JavaClass objClass = Utils.getClassGivenName(objName, jr, out);
            if (null == objClass) {
                out.print("\t  could not find class with name \"" + objName + "\"\n\n");
                return;
            }
            ClassOutput.printStaticFields(objClass, out);
            while (itObject.hasNext()) {
                JavaClass jc;
                JavaObject jo = (JavaObject)itObject.next();
                String hierarchy = "";
                try {
                    jc = jo.getJavaClass();
                }
                catch (CorruptDataException e) {
                    out.print("\t  <error getting class while traversing objects: ");
                    out.print(Exceptions.getCorruptDataExceptionString());
                    out.print(">\n");
                    jc = null;
                }
                boolean foundSuperclass = false;
                while (jc != null && !foundSuperclass) {
                    String className;
                    try {
                        className = jc.getName();
                    }
                    catch (CorruptDataException e) {
                        out.print("\t  <error getting class name while traversing objects: ");
                        out.print(Exceptions.getCorruptDataExceptionString());
                        out.print(">\n");
                        jc = null;
                        continue;
                    }
                    hierarchy = hierarchy.equals("") ? className : className + " => " + hierarchy;
                    if (className.equals(objName)) {
                        found = true;
                        foundSuperclass = true;
                        out.print("\t  ");
                        out.print(hierarchy);
                        out.print(" @ ");
                        out.print(Utils.toHex(jo.getID().getAddress()));
                        out.print("\n");
                        ClassOutput.printFields(jo, jc, jr, out);
                        continue;
                    }
                    if (supers) {
                        try {
                            jc = jc.getSuperclass();
                        }
                        catch (CorruptDataException e) {
                            out.print("\t  <error getting superclass while traversing objects: ");
                            out.print(Exceptions.getCorruptDataExceptionString());
                            out.print(">\n");
                            jc = null;
                        }
                        continue;
                    }
                    jc = null;
                }
            }
        } else {
            boolean done = false;
            while (itObject.hasNext() && !done) {
                JavaClass jc;
                JavaObject jo = (JavaObject)itObject.next();
                if (jo.getID().getAddress() != objAddress.longValue()) continue;
                found = true;
                out.print("\t  ");
                try {
                    jc = jo.getJavaClass();
                }
                catch (CorruptDataException e) {
                    out.print("\t  <error getting class while traversing objects: ");
                    out.print(Exceptions.getCorruptDataExceptionString());
                    out.print(">");
                    jc = null;
                }
                if (null == jc) continue;
                try {
                    out.print(jc.getName());
                }
                catch (CorruptDataException e) {
                    out.print("\t  <error getting class name while traversing objects: ");
                    out.print(Exceptions.getCorruptDataExceptionString());
                    out.print(">");
                }
                out.print(" @ ");
                out.print(Utils.toHex(objAddress));
                out.print("\n");
                ClassOutput.printFields(jo, jc, jr, out);
                done = true;
            }
        }
        if (!found) {
            if (objName != null) {
                out.print("\t  <no object of class \"");
                out.print(objName);
                out.print("\" exists>\n\n");
            } else {
                out.print("\t  <no object found at address ");
                out.print(Utils.toHex(objAddress));
                out.print(">\n\n");
            }
        }
    }
}

