/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.showcommands;

import com.ibm.dtfj.image.Image;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import java.util.HashMap;
import java.util.Stack;

public class ShowLoggingCommand
extends Command {
    public ShowLoggingCommand(Output o) {
        super(o, "logging", "displays the current values of logging settings", "parameters: none\n\noutputs following values, which are generally set by the \"set logging\" command:\n set_logging = [on|off]\n set_logging_file = <filename>\n set_logging_overwrite = [on|off]\n set_logging_redirect = [on|off]\n current_logging_file = <filename> - file that is currently being logged to; could be different than set_logging_file if that value was changed after logging was started");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        if (!args.isEmpty()) {
            this.out.error("\"show logging\" does not take any parameters");
            return;
        }
        String fileVal = (String)properties.get("set_logging_file");
        fileVal = null == fileVal ? "<not set>" : "\"" + fileVal + "\"";
        String currentFileVal = (String)properties.get("current_logging_file");
        currentFileVal = null == currentFileVal ? "<not currently logging>" : "\"" + currentFileVal + "\"";
        this.out.print("\n");
        this.printKeyVal(properties, "set_logging");
        this.out.println("\tset_logging_file = " + fileVal);
        this.printKeyVal(properties, "set_logging_overwrite");
        this.printKeyVal(properties, "set_logging_redirect");
        this.out.print("\n");
        this.out.println("\tcurrent_logging_file = " + currentFileVal);
        this.out.print("\n");
    }

    private void printKeyVal(HashMap properties, String key) {
        this.out.println("\t" + key + " = " + this.getVal(properties, key));
    }

    private String getVal(HashMap properties, String key) {
        String val = (String)properties.get(key);
        if (null == val) {
            return "off";
        }
        return val;
    }
}

