/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;

public class InfoProcCommand
extends Command {
    public InfoProcCommand(Output o) {
        super(o, "proc", "displays threads, command line arguments, environment variables, and shared modules of current process", "parameters: none\n\nprints the following information about the current process\n\n  - thread IDs for all its threads\n  - the command line arguments it's using\n  - its environment variables\n\nnote: to view the shared modules used by a process, use the \"info sym\" command\n");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        if (!args.isEmpty()) {
            this.out.error("\"info proc\" does not take any parameters");
            return;
        }
        this.out.print("\n");
        this.printAddressSpaceInfo(loadedImage, this.out);
        this.out.print("\n");
    }

    private void printAddressSpaceInfo(Image loadedImage, Output out) {
        int asnum = 0;
        Iterator itAddressSpace = loadedImage.getAddressSpaces();
        while (itAddressSpace.hasNext()) {
            ImageAddressSpace ias = (ImageAddressSpace)itAddressSpace.next();
            out.print("\taddress space # " + asnum + "\n");
            ImageProcess ip = ias.getCurrentProcess();
            if (ip == null) {
                out.print("\t(No current process in this address space)\n");
            } else {
                this.printProcessInfo(ip, out);
            }
            ++asnum;
        }
    }

    private void printProcessInfo(ImageProcess ip, Output out) {
        out.print("\n");
        this.printThreads(ip, out);
        out.print("\n");
        this.printCommandLine(ip, out);
        out.print("\n");
        this.printEnvironmentVariables(ip, out);
        out.print("\n");
    }

    private void printThreads(ImageProcess ip, Output out) {
        out.print("\t Native thread IDs for current process:");
        out.print("\n\t  ");
        int lineLength = 10;
        Iterator itThread = ip.getThreads();
        while (itThread.hasNext()) {
            Object next = itThread.next();
            if (next instanceof CorruptData) continue;
            ImageThread it = (ImageThread)next;
            try {
                String threadID = it.getID();
                if (threadID == null) continue;
                if (lineLength + threadID.length() > 80) {
                    out.print("\n\t  ");
                    lineLength = 10;
                }
                out.print(it.getID() + " ");
                lineLength += threadID.length() + 1;
            }
            catch (CorruptDataException e) {
                out.print(Exceptions.getCorruptDataExceptionString());
            }
        }
        out.print("\n");
    }

    private void printCommandLine(ImageProcess ip, Output out) {
        out.print("\t Command line arguments used for current process:");
        out.print("\n");
        out.print("\t  ");
        try {
            String commandLine = ip.getCommandLine();
            if (null == commandLine) {
                out.print("<null>");
            } else {
                out.print(commandLine);
            }
        }
        catch (CorruptDataException e) {
            out.print(Exceptions.getCorruptDataExceptionString());
        }
        catch (DataUnavailable e) {
            out.print(Exceptions.getDataUnavailableString());
        }
        out.print("\n");
    }

    private void printEnvironmentVariables(ImageProcess ip, Output out) {
        Properties variables;
        out.print("\t Environment variables for current process:");
        out.print("\n");
        try {
            variables = ip.getEnvironment();
        }
        catch (CorruptDataException e) {
            out.print("\t  " + Exceptions.getCorruptDataExceptionString() + "\n");
            return;
        }
        catch (DataUnavailable e) {
            out.print("\t  " + Exceptions.getDataUnavailableString() + "\n");
            return;
        }
        Enumeration<?> keys = variables.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.printVariableInfo(key, variables.getProperty(key), out);
        }
    }

    private void printVariableInfo(String key, String value, Output out) {
        out.print("\t  " + key + "=" + value + "\n");
    }
}

