/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class InfoMmapCommand
extends Command {
    public InfoMmapCommand(Output o) {
        super(o, "mmap", "outputs a list of all memory segments in the address space", "parameters: none\n\noutputs a list all memory segments (ImageSections) in the address space: start address and size");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        Iterator imageSections = Utils.getAddressSapceSectionInfo(loadedImage);
        while (imageSections.hasNext()) {
            ImageSection imageSection = (ImageSection)imageSections.next();
            long startAddress = imageSection.getBaseAddress().getAddress();
            long size = imageSection.getSize();
            this.out.println("Address: 0x" + Long.toHexString(startAddress) + "   size: 0x" + Long.toHexString(size) + " (" + size + ")");
        }
    }
}

