/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class InfoLsCommand
extends Command {
    public InfoLsCommand(Output o) {
        super(o, "ls", "outputs a list of available monitors and locked objects", "parameters: none\n\nThe info ls command outputs a list of available monitors and locked objects.");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        Vector<JavaMonitor> vMonitorsWithLockedObjects = new Vector<JavaMonitor>();
        Iterator runtimes = Utils.getRuntimes(loadedImage);
        while (runtimes.hasNext()) {
            JavaRuntime jRuntime = (JavaRuntime)runtimes.next();
            Iterator monitors = jRuntime.getMonitors();
            while (monitors.hasNext()) {
                JavaMonitor jMonitor = (JavaMonitor)monitors.next();
                JavaObject jObject = jMonitor.getObject();
                try {
                    String monitorName = jMonitor.getName().trim();
                    if (monitorName.equalsIgnoreCase("")) {
                        this.out.println("Un-named Monitor");
                    } else {
                        this.out.println(jMonitor.getName());
                    }
                    if (null != jObject) {
                        vMonitorsWithLockedObjects.add(jMonitor);
                        String objID = Long.toHexString(jObject.getID().getAddress());
                        JavaThread owner = jMonitor.getOwner();
                        if (null == owner) {
                            this.out.println("\towner thread's id = <unowned>");
                        } else {
                            try {
                                this.out.println("\towner thread's id = " + owner.getImageThread().getID());
                            }
                            catch (DataUnavailable e) {
                                this.out.println("\towner thread's id = " + Exceptions.getDataUnavailableString());
                            }
                        }
                        this.out.println("\tobject = 0x" + objID);
                    } else {
                        this.out.println("Raw monitor: id = <unavailable>");
                    }
                    this.out.print("\n");
                }
                catch (CorruptDataException cde) {}
            }
        }
        this.out.println("Locked objects...");
        if (0 == vMonitorsWithLockedObjects.size()) {
            this.out.println("\t...None.");
            return;
        }
        for (JavaMonitor jMonitor : vMonitorsWithLockedObjects) {
            JavaObject jObject = jMonitor.getObject();
            try {
                JavaThread owner = jMonitor.getOwner();
                String className = "<unknown class>";
                JavaClass jClass = jObject.getJavaClass();
                if (null != jClass) {
                    className = jClass.getName();
                }
                String jObjectID = Long.toHexString(jObject.getID().getAddress());
                if (null == owner) {
                    this.out.println("\t" + className + "@0x" + jObjectID + " is locked by " + "an unknown thread");
                    continue;
                }
                String owningThreadID = null;
                try {
                    owningThreadID = owner.getImageThread().getID();
                }
                catch (DataUnavailable e) {
                    owningThreadID = Exceptions.getDataUnavailableString();
                }
                this.out.println("\t" + className + "@0x" + jObjectID + " is locked by a thread with id " + owningThreadID);
            }
            catch (CorruptDataException cde) {}
        }
    }
}

