/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.Image;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.xcommands.XDCommand;
import com.ibm.jvm.dtfjview.commands.xcommands.XJCommand;
import com.ibm.jvm.dtfjview.commands.xcommands.XKCommand;
import com.ibm.jvm.dtfjview.commands.xcommands.XXCommand;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;

public class XCommand
extends Command {
    public XCommand(Output o) {
        super(o, "x/", "works like \"x/\" in gdb (including use of defaults): passes number of items to display and unit size ('b' for byte, 'h' for halfword, 'w' for word, 'g' for giant word) to sub-command (ie. x/12bd)", "");
        this.child_commands = new Vector();
        this.child_commands.add(new XJCommand(o));
        this.child_commands.add(new XDCommand(o));
        this.child_commands.add(new XXCommand(o));
        this.child_commands.add(new XKCommand(o));
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        Character displayFormat;
        Character unitSize;
        int n;
        if (args.isEmpty()) {
            this.out.error("\"x/\" command requires additional parameters");
            return;
        }
        String arg = (String)args.pop();
        if (null == arg || arg.equals("")) {
            n = 1;
            unitSize = this.getDefaultUnitSize(properties);
            displayFormat = this.getDefaultDisplayFormat(properties);
        } else {
            char currChar;
            int i;
            n = 0;
            for (i = 0; i < arg.length() && Character.isDigit(arg.charAt(i)); ++i) {
                n *= 10;
                n += Character.getNumericValue(arg.charAt(i));
            }
            if (0 == n) {
                n = 1;
            }
            displayFormat = null;
            unitSize = null;
            if (i < arg.length()) {
                currChar = arg.charAt(i);
                switch (currChar) {
                    case 'b': 
                    case 'g': 
                    case 'h': 
                    case 'w': {
                        unitSize = new Character(currChar);
                        break;
                    }
                    default: {
                        displayFormat = new Character(currChar);
                    }
                }
                ++i;
            }
            if (i < arg.length()) {
                currChar = arg.charAt(i);
                switch (currChar) {
                    case 'b': 
                    case 'g': 
                    case 'h': 
                    case 'w': {
                        if (null == unitSize) {
                            unitSize = new Character(currChar);
                            break;
                        }
                        this.out.error("first letter after \"x/\" was a unit size character; second letter (if specified) must be a display format letter but it was also a unit size character");
                        return;
                    }
                    default: {
                        if (null == displayFormat) {
                            displayFormat = new Character(currChar);
                            break;
                        }
                        this.out.error("first letter after \"x/\" was a display format character; second letter (if specified) must be a unit size letter but it was also a display format character");
                        return;
                    }
                }
                ++i;
            }
            if (arg.length() != i) {
                this.out.error("too many letters after \"x/\"; the \"x/\" command accepts at most two letters, a display format character and a unit size character");
                return;
            }
            if (null == unitSize) {
                unitSize = this.getDefaultUnitSize(properties);
            } else {
                this.setDefaultUnitSize(properties, unitSize);
            }
            if (null == displayFormat) {
                displayFormat = this.getDefaultDisplayFormat(properties);
            } else {
                this.setDefaultDisplayFormat(properties, displayFormat);
            }
        }
        Integer nUnitSize = null;
        char cUnitSize = unitSize.charValue();
        switch (cUnitSize) {
            case 'b': {
                nUnitSize = new Integer(1);
                break;
            }
            case 'h': {
                nUnitSize = new Integer(2);
                break;
            }
            case 'w': {
                nUnitSize = new Integer(4);
                break;
            }
            case 'g': {
                nUnitSize = new Integer(8);
            }
        }
        args.push(nUnitSize);
        args.push(new Integer(n));
        args.push(displayFormat.toString());
        super.doCommand(args, loadedImage, properties);
    }

    private Character getDefaultUnitSize(HashMap properties) {
        Character defaultUnitSize = (Character)properties.get("x_default_unit_size");
        if (null == defaultUnitSize) {
            return new Character('w');
        }
        return defaultUnitSize;
    }

    private Character getDefaultDisplayFormat(HashMap properties) {
        Character defaultDisplayFormat = (Character)properties.get("x_default_display_format");
        if (null == defaultDisplayFormat) {
            return new Character('x');
        }
        return defaultDisplayFormat;
    }

    private void setDefaultUnitSize(HashMap properties, Character defaultUnitSize) {
        properties.put("x_default_unit_size", defaultUnitSize);
    }

    private void setDefaultDisplayFormat(HashMap properties, Character defaultDisplayFormat) {
        properties.put("x_default_display_format", defaultDisplayFormat);
    }
}

