/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Stack;

public class HexdumpCommand
extends Command {
    public HexdumpCommand(Output o) {
        super(o, "hexdump", "outputs a section of memory in a hexdump-like format", "parameters: <hex_address> <bytes_to_print>\n\noutputs <bytes_to_print> bytes of memory contents starting from <hex_address>");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        long i;
        Long address;
        StringBuffer stringBuffer = new StringBuffer();
        ImageAddressSpace imageAddressSpace = Utils._extractAddressSpace(loadedImage);
        long addressInDecimal = 0L;
        int numBytesToPrint = 256;
        int asciiIndex = 0;
        if (!args.isEmpty()) {
            address = Utils.longFromString((String)args.pop());
            if (null == address) {
                this.out.error("Specified address is invalid");
                return;
            }
        } else {
            this.out.error("\"hexdump\" requires at least an address parameter");
            return;
        }
        addressInDecimal = address;
        if (!args.isEmpty()) {
            try {
                numBytesToPrint = Integer.parseInt((String)args.pop());
            }
            catch (NumberFormatException nfe) {
                this.out.error("Specified length is invalid");
                return;
            }
        }
        ImagePointer imagePointerBase = imageAddressSpace.getPointer(addressInDecimal);
        String asciiChars = "";
        for (i = 0L; i < (long)numBytesToPrint; ++i) {
            ImagePointer imagePointer = imagePointerBase.add(i);
            try {
                String fixedHexString;
                Byte byteValue = new Byte(imagePointer.getByteAt(0L));
                asciiIndex = byteValue.byteValue();
                if (asciiIndex < 0) {
                    asciiIndex += 256;
                }
                String rawHexString = Integer.toHexString(byteValue.intValue());
                String hexText = fixedHexString = this.fixHexStringLength(rawHexString);
                if (0L == i % 4L) {
                    hexText = " " + hexText;
                }
                if (0L == i % 16L) {
                    hexText = "\n" + Long.toHexString(imagePointer.getAddress()) + ":" + hexText;
                    asciiChars = "  |";
                }
                stringBuffer.append(hexText);
                asciiChars = asciiChars + "................................ !\"#$%&'()*+'-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~.................................................................................................................................".substring(asciiIndex, asciiIndex + 1);
                if (15L != i % 16L || i == 0L) continue;
                asciiChars = asciiChars + "|";
                stringBuffer.append(asciiChars);
                continue;
            }
            catch (MemoryAccessException e) {
                this.out.error("Address not in memory - 0x" + Long.toHexString(imagePointer.getAddress()));
                return;
            }
            catch (CorruptDataException e) {
                this.out.error("Dump data is corrupted");
                return;
            }
        }
        long undisplayedBytes = 16L - i % 16L;
        if (16L != undisplayedBytes) {
            stringBuffer.append(this.padSpace(undisplayedBytes, asciiChars));
        }
        stringBuffer.append("\n");
        this.out.println(new String(stringBuffer));
        properties.put("currentMemPtrAddress", new Long(addressInDecimal));
        properties.put("currentNumBytes", new Integer(numBytesToPrint));
    }

    private String padSpace(long undisplayedBytes, String asciiChars) {
        int i = 0;
        while ((long)i < 2L * undisplayedBytes + undisplayedBytes / 4L) {
            asciiChars = " " + asciiChars;
            ++i;
        }
        return asciiChars;
    }

    private String fixHexStringLength(String rawHexString) {
        int length = rawHexString.length();
        if (1 == length) {
            return "0" + rawHexString;
        }
        if (2 == length) {
            return rawHexString;
        }
        if (8 == length) {
            return rawHexString.substring(6, 8);
        }
        return "ERROR fixHexStringLength";
    }
}

