/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.Image;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.FindCommand;
import com.ibm.jvm.dtfjview.commands.RootCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Stack;

public class FindNextCommand
extends Command {
    public FindNextCommand(Output o) {
        super(o, "findnext", "finds the next instance of the last string passed to \"find\"", "parameters: none\n\nThe findnext command is used in conjunction with find or findptr command to continue searching for upcoming matches. It repeats the previous find or findptr command (depending on which command is most recently issued) starting from the last match.");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        RootCommand rootCommand = (RootCommand)properties.get("RootCommandObject");
        if (null == rootCommand) {
            this.out.error("ERROR - No mapping found for RootCommand object");
            return;
        }
        FindCommand.FindAttribute findAtt = (FindCommand.FindAttribute)properties.get("FindAttributes");
        if (null == findAtt) {
            this.out.println("No find command has been executed.");
            return;
        }
        String startAddress = Long.toHexString(findAtt.lastMatch + 1L);
        String endAddress = Long.toHexString(findAtt.endAddress);
        Stack findCommandStack = Utils.constructStackFromString("find " + findAtt.pattern + "," + startAddress + "," + endAddress + "," + findAtt.boundary + "," + findAtt.numBytesToPrint + "," + findAtt.numMatchesToDisplay);
        rootCommand.doCommand(findCommandStack, loadedImage, properties);
    }
}

