/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.RootCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class FindCommand
extends Command {
    static final int text = 1;
    static final int binary = 2;
    FindAttribute findAtt = new FindAttribute();
    StringBuffer sb = new StringBuffer();
    ArrayList matches = new ArrayList();

    public FindCommand(Output o) {
        super(o, "find", "searches memory for a given string", "parameters, comma separated: <pattern>,<start_address>,<end_address>,<memory_boundary>,<bytes_to_print>,<matches_to_display>\n\nthe find command searches for <pattern> in the memory segment from <start_address> to <end_address> inclusive, matching only addresses that start at the specified <memory_boundary>, for example 1,2,4 or 8 bytes. It displays <bytes_to_print> bytes from the final match, and lists the first <matches_to_display> matches found.\n example: find J9,,,,64,3");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        ImageSection imageSection;
        String argsConcact = Utils.concatArgsFromStack(args);
        String[] params = argsConcact.split(",", -1);
        this.sb = new StringBuffer();
        this.matches.clear();
        if (!this.isParametersValid(args, params)) {
            return;
        }
        this.determineModeFromPattern();
        if (!this.parseParams(args, params)) {
            return;
        }
        Iterator imageSections = Utils.getAddressSapceSectionInfo(loadedImage);
        while (imageSections.hasNext() && this.matches.size() <= this.findAtt.numMatchesToDisplay && !this.scanImageSection(imageSection = (ImageSection)imageSections.next())) {
        }
        if (this.matches.size() > 0) {
            this.findAtt.lastMatch = (Long)this.matches.get(this.matches.size() - 1);
        }
        properties.put("FindAttributes", this.findAtt);
        this.doPrint();
        if (this.matches.size() > 0) {
            this.printLastMatchContent(loadedImage, properties);
        }
        this.restoreHexPrefix();
    }

    private void restoreHexPrefix() {
        if (this.findAtt.mode == 2) {
            this.findAtt.pattern = "0x" + this.findAtt.pattern;
        }
    }

    private void printLastMatchContent(Image loadedImage, HashMap properties) {
        RootCommand rootCommand = (RootCommand)properties.get("RootCommandObject");
        if (null == rootCommand) {
            this.out.error("ERROR - No mapping found for RootCommand object");
            return;
        }
        Stack hexdumpCommandStack = Utils.constructStackFromString("hexdump " + Long.toHexString(this.findAtt.lastMatch) + " " + this.findAtt.numBytesToPrint);
        rootCommand.doCommand(hexdumpCommandStack, loadedImage, properties);
    }

    private void doPrint() {
        int size = this.matches.size();
        if (0 == size) {
            this.sb.append("No matches found.\n");
        } else {
            int limit = Math.min(this.findAtt.numMatchesToDisplay, size);
            for (int i = 0; i < limit; ++i) {
                long match = (Long)this.matches.get(i);
                this.sb.append("#" + i + ": " + "0x" + Long.toHexString(match) + "\n");
            }
        }
        this.out.print(new String(this.sb));
    }

    private boolean scanImageSection(ImageSection imageSection) {
        long imageStartAddress = imageSection.getBaseAddress().getAddress();
        long imageEndAddress = imageStartAddress + imageSection.getSize() - 1L;
        if (this.findAtt.startAddress < imageStartAddress && this.findAtt.endAddress < imageStartAddress) {
            return false;
        }
        if (this.findAtt.startAddress > imageEndAddress && this.findAtt.endAddress > imageEndAddress) {
            return false;
        }
        if (this.findAtt.startAddress >= imageStartAddress && this.findAtt.endAddress <= imageEndAddress) {
            return this.scanRegion(this.findAtt.startAddress, this.findAtt.endAddress, imageSection);
        }
        if (this.findAtt.startAddress <= imageStartAddress && this.findAtt.endAddress <= imageEndAddress && this.findAtt.endAddress >= imageStartAddress) {
            return this.scanRegion(imageStartAddress, this.findAtt.endAddress, imageSection);
        }
        if (this.findAtt.startAddress <= imageEndAddress && this.findAtt.startAddress >= imageStartAddress && this.findAtt.endAddress >= imageEndAddress) {
            return this.scanRegion(this.findAtt.startAddress, imageEndAddress, imageSection);
        }
        return this.scanRegion(imageStartAddress, imageEndAddress, imageSection);
    }

    private boolean scanRegion(long start, long end, ImageSection imageSection) {
        ImagePointer imagePointer = imageSection.getBaseAddress();
        int patternLength = this.findAtt.length();
        byte[] bytes = this.findAtt.getBytes();
        for (long i = 0L != start % (long)this.findAtt.boundary ? start - start % (long)this.findAtt.boundary + (long)this.findAtt.boundary : start; i <= end; i += (long)this.findAtt.boundary) {
            int j;
            for (j = 0; j < patternLength; ++j) {
                byte oneByte = bytes[j];
                if (this.getByteFromImage(imagePointer, i + (long)j) != oneByte) break;
            }
            if (j < patternLength) continue;
            this.matches.add(new Long(i));
            if (this.matches.size() != this.findAtt.numMatchesToDisplay) continue;
            return true;
        }
        return false;
    }

    private byte getByteFromImage(ImagePointer imagePointer, long address) {
        long imagePointerBaseAddress = imagePointer.getAddress();
        try {
            return imagePointer.getByteAt(address - imagePointerBaseAddress);
        }
        catch (CorruptDataException cde) {
            return 0;
        }
        catch (MemoryAccessException mae) {
            this.out.error("MemoryAccessException occurred at 0x" + Long.toHexString(address));
            return 0;
        }
    }

    private boolean parseParams(Stack args, String[] params) {
        this.findAtt.startAddress = params[1].equals("") ? 0L : Utils.longFromString(params[1]);
        this.findAtt.endAddress = params[2].equals("") ? Long.MAX_VALUE : Utils.longFromString(params[2]);
        if (this.findAtt.startAddress > this.findAtt.endAddress) {
            this.out.error("start address must not be greater than end address");
            this.printHelp("\t", 10, new Stack(), args);
            return false;
        }
        if (params[3].equals("")) {
            this.findAtt.boundary = 1;
        } else {
            this.findAtt.boundary = Integer.parseInt(params[3]);
            if (this.findAtt.boundary <= 0) {
                this.out.error("memory boundary must be a positive non-zero value");
                this.printHelp("\t", 10, new Stack(), args);
                return false;
            }
        }
        if (params[4].equals("")) {
            this.findAtt.numBytesToPrint = 256;
        } else {
            this.findAtt.numBytesToPrint = Integer.parseInt(params[4]);
            if (this.findAtt.numBytesToPrint < 0) {
                this.out.error("bytes to print must be a non-negative value");
                this.printHelp("\t", 10, new Stack(), args);
                return false;
            }
        }
        if (params[5].equals("")) {
            this.findAtt.numMatchesToDisplay = 1;
        } else {
            this.findAtt.numMatchesToDisplay = Integer.parseInt(params[5]);
            if (this.findAtt.numMatchesToDisplay < 0) {
                this.out.error("matches to display must be a non-negative value");
                this.printHelp("\t", 10, new Stack(), args);
                return false;
            }
        }
        return true;
    }

    private void determineModeFromPattern() {
        if (this.findAtt.pattern.startsWith("0x")) {
            this.findAtt.pattern = this.findAtt.pattern.substring(2);
            this.findAtt.mode = 2;
            this.allignBits();
        } else {
            this.findAtt.mode = 1;
        }
    }

    private void allignBits() {
        int patternLength = this.findAtt.pattern.length();
        if (0 != patternLength % 2) {
            this.findAtt.pattern = "0" + this.findAtt.pattern;
        }
    }

    private boolean isParametersValid(Stack args, String[] params) {
        if (6 != params.length) {
            this.out.error("incorrect number of parameters");
            this.printHelp("\t", 10, new Stack(), args);
            return false;
        }
        this.findAtt.pattern = params[0];
        if (this.findAtt.pattern.equals("")) {
            this.out.error("missing search pattern string");
            this.printHelp("\t", 10, new Stack(), args);
            return false;
        }
        return true;
    }

    class FindAttribute {
        String pattern;
        long startAddress;
        long endAddress;
        int boundary;
        int numBytesToPrint;
        int numMatchesToDisplay;
        long lastMatch;
        int mode;

        FindAttribute() {
        }

        public int length() {
            if (this.mode == 2) {
                return this.pattern.length() / 2;
            }
            return this.pattern.length();
        }

        public byte[] getBytes() {
            if (this.mode == 1) {
                return this.pattern.getBytes();
            }
            byte[] result = new byte[this.length()];
            for (int i = 0; i < this.length(); ++i) {
                result[i] = (byte)Integer.parseInt(this.pattern.substring(i * 2, i * 2 + 2), 16);
            }
            return result;
        }
    }
}

