/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.MonitorNode;
import com.ibm.jvm.dtfjview.commands.helpers.NodeList;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;

public class DeadlockCommand
extends Command {
    public DeadlockCommand(Output o) {
        super(o, "deadlock", "displays information about deadlocks if there are any", "parameters: none\n\nThe \"deadlock\" command shows detailed information about deadlocks or \"no deadlocks detected\" if there are no deadlocks.  A deadlock situation consists of one or more deadlock loops and zero or more branches attached to those loops.  This command prints out each branch attached to a loop and then the loop itself.  If there is a split in a deadlock branch, separate branches will be created for each side of the split in the branch.  Deadlock branches start with a monitor that has no threads waiting on it and the continues until it reaches a monitor that exists in another deadlock branch or loop.  Deadlock loops start and end with the same monitor.\n\nMonitors are represented by their owner and the object associated with the given monitor.  For example, \"3435 (0x45ae67)\" represents the monitor that is owned by the thread with id 3435 and is associated the object at address 0x45ae67.  Objects can be viewed by using a command like \"x/j 0x45ae67\" and threads can be viewed using a command like \"info thread 3435\".\n");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        Iterator itRuntime = Utils.getRuntimes(loadedImage);
        int jrnum = 1;
        while (itRuntime.hasNext()) {
            TreeMap<Long, MonitorNode> monitorNodes = new TreeMap<Long, MonitorNode>();
            JavaRuntime jr = (JavaRuntime)itRuntime.next();
            Iterator itMonitor = jr.getMonitors();
            int nodeListNum = 0;
            this.out.print("\n  deadlocks for runtime #" + jrnum + "\n");
            while (itMonitor.hasNext()) {
                JavaObject threadObject;
                JavaMonitor monitor = (JavaMonitor)itMonitor.next();
                MonitorNode node = new MonitorNode(monitor);
                JavaThread owner = null;
                Long id = null;
                try {
                    owner = monitor.getOwner();
                }
                catch (CorruptDataException e) {
                    this.out.error("exception encountered while getting monitor owner: " + Exceptions.getCorruptDataExceptionString());
                    return;
                }
                if (null == owner) continue;
                try {
                    threadObject = owner.getObject();
                }
                catch (CorruptDataException e) {
                    this.out.error("exception encountered while getting owner's JavaObject: " + Exceptions.getCorruptDataExceptionString());
                    return;
                }
                id = new Long(threadObject.getID().getAddress());
                monitorNodes.put(id, node);
            }
            for (MonitorNode currNode : monitorNodes.values()) {
                JavaMonitor currMonitor = currNode.getMonitor();
                Iterator itWaiters = currMonitor.getEnterWaiters();
                while (itWaiters.hasNext()) {
                    JavaObject threadObject;
                    JavaThread waiter = (JavaThread)itWaiters.next();
                    Long id = null;
                    try {
                        threadObject = waiter.getObject();
                    }
                    catch (CorruptDataException e) {
                        this.out.error("exception encountered while getting waiter's ImageThread: " + Exceptions.getCorruptDataExceptionString());
                        return;
                    }
                    id = new Long(threadObject.getID().getAddress());
                    MonitorNode waiterNode = (MonitorNode)monitorNodes.get(id);
                    if (null == waiterNode) continue;
                    waiterNode.waitingOn = currNode;
                }
            }
            Iterator values = monitorNodes.values().iterator();
            int visit = 1;
            Vector<NodeList> lists = new Vector<NodeList>();
            while (values.hasNext()) {
                MonitorNode startNode;
                MonitorNode currNode = startNode = (MonitorNode)values.next();
                if (0 != startNode.visit) continue;
                while (true) {
                    MonitorNode endNode;
                    currNode.visit = visit;
                    if (null == currNode.waitingOn) {
                        currNode.deadlock = 1;
                        break;
                    }
                    if (this.isDeadlocked(currNode.waitingOn)) {
                        NodeList split;
                        endNode = currNode.waitingOn;
                        currNode = startNode;
                        NodeList branchList = null;
                        while (currNode != endNode) {
                            if (null == branchList) {
                                branchList = new NodeList(currNode, nodeListNum++);
                            }
                            currNode.deadlock = 3;
                            currNode = currNode.waitingOn;
                            branchList.add(currNode);
                            if (currNode == endNode) continue;
                            currNode.inList = branchList;
                        }
                        if (endNode.inList.isLoop()) {
                            lists.insertElementAt(branchList, lists.indexOf(endNode.inList));
                            break;
                        }
                        NodeList oldList = endNode.inList;
                        if (null == (split = endNode.inList.attachOrSplit(branchList, nodeListNum++))) break;
                        lists.insertElementAt(split, lists.indexOf(oldList));
                        lists.insertElementAt(branchList, lists.indexOf(oldList));
                        break;
                    }
                    if (currNode.waitingOn.visit == visit) {
                        currNode = endNode = currNode.waitingOn;
                        NodeList loopList = new NodeList(currNode, nodeListNum++);
                        lists.insertElementAt(loopList, 0);
                        do {
                            currNode.deadlock = 2;
                            currNode = currNode.waitingOn;
                            loopList.add(currNode);
                            currNode.inList = loopList;
                        } while (currNode != endNode);
                        currNode = startNode;
                        NodeList branchList = null;
                        while (currNode != endNode) {
                            if (null == branchList) {
                                branchList = new NodeList(currNode, nodeListNum++);
                                lists.insertElementAt(branchList, 0);
                            }
                            currNode.deadlock = 3;
                            currNode = currNode.waitingOn;
                            branchList.add(currNode);
                            if (currNode == endNode) continue;
                            currNode.inList = branchList;
                        }
                        break;
                    }
                    currNode = currNode.waitingOn;
                }
                ++visit;
            }
            if (lists.isEmpty()) {
                this.out.print("\n");
                this.out.print("\t no deadlocks detected");
                this.out.print("\n");
                return;
            }
            boolean lastListWasLoop = true;
            for (NodeList list : lists) {
                if (list.isLoop()) {
                    this.out.print("\n    deadlock loop:\n");
                    lastListWasLoop = true;
                } else if (lastListWasLoop) {
                    this.out.print("\n\n    deadlock branch(es):\n");
                    lastListWasLoop = false;
                }
                this.out.print("\t  " + list.toString());
                this.out.print("\n");
            }
            this.out.print("\n");
            ++jrnum;
        }
    }

    private boolean isDeadlocked(MonitorNode node) {
        return 2 == node.deadlock || 3 == node.deadlock;
    }
}

