/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.Image;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.File;
import java.util.HashMap;
import java.util.Stack;

public class CdCommand
extends Command {
    public CdCommand(Output o) {
        super(o, "cd", "changes the current working directory, used for log files", "parameters: <directory_name>\n\nChanges the current working directory to <directory_name>, checking to see if it exists and is a directory before making the change.  The current working directory is where log files are outputted to; a change to the current working directory has no effect on the current log file setting because the logging filename is converted to an absolute path when set.  Note: to see what the current working directory is set to, use the \"pwd\" command.\n");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        if (args.isEmpty()) {
            this.out.error("\"cd\" requires exactly one parameter");
            return;
        }
        String path = "";
        while (!args.isEmpty()) {
            path = path + (String)args.pop() + " ";
        }
        File newPwd = Utils.absPath(properties, path = path.substring(0, path.length() - 1));
        if (!newPwd.isDirectory()) {
            if (newPwd.isFile()) {
                this.out.error("cannot change to specified path because it specifies a file, not a directory");
            } else {
                this.out.error("specified path is not a directory or a file; it probably doesn't exist");
            }
        } else {
            properties.put("pwd", newPwd);
        }
    }
}

