/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageFactory;
import com.ibm.jvm.dtfjview.ConsoleOutputChannel;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.Version;
import com.ibm.jvm.dtfjview.commands.RootCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Stack;

public class Session {
    private String factoryName = System.getProperty("com.ibm.dtfj.image.factoryclass", "com.ibm.dtfj.image.j9.ImageFactory");
    private Image loadedImage;
    private RootCommand rootCommand;
    private HashMap variables;
    private Output out;
    private static final String defaultFactoryName = "com.ibm.dtfj.image.j9.ImageFactory";
    private static final String factoryProperty = "com.ibm.dtfj.image.factoryclass";
    private static final String launcherProperty = "com.ibm.jvm.dtfjview.launcher";

    public Session(String[] args) {
        this.sessionInit(args);
    }

    private void sessionInit(String[] args) {
        this.variables = new HashMap();
        this.out = new Output();
        this.out.addChannel(new ConsoleOutputChannel());
        this.rootCommand = new RootCommand(this.out);
        this.variables.put("RootCommandObject", this.rootCommand);
        this.variables.put("pwd", new File(System.getProperty("user.dir")));
        this.loadedImage = this.imageFromCommandLine(args);
    }

    private ImageFactory getFactory() {
        try {
            Class<?> factoryClass = Class.forName(this.factoryName);
            return (ImageFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.out.error("ClassNotFoundException while getting ImageFactory: " + e.getMessage());
            this.out.error("Use -Dcom.ibm.dtfj.image.factoryclass=<classname> to change the ImageFactory");
            return null;
        }
        catch (InstantiationException e) {
            this.out.error("InstantiationException while getting ImageFactory: " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            this.out.error("IllegalAccessException while getting ImageFactory: " + e.getMessage());
            return null;
        }
    }

    private Image imageFromCommandLine(String[] args) {
        Image loadedImage;
        block11: {
            loadedImage = null;
            int coreFilePathIndex = this.indexOf("-core", args) + 1;
            int xmlFilePathIndex = this.indexOf("-xml", args) + 1;
            int zipFilePathIndex = this.indexOf("-zip", args) + 1;
            int terseVersionIndex = this.indexOf("-v", args) + 1;
            int verboseVersionIndex = this.indexOf("--version", args) + 1;
            int verboseIndex = this.indexOf("-verbose", args) + 1;
            ImageFactory factory = this.getFactory();
            if (factory == null) {
                return null;
            }
            if (0 != verboseIndex) {
                this.variables.put("verbose.mode", "on");
            }
            if (0 != terseVersionIndex || 0 != verboseVersionIndex) {
                this.out.println(Version.getAllVersionInfo(factory));
                return null;
            }
            String launcher = System.getProperty(launcherProperty, "dtfjview");
            if (zipFilePathIndex == 0 && coreFilePathIndex == 0 || 0 != zipFilePathIndex && args.length <= zipFilePathIndex || 0 != coreFilePathIndex && args.length <= coreFilePathIndex) {
                this.out.print("\n\tUsage: \"" + launcher + " -core <core_file> [-xml <xml_file>]\" or \n" + "\t \"" + launcher + " -zip <zip_file>\" or \n" + "\t \"" + launcher + " --version\" or \"" + launcher + " -v\"\n\n" + "\tNote: " + launcher + " requires both core and XML files. If the -xml option\n" + "\t is omitted the tool will search for the XML file based on the\n" + "\t core filename.\n\n" + "\tNote: The -core and/or -xml options may be used with the -zip\n" + "\t option to specify the core and XML files in the ZIP file; if\n" + "\t they are not specified, the tool will search for the\n" + "\t core and XML files based on the ZIP filename.\n\n" + "\tNote: The current ImageFactory is " + this.factoryName + ",\n" + "\t to change the ImageFactory use: \n" + "\t -D" + factoryProperty + "=<classname> \n\n");
                return null;
            }
            this.out.println(Version.getAllVersionInfo(factory));
            this.out.println("Loading image from DTFJ...\n");
            try {
                if (0 != zipFilePathIndex) {
                    loadedImage = factory.getImage(new File(args[zipFilePathIndex]));
                } else if (0 != coreFilePathIndex && 0 == xmlFilePathIndex) {
                    loadedImage = factory.getImage(new File(args[coreFilePathIndex]));
                } else if (0 != coreFilePathIndex && 0 != xmlFilePathIndex) {
                    loadedImage = factory.getImage(new File(args[coreFilePathIndex]), new File(args[xmlFilePathIndex]));
                }
            }
            catch (IOException e) {
                this.out.error("Could not load dump file and/or could not load XML file: " + e.getMessage());
                this.out.print("\tNote: " + launcher + " requires both core and XML files. If the -xml option\n" + "\t is omitted the tool will search for the XML file based on the\n" + "\t core filename.\n\n");
                if (null == this.variables.get("verbose.mode")) break block11;
                e.printStackTrace();
            }
        }
        return loadedImage;
    }

    private int indexOf(String string, String[] args) {
        int index = -1;
        for (int x = 0; x < args.length; ++x) {
            if (!string.equals(args[x])) continue;
            index = x;
            break;
        }
        return index;
    }

    public void run() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        String input = "";
        String quit = "";
        String prompt = "> ";
        Stack inputWordsStack = new Stack();
        if (null == this.loadedImage) {
            return;
        }
        this.variables.put("current_address_space", (ImageAddressSpace)this.loadedImage.getAddressSpaces().next());
        this.out.println("For a list of commands, type \"help\"; for how to use \"help\", type \"help help\"");
        while (quit == null || !quit.equals("on")) {
            this.out.printPrompt(prompt);
            try {
                input = stdin.readLine();
            }
            catch (IOException e) {
                this.out.error("IOException encountered while reading input; exiting program...");
                break;
            }
            if (null == input) {
                this.out.error("End of input stream has been reached; exiting program...");
                break;
            }
            String trimmedInput = input.trim();
            this.out.printInput(System.currentTimeMillis(), prompt, input);
            if (trimmedInput.equals("")) continue;
            inputWordsStack = Utils.constructStackFromString(trimmedInput);
            try {
                this.rootCommand.doCommand(inputWordsStack, this.loadedImage, this.variables);
            }
            catch (RuntimeException e) {
                this.out.error("An error occurred while processing the command: " + e);
                e.printStackTrace();
            }
            quit = (String)this.variables.get("quit");
        }
        this.out.close();
    }
}

